/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.replication.GlobalHiveSyncTool;

public class ReplicationStateSync
implements AutoCloseable {
    protected GlobalHiveSyncTool globalHiveSyncTool;
    private Map<String, Option<String>> replicatedTimeStampMap;
    private Map<String, Option<String>> oldReplicatedTimeStampMap;
    private final String clusterId;

    ReplicationStateSync(Properties props, HiveConf hiveConf, String uid) {
        this.globalHiveSyncTool = new GlobalHiveSyncTool(props, (Configuration)hiveConf);
        this.replicatedTimeStampMap = this.globalHiveSyncTool.getLastReplicatedTimeStampMap();
        this.clusterId = uid;
    }

    public void sync() throws Exception {
        this.replicatedTimeStampMap = this.globalHiveSyncTool.getLastReplicatedTimeStampMap();
        this.oldReplicatedTimeStampMap = this.replicatedTimeStampMap;
        this.globalHiveSyncTool.syncHoodieTable();
        this.replicatedTimeStampMap = this.globalHiveSyncTool.getLastReplicatedTimeStampMap();
    }

    public boolean rollback() {
        if (this.oldReplicatedTimeStampMap != null) {
            this.globalHiveSyncTool.setLastReplicatedTimeStamp(this.oldReplicatedTimeStampMap);
            this.oldReplicatedTimeStampMap = null;
        }
        return true;
    }

    public boolean replicationStateIsInSync(ReplicationStateSync other) {
        return this.globalHiveSyncTool.getLastReplicatedTimeStampMap().equals(other.globalHiveSyncTool.getLastReplicatedTimeStampMap());
    }

    public String toString() {
        return "{ clusterId: " + this.clusterId + " replicatedState: " + this.replicatedTimeStampMap + " }";
    }

    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public void close() {
        if (this.globalHiveSyncTool != null) {
            this.globalHiveSyncTool.close();
            this.globalHiveSyncTool = null;
        }
    }
}

