/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.storage.HoodieAvroFileReaderFactory;
import org.apache.hudi.io.storage.HoodieFileReader;

public class HoodieFileReaderFactory {
    public static HoodieFileReaderFactory getReaderFactory(HoodieRecord.HoodieRecordType recordType) {
        switch (recordType) {
            case AVRO: {
                return new HoodieAvroFileReaderFactory();
            }
            case SPARK: {
                try {
                    Class<?> clazz = ReflectionUtils.getClass("org.apache.hudi.io.storage.HoodieSparkFileReaderFactory");
                    return (HoodieFileReaderFactory)clazz.newInstance();
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    throw new HoodieException("Unable to create hoodie spark file writer factory", e);
                }
            }
        }
        throw new UnsupportedOperationException((Object)((Object)recordType) + " record type not supported yet.");
    }

    public HoodieFileReader getFileReader(Configuration conf, Path path) throws IOException {
        String extension = FSUtils.getFileExtension(path.toString());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return this.newParquetFileReader(conf, path);
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return this.newHFileFileReader(conf, path);
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return this.newOrcFileReader(conf, path);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    public HoodieFileReader getFileReader(Configuration conf, Path path, HoodieFileFormat format) throws IOException {
        return this.newParquetFileReader(conf, path);
    }

    protected HoodieFileReader newParquetFileReader(Configuration conf, Path path) {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileReader newHFileFileReader(Configuration conf, Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileReader newOrcFileReader(Configuration conf, Path path) {
        throw new UnsupportedOperationException();
    }

    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        throw new UnsupportedOperationException();
    }
}

