/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.hadoop.hbase.NoTagsByteBufferKeyValue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SizeCachedNoTagsByteBufferKeyValue
extends NoTagsByteBufferKeyValue {
    public static final int FIXED_OVERHEAD = 6;
    private short rowLen;
    private int keyLen;

    public SizeCachedNoTagsByteBufferKeyValue(ByteBuffer buf, int offset, int length, long seqId, int keyLen) {
        super(buf, offset, length);
        this.rowLen = super.getRowLength();
        this.keyLen = keyLen;
        this.setSequenceId(seqId);
    }

    public SizeCachedNoTagsByteBufferKeyValue(ByteBuffer buf, int offset, int length, long seqId, int keyLen, short rowLen) {
        super(buf, offset, length);
        this.rowLen = rowLen;
        this.keyLen = keyLen;
        this.setSequenceId(seqId);
    }

    @Override
    public short getRowLength() {
        return this.rowLen;
    }

    @Override
    public int getKeyLength() {
        return this.keyLen;
    }

    @Override
    public long heapSize() {
        return super.heapSize() + 6L;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

