/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncAdminRequestRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncBatchRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncMasterRequestRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncScanSingleRegionRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncServerRequestRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncSingleRequestRpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hudi.org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncRpcRetryingCallerFactory {
    private final AsyncConnectionImpl conn;
    private final Timer retryTimer;

    public AsyncRpcRetryingCallerFactory(AsyncConnectionImpl conn, Timer retryTimer) {
        this.conn = conn;
        this.retryTimer = retryTimer;
    }

    public <T> SingleRequestCallerBuilder<T> single() {
        return new SingleRequestCallerBuilder();
    }

    public ScanSingleRegionCallerBuilder scanSingleRegion() {
        return new ScanSingleRegionCallerBuilder();
    }

    public BatchCallerBuilder batch() {
        return new BatchCallerBuilder();
    }

    public <T> MasterRequestCallerBuilder<T> masterRequest() {
        return new MasterRequestCallerBuilder();
    }

    public <T> AdminRequestCallerBuilder<T> adminRequest() {
        return new AdminRequestCallerBuilder();
    }

    public <T> ServerRequestCallerBuilder<T> serverRequest() {
        return new ServerRequestCallerBuilder();
    }

    public class ServerRequestCallerBuilder<T>
    extends BuilderBase {
        private AsyncServerRequestRpcRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private ServerName serverName;

        public ServerRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public ServerRequestCallerBuilder<T> action(AsyncServerRequestRpcRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public ServerRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public ServerRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public ServerRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public ServerRequestCallerBuilder<T> pauseForCQTBE(long pause, TimeUnit unit) {
            this.pauseForCQTBENs = unit.toNanos(pause);
            return this;
        }

        public ServerRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public ServerRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public ServerRequestCallerBuilder<T> serverName(ServerName serverName) {
            this.serverName = serverName;
            return this;
        }

        public AsyncServerRequestRpcRetryingCaller<T> build() {
            return new AsyncServerRequestRpcRetryingCaller<T>(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt, Preconditions.checkNotNull(this.serverName, "serverName is null"), Preconditions.checkNotNull(this.callable, "action is null"));
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    public class AdminRequestCallerBuilder<T>
    extends BuilderBase {
        private AsyncAdminRequestRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private ServerName serverName;
        private int priority;

        public AdminRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public AdminRequestCallerBuilder<T> action(AsyncAdminRequestRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public AdminRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public AdminRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public AdminRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public AdminRequestCallerBuilder<T> pauseForCQTBE(long pause, TimeUnit unit) {
            this.pauseForCQTBENs = unit.toNanos(pause);
            return this;
        }

        public AdminRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public AdminRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public AdminRequestCallerBuilder<T> serverName(ServerName serverName) {
            this.serverName = serverName;
            return this;
        }

        public AdminRequestCallerBuilder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public AsyncAdminRequestRetryingCaller<T> build() {
            return new AsyncAdminRequestRetryingCaller<T>(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.priority, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt, Preconditions.checkNotNull(this.serverName, "serverName is null"), Preconditions.checkNotNull(this.callable, "action is null"));
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    public class MasterRequestCallerBuilder<T>
    extends BuilderBase {
        private AsyncMasterRequestRpcRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private int priority;

        public MasterRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
            this.priority = -1;
        }

        public MasterRequestCallerBuilder<T> action(AsyncMasterRequestRpcRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public MasterRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public MasterRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public MasterRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public MasterRequestCallerBuilder<T> pauseForCQTBE(long pause, TimeUnit unit) {
            this.pauseForCQTBENs = unit.toNanos(pause);
            return this;
        }

        public MasterRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public MasterRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public MasterRequestCallerBuilder<T> priority(TableName tableName) {
            this.priority = Math.max(this.priority, ConnectionUtils.getPriority(tableName));
            return this;
        }

        public MasterRequestCallerBuilder<T> priority(int priority) {
            this.priority = Math.max(this.priority, priority);
            return this;
        }

        private void preCheck() {
            Preconditions.checkNotNull(this.callable, "action is null");
        }

        public AsyncMasterRequestRpcRetryingCaller<T> build() {
            this.preCheck();
            return new AsyncMasterRequestRpcRetryingCaller<T>(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.callable, this.priority, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    public class BatchCallerBuilder
    extends BuilderBase {
        private TableName tableName;
        private List<? extends Row> actions;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;

        public BatchCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
        }

        public BatchCallerBuilder table(TableName tableName) {
            this.tableName = tableName;
            return this;
        }

        public BatchCallerBuilder actions(List<? extends Row> actions) {
            this.actions = actions;
            return this;
        }

        public BatchCallerBuilder operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public BatchCallerBuilder rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public BatchCallerBuilder pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public BatchCallerBuilder pauseForCQTBE(long pause, TimeUnit unit) {
            this.pauseForCQTBENs = unit.toNanos(pause);
            return this;
        }

        public BatchCallerBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public BatchCallerBuilder startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public <T> AsyncBatchRpcRetryingCaller<T> build() {
            return new AsyncBatchRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.tableName, this.actions, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public <T> List<CompletableFuture<T>> call() {
            return this.build().call();
        }
    }

    public class ScanSingleRegionCallerBuilder
    extends BuilderBase {
        private Long scannerId;
        private Scan scan;
        private ScanMetrics scanMetrics;
        private ScanResultCache resultCache;
        private AdvancedScanResultConsumer consumer;
        private ClientProtos.ClientService.Interface stub;
        private HRegionLocation loc;
        private boolean isRegionServerRemote;
        private long scannerLeaseTimeoutPeriodNs;
        private long scanTimeoutNs;
        private long rpcTimeoutNs;
        private int priority;

        public ScanSingleRegionCallerBuilder() {
            this.scannerId = null;
            this.priority = -1;
        }

        public ScanSingleRegionCallerBuilder id(long scannerId) {
            this.scannerId = scannerId;
            return this;
        }

        public ScanSingleRegionCallerBuilder setScan(Scan scan) {
            this.scan = scan;
            this.priority = scan.getPriority();
            return this;
        }

        public ScanSingleRegionCallerBuilder metrics(ScanMetrics scanMetrics) {
            this.scanMetrics = scanMetrics;
            return this;
        }

        public ScanSingleRegionCallerBuilder remote(boolean isRegionServerRemote) {
            this.isRegionServerRemote = isRegionServerRemote;
            return this;
        }

        public ScanSingleRegionCallerBuilder resultCache(ScanResultCache resultCache) {
            this.resultCache = resultCache;
            return this;
        }

        public ScanSingleRegionCallerBuilder consumer(AdvancedScanResultConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public ScanSingleRegionCallerBuilder stub(ClientProtos.ClientService.Interface stub) {
            this.stub = stub;
            return this;
        }

        public ScanSingleRegionCallerBuilder location(HRegionLocation loc) {
            this.loc = loc;
            return this;
        }

        public ScanSingleRegionCallerBuilder scannerLeaseTimeoutPeriod(long scannerLeaseTimeoutPeriod, TimeUnit unit) {
            this.scannerLeaseTimeoutPeriodNs = unit.toNanos(scannerLeaseTimeoutPeriod);
            return this;
        }

        public ScanSingleRegionCallerBuilder scanTimeout(long scanTimeout, TimeUnit unit) {
            this.scanTimeoutNs = unit.toNanos(scanTimeout);
            return this;
        }

        public ScanSingleRegionCallerBuilder rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public ScanSingleRegionCallerBuilder pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public ScanSingleRegionCallerBuilder pauseForCQTBE(long pause, TimeUnit unit) {
            this.pauseForCQTBENs = unit.toNanos(pause);
            return this;
        }

        public ScanSingleRegionCallerBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public ScanSingleRegionCallerBuilder startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        private void preCheck() {
            Preconditions.checkArgument(this.scannerId != null, "invalid scannerId %d", (Object)this.scannerId);
            Preconditions.checkNotNull(this.scan, "scan is null");
            Preconditions.checkNotNull(this.resultCache, "resultCache is null");
            Preconditions.checkNotNull(this.consumer, "consumer is null");
            Preconditions.checkNotNull(this.stub, "stub is null");
            Preconditions.checkNotNull(this.loc, "location is null");
            this.priority = ConnectionUtils.calcPriority(this.priority, this.loc.getRegion().getTable());
        }

        public AsyncScanSingleRegionRpcRetryingCaller build() {
            this.preCheck();
            return new AsyncScanSingleRegionRpcRetryingCaller(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.scan, this.scanMetrics, this.scannerId, this.resultCache, this.consumer, this.stub, this.loc, this.isRegionServerRemote, this.priority, this.scannerLeaseTimeoutPeriodNs, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.scanTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public CompletableFuture<Boolean> start(HBaseRpcController controller, ClientProtos.ScanResponse respWhenOpen) {
            return this.build().start(controller, respWhenOpen);
        }
    }

    public class SingleRequestCallerBuilder<T>
    extends BuilderBase {
        private TableName tableName;
        private byte[] row;
        private AsyncSingleRequestRpcRetryingCaller.Callable<T> callable;
        private long operationTimeoutNs;
        private long rpcTimeoutNs;
        private RegionLocateType locateType;
        private int replicaId;
        private int priority;

        public SingleRequestCallerBuilder() {
            this.operationTimeoutNs = -1L;
            this.rpcTimeoutNs = -1L;
            this.locateType = RegionLocateType.CURRENT;
            this.replicaId = 0;
            this.priority = -1;
        }

        public SingleRequestCallerBuilder<T> table(TableName tableName) {
            this.tableName = tableName;
            return this;
        }

        public SingleRequestCallerBuilder<T> row(byte[] row) {
            this.row = row;
            return this;
        }

        public SingleRequestCallerBuilder<T> action(AsyncSingleRequestRpcRetryingCaller.Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public SingleRequestCallerBuilder<T> operationTimeout(long operationTimeout, TimeUnit unit) {
            this.operationTimeoutNs = unit.toNanos(operationTimeout);
            return this;
        }

        public SingleRequestCallerBuilder<T> rpcTimeout(long rpcTimeout, TimeUnit unit) {
            this.rpcTimeoutNs = unit.toNanos(rpcTimeout);
            return this;
        }

        public SingleRequestCallerBuilder<T> locateType(RegionLocateType locateType) {
            this.locateType = locateType;
            return this;
        }

        public SingleRequestCallerBuilder<T> pause(long pause, TimeUnit unit) {
            this.pauseNs = unit.toNanos(pause);
            return this;
        }

        public SingleRequestCallerBuilder<T> pauseForCQTBE(long pause, TimeUnit unit) {
            this.pauseForCQTBENs = unit.toNanos(pause);
            return this;
        }

        public SingleRequestCallerBuilder<T> maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public SingleRequestCallerBuilder<T> startLogErrorsCnt(int startLogErrorsCnt) {
            this.startLogErrorsCnt = startLogErrorsCnt;
            return this;
        }

        public SingleRequestCallerBuilder<T> replicaId(int replicaId) {
            this.replicaId = replicaId;
            return this;
        }

        public SingleRequestCallerBuilder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        private void preCheck() {
            Preconditions.checkArgument(this.replicaId >= 0, "invalid replica id %s", this.replicaId);
            Preconditions.checkNotNull(this.tableName, "tableName is null");
            Preconditions.checkNotNull(this.row, "row is null");
            Preconditions.checkNotNull(this.locateType, "locateType is null");
            Preconditions.checkNotNull(this.callable, "action is null");
            this.priority = ConnectionUtils.calcPriority(this.priority, this.tableName);
        }

        public AsyncSingleRequestRpcRetryingCaller<T> build() {
            this.preCheck();
            return new AsyncSingleRequestRpcRetryingCaller<T>(AsyncRpcRetryingCallerFactory.this.retryTimer, AsyncRpcRetryingCallerFactory.this.conn, this.tableName, this.row, this.replicaId, this.locateType, this.callable, this.priority, this.pauseNs, this.pauseForCQTBENs, this.maxAttempts, this.operationTimeoutNs, this.rpcTimeoutNs, this.startLogErrorsCnt);
        }

        public CompletableFuture<T> call() {
            return this.build().call();
        }
    }

    private abstract class BuilderBase {
        protected long pauseNs;
        protected long pauseForCQTBENs;
        protected int maxAttempts;
        protected int startLogErrorsCnt;

        private BuilderBase() {
            this.pauseNs = ((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getPauseNs();
            this.pauseForCQTBENs = ((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getPauseForCQTBENs();
            this.maxAttempts = ConnectionUtils.retries2Attempts(((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getMaxRetries());
            this.startLogErrorsCnt = ((AsyncRpcRetryingCallerFactory)AsyncRpcRetryingCallerFactory.this).conn.connConf.getStartLogErrorsCnt();
        }
    }
}

