/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.CompressionState;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DiffKeyDeltaEncoder
extends BufferedDataBlockEncoder {
    static final int FLAG_SAME_KEY_LENGTH = 1;
    static final int FLAG_SAME_VALUE_LENGTH = 2;
    static final int FLAG_SAME_TYPE = 4;
    static final int FLAG_TIMESTAMP_IS_DIFF = 8;
    static final int MASK_TIMESTAMP_LENGTH = 112;
    static final int SHIFT_TIMESTAMP_LENGTH = 4;
    static final int FLAG_TIMESTAMP_SIGN = 128;

    private void uncompressSingleKeyValue(DataInputStream source, ByteBuffer buffer, DiffCompressionState state) throws IOException, EncoderBufferTooSmallException {
        int keyRestLength;
        byte flag;
        if (state.isFirst()) {
            state.familyLength = source.readByte();
            state.familyNameWithSize = new byte[(state.familyLength & 0xFF) + 1];
            state.familyNameWithSize[0] = state.familyLength;
            int read = source.read(state.familyNameWithSize, 1, state.familyLength);
            assert (read == state.familyLength);
        }
        int keyLength = ((flag = source.readByte()) & 1) != 0 ? state.keyLength : ByteBufferUtils.readCompressedInt(source);
        int valueLength = (flag & 2) != 0 ? state.valueLength : ByteBufferUtils.readCompressedInt(source);
        int commonPrefix = ByteBufferUtils.readCompressedInt(source);
        int keyOffset = buffer.position();
        DiffKeyDeltaEncoder.ensureSpace(buffer, keyLength + valueLength + 8);
        buffer.putInt(keyLength);
        buffer.putInt(valueLength);
        if (commonPrefix > 0) {
            ByteBufferUtils.copyFromBufferToBuffer(buffer, buffer, state.prevOffset + 8, commonPrefix);
        }
        if (state.isFirst() || commonPrefix < state.rowLength + 2) {
            int rowRestLength;
            short rowLength;
            if (commonPrefix < 2) {
                ByteBufferUtils.copyFromStreamToBuffer(buffer, source, 2 - commonPrefix);
                ByteBufferUtils.skip(buffer, -2);
                rowLength = buffer.getShort();
                rowRestLength = rowLength;
            } else {
                rowLength = buffer.getShort(keyOffset + 8);
                rowRestLength = rowLength + 2 - commonPrefix;
            }
            ByteBufferUtils.copyFromStreamToBuffer(buffer, source, rowRestLength);
            state.rowLength = rowLength;
            buffer.put(state.familyNameWithSize);
            keyRestLength = keyLength - rowLength - state.familyNameWithSize.length - 11;
        } else {
            keyRestLength = keyLength - commonPrefix - 9;
        }
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, keyRestLength);
        int timestampFitsInBytes = ((flag & 0x70) >>> 4) + 1;
        long timestamp = ByteBufferUtils.readLong(source, timestampFitsInBytes);
        if ((flag & 0x80) != 0) {
            timestamp = -timestamp;
        }
        if ((flag & 8) != 0) {
            timestamp = state.timestamp - timestamp;
        }
        buffer.putLong(timestamp);
        byte type = (flag & 4) != 0 ? state.type : source.readByte();
        buffer.put(type);
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, valueLength);
        state.keyLength = keyLength;
        state.valueLength = valueLength;
        state.prevOffset = keyOffset;
        state.timestamp = timestamp;
        state.type = type;
    }

    @Override
    public int internalEncode(Cell cell, HFileBlockDefaultEncodingContext encodingContext, DataOutputStream out) throws IOException {
        EncodingState state = encodingContext.getEncodingState();
        int size = this.compressSingleKeyValue(out, cell, state.prevCell);
        state.prevCell = cell;
        return size += this.afterEncodingKeyValue(cell, out, encodingContext);
    }

    private int compressSingleKeyValue(DataOutputStream out, Cell cell, Cell prevCell) throws IOException {
        int timestampFitsInBytes;
        long timestamp;
        int flag = 0;
        int kLength = KeyValueUtil.keyLength(cell);
        int vLength = cell.getValueLength();
        long diffTimestamp = 0L;
        int diffTimestampFitsInBytes = 0;
        int commonPrefix = 0;
        if (prevCell == null) {
            timestamp = cell.getTimestamp();
            if (timestamp < 0L) {
                flag |= 0x80;
                timestamp = -timestamp;
            }
            timestampFitsInBytes = ByteBufferUtils.longFitsIn(timestamp);
            flag |= timestampFitsInBytes - 1 << 4;
            byte familyLength = cell.getFamilyLength();
            out.write(familyLength);
            PrivateCellUtil.writeFamily(out, cell, familyLength);
        } else {
            boolean minusDiffTimestamp;
            boolean negativeTimestamp;
            int preKeyLength = KeyValueUtil.keyLength(prevCell);
            commonPrefix = PrivateCellUtil.findCommonPrefixInFlatKey(cell, prevCell, true, false);
            if (kLength == preKeyLength) {
                flag |= 1;
            }
            if (vLength == prevCell.getValueLength()) {
                flag |= 2;
            }
            if (cell.getTypeByte() == prevCell.getTypeByte()) {
                flag |= 4;
            }
            timestamp = cell.getTimestamp();
            diffTimestamp = prevCell.getTimestamp() - timestamp;
            boolean bl = negativeTimestamp = timestamp < 0L;
            if (negativeTimestamp) {
                timestamp = -timestamp;
            }
            timestampFitsInBytes = ByteBufferUtils.longFitsIn(timestamp);
            boolean bl2 = minusDiffTimestamp = diffTimestamp < 0L;
            if (minusDiffTimestamp) {
                diffTimestamp = -diffTimestamp;
            }
            if ((diffTimestampFitsInBytes = ByteBufferUtils.longFitsIn(diffTimestamp)) < timestampFitsInBytes) {
                flag |= diffTimestampFitsInBytes - 1 << 4;
                flag |= 8;
                if (minusDiffTimestamp) {
                    flag |= 0x80;
                }
            } else {
                flag |= timestampFitsInBytes - 1 << 4;
                if (negativeTimestamp) {
                    flag |= 0x80;
                }
            }
        }
        out.write(flag);
        if ((flag & 1) == 0) {
            ByteBufferUtils.putCompressedInt(out, kLength);
        }
        if ((flag & 2) == 0) {
            ByteBufferUtils.putCompressedInt(out, vLength);
        }
        ByteBufferUtils.putCompressedInt(out, commonPrefix);
        short rLen = cell.getRowLength();
        if (commonPrefix < rLen + 2) {
            PrivateCellUtil.writeRowKeyExcludingCommon(cell, rLen, commonPrefix, out);
            PrivateCellUtil.writeQualifier(out, cell, cell.getQualifierLength());
        } else {
            int commonQualPrefix = commonPrefix - (rLen + 2) - (cell.getFamilyLength() + 1);
            PrivateCellUtil.writeQualifierSkippingBytes(out, cell, cell.getQualifierLength(), commonQualPrefix);
        }
        if ((flag & 8) == 0) {
            ByteBufferUtils.putLong(out, timestamp, timestampFitsInBytes);
        } else {
            ByteBufferUtils.putLong(out, diffTimestamp, diffTimestampFitsInBytes);
        }
        if ((flag & 4) == 0) {
            out.write(cell.getTypeByte());
        }
        PrivateCellUtil.writeValue(out, cell, vLength);
        return kLength + vLength + 8;
    }

    @Override
    public Cell getFirstKeyCellInBlock(ByteBuff block) {
        block.mark();
        block.position(4);
        byte familyLength = block.get();
        block.skip(familyLength);
        byte flag = block.get();
        int keyLength = ByteBuff.readCompressedInt(block);
        ByteBuff.readCompressedInt(block);
        ByteBuff.readCompressedInt(block);
        ByteBuffer result = ByteBuffer.allocate(keyLength);
        assert (!result.isDirect());
        int pos = result.arrayOffset();
        block.get(result.array(), pos, 2);
        short rowLength = result.getShort();
        block.get(result.array(), pos += 2, (int)rowLength);
        int savePosition = block.position();
        block.position(4);
        block.get(result.array(), pos += rowLength, familyLength + 1);
        block.position(savePosition);
        int qualifierLength = keyLength - (pos += familyLength + 1) + result.arrayOffset() - 9;
        block.get(result.array(), pos, qualifierLength);
        pos += qualifierLength;
        int timestampFitInBytes = ((flag & 0x70) >>> 4) + 1;
        long timestamp = ByteBuff.readLong(block, timestampFitInBytes);
        if ((flag & 0x80) != 0) {
            timestamp = -timestamp;
        }
        result.putLong(pos, timestamp);
        block.get(result.array(), pos += 8, 1);
        block.reset();
        return new KeyValue.KeyOnlyKeyValue(result.array(), 0, keyLength);
    }

    public String toString() {
        return DiffKeyDeltaEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(HFileBlockDecodingContext decodingCtx) {
        return new DiffSeekerStateBufferedEncodedSeeker(decodingCtx);
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        DiffCompressionState state = new DiffCompressionState();
        while (source.available() > skipLastBytes) {
            this.uncompressSingleKeyValue(source, buffer, state);
            this.afterDecodingKeyValue(source, buffer, decodingCtx);
        }
        if (source.available() != skipLastBytes) {
            throw new IllegalStateException("Read too much bytes.");
        }
        return buffer;
    }

    private static class DiffSeekerStateBufferedEncodedSeeker
    extends BufferedDataBlockEncoder.BufferedEncodedSeeker<DiffSeekerState> {
        private byte[] familyNameWithSize;
        private static final int TIMESTAMP_WITH_TYPE_LENGTH = 9;

        private DiffSeekerStateBufferedEncodedSeeker(HFileBlockDecodingContext decodingCtx) {
            super(decodingCtx);
        }

        private void decode(boolean isFirst) {
            byte flag = this.currentBuffer.get();
            byte type = 0;
            if ((flag & 1) == 0) {
                if (!isFirst) {
                    type = ((DiffSeekerState)this.current).keyBuffer[((DiffSeekerState)this.current).keyLength - 1];
                }
                ((DiffSeekerState)this.current).keyLength = ByteBuff.readCompressedInt(this.currentBuffer);
            }
            if ((flag & 2) == 0) {
                ((DiffSeekerState)this.current).valueLength = ByteBuff.readCompressedInt(this.currentBuffer);
            }
            ((DiffSeekerState)this.current).lastCommonPrefix = ByteBuff.readCompressedInt(this.currentBuffer);
            ((DiffSeekerState)this.current).ensureSpaceForKey();
            if (((DiffSeekerState)this.current).lastCommonPrefix < 2) {
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).lastCommonPrefix, 2 - ((DiffSeekerState)this.current).lastCommonPrefix);
                ((DiffSeekerState)this.current).rowLengthWithSize = Bytes.toShort(((DiffSeekerState)this.current).keyBuffer, 0) + 2;
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, 2, ((DiffSeekerState)this.current).rowLengthWithSize - 2);
                System.arraycopy(this.familyNameWithSize, 0, ((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).rowLengthWithSize, this.familyNameWithSize.length);
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).rowLengthWithSize + this.familyNameWithSize.length, ((DiffSeekerState)this.current).keyLength - ((DiffSeekerState)this.current).rowLengthWithSize - this.familyNameWithSize.length - 9);
            } else if (((DiffSeekerState)this.current).lastCommonPrefix < ((DiffSeekerState)this.current).rowLengthWithSize) {
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).lastCommonPrefix, ((DiffSeekerState)this.current).rowLengthWithSize - ((DiffSeekerState)this.current).lastCommonPrefix);
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).rowLengthWithSize + this.familyNameWithSize.length, ((DiffSeekerState)this.current).keyLength - ((DiffSeekerState)this.current).rowLengthWithSize - this.familyNameWithSize.length - 9);
            } else {
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, ((DiffSeekerState)this.current).lastCommonPrefix, ((DiffSeekerState)this.current).keyLength - 9 - ((DiffSeekerState)this.current).lastCommonPrefix);
            }
            int pos = ((DiffSeekerState)this.current).keyLength - 9;
            int timestampFitInBytes = 1 + ((flag & 0x70) >>> 4);
            long timestampOrDiff = ByteBuff.readLong(this.currentBuffer, timestampFitInBytes);
            if ((flag & 0x80) != 0) {
                timestampOrDiff = -timestampOrDiff;
            }
            if ((flag & 8) == 0) {
                ((DiffSeekerState)this.current).timestamp = timestampOrDiff;
            } else {
                ((DiffSeekerState)this.current).timestamp = ((DiffSeekerState)this.current).timestamp - timestampOrDiff;
            }
            Bytes.putLong(((DiffSeekerState)this.current).keyBuffer, pos, ((DiffSeekerState)this.current).timestamp);
            pos += 8;
            if ((flag & 4) == 0) {
                this.currentBuffer.get(((DiffSeekerState)this.current).keyBuffer, pos, 1);
            } else if ((flag & 1) == 0) {
                ((DiffSeekerState)this.current).keyBuffer[pos] = type;
            }
            ((DiffSeekerState)this.current).valueOffset = this.currentBuffer.position();
            this.currentBuffer.skip(((DiffSeekerState)this.current).valueLength);
            if (this.includesTags()) {
                this.decodeTags();
            }
            ((DiffSeekerState)this.current).memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
            ((DiffSeekerState)this.current).nextKvOffset = this.currentBuffer.position();
        }

        @Override
        protected void decodeFirst() {
            this.currentBuffer.skip(4);
            byte familyNameLength = this.currentBuffer.get();
            this.familyNameWithSize = new byte[familyNameLength + 1];
            this.familyNameWithSize[0] = familyNameLength;
            this.currentBuffer.get(this.familyNameWithSize, 1, (int)familyNameLength);
            this.decode(true);
        }

        @Override
        protected void decodeNext() {
            this.decode(false);
        }

        @Override
        protected DiffSeekerState createSeekerState() {
            return new DiffSeekerState(this.tmpPair, this.includesTags());
        }
    }

    protected static class DiffSeekerState
    extends BufferedDataBlockEncoder.SeekerState {
        private int rowLengthWithSize;
        private long timestamp;

        public DiffSeekerState(ObjectIntPair<ByteBuffer> tmpPair, boolean includeTags) {
            super(tmpPair, includeTags);
        }

        @Override
        protected void copyFromNext(BufferedDataBlockEncoder.SeekerState that) {
            super.copyFromNext(that);
            DiffSeekerState other = (DiffSeekerState)that;
            this.rowLengthWithSize = other.rowLengthWithSize;
            this.timestamp = other.timestamp;
        }
    }

    protected static class DiffCompressionState
    extends CompressionState {
        long timestamp;
        byte[] familyNameWithSize;

        protected DiffCompressionState() {
        }

        @Override
        protected void readTimestamp(ByteBuffer in) {
            this.timestamp = in.getLong();
        }

        @Override
        void copyFrom(CompressionState state) {
            super.copyFrom(state);
            DiffCompressionState state2 = (DiffCompressionState)state;
            this.timestamp = state2.timestamp;
        }
    }
}

