/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MasterInitializationMonitor
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MasterInitializationMonitor.class);
    public static final String TIMEOUT_KEY = "hbase.master.initializationmonitor.timeout";
    public static final long TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
    public static final String HALT_KEY = "hbase.master.initializationmonitor.haltontimeout";
    public static final boolean HALT_DEFAULT = false;
    private final HMaster master;
    private final long timeout;
    private final boolean haltOnTimeout;

    MasterInitializationMonitor(HMaster master) {
        super("MasterInitializationMonitor");
        this.master = master;
        this.timeout = master.getConfiguration().getLong(TIMEOUT_KEY, TIMEOUT_DEFAULT);
        this.haltOnTimeout = master.getConfiguration().getBoolean(HALT_KEY, false);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (!this.master.isStopped() && this.master.isActiveMaster()) {
                Thread.sleep(this.timeout);
                if (this.master.isInitialized()) {
                    LOG.debug("Initialization completed within allotted tolerance. Monitor exiting.");
                    continue;
                }
                LOG.error("Master failed to complete initialization after " + this.timeout + "ms. Please consider submitting a bug report including a thread dump of this process.");
                if (!this.haltOnTimeout) continue;
                LOG.error("Zombie Master exiting. Thread dump to stdout");
                Threads.printThreadInfo(System.out, "Zombie HMaster");
                System.exit(-1);
            }
        }
        catch (InterruptedException ie) {
            LOG.trace("InitMonitor thread interrupted. Existing.");
        }
    }
}

