/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MasterDDLOperationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MasterDDLOperationHelper.class);

    private MasterDDLOperationHelper() {
    }

    public static void deleteColumnFamilyFromFileSystem(MasterProcedureEnv env, TableName tableName, List<RegionInfo> regionInfoList, byte[] familyName, boolean hasMob) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing family=" + Bytes.toString(familyName) + " from table=" + tableName);
        }
        for (RegionInfo hri : regionInfoList) {
            mfs.deleteFamilyFromFS(hri, familyName);
        }
        if (hasMob) {
            Path mobRootDir = new Path(mfs.getRootDir(), "mobdir");
            RegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(tableName);
            mfs.deleteFamilyFromFS(mobRootDir, mobRegionInfo, familyName);
        }
    }
}

