/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.clustering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.clustering.plan.strategy.FlinkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.util.StreamerUtil;

public class FlinkClusteringConfig
extends Configuration {
    @Parameter(names={"--help", "-h"}, help=true)
    public Boolean help = false;
    @Parameter(names={"--path"}, description="Base path for the target hoodie table.", required=true)
    public String path;
    @Parameter(names={"--clustering-delta-commits"}, description="Max delta commits needed to trigger clustering, default 1 commit")
    public Integer clusteringDeltaCommits = 1;
    @Parameter(names={"--clustering-tasks"}, description="Parallelism of tasks that do actual clustering, default is -1")
    public Integer clusteringTasks = -1;
    @Parameter(names={"--clean-retain-commits"}, description="Number of commits to retain. So data will be retained for num_of_commits * time_between_commits (scheduled).\nThis also directly translates into how much you can incrementally pull on this table, default 10")
    public Integer cleanRetainCommits = 10;
    @Parameter(names={"--archive-min-commits"}, description="Min number of commits to keep before archiving older commits into a sequential log, default 20.")
    public Integer archiveMinCommits = 20;
    @Parameter(names={"--archive-max-commits"}, description="Max number of commits to keep before archiving older commits into a sequential log, default 30.")
    public Integer archiveMaxCommits = 30;
    @Parameter(names={"--schedule", "-sc"}, description="Schedule the clustering plan in this job.\nDefault is false")
    public Boolean schedule = false;
    @Parameter(names={"--instant-time", "-it"}, description="Clustering Instant time")
    public String clusteringInstantTime = null;
    @Parameter(names={"--clean-async-enabled"}, description="Whether to cleanup the old commits immediately on new commits, disabled by default")
    public Boolean cleanAsyncEnable = false;
    @Parameter(names={"--plan-strategy-class"}, description="Config to provide a strategy class to generator clustering plan")
    public String planStrategyClass = FlinkSizeBasedClusteringPlanStrategy.class.getName();
    @Parameter(names={"--plan-partition-filter-mode"}, description="Partition filter mode used in the creation of clustering plan")
    public String planPartitionFilterMode = "NONE";
    @Parameter(names={"--target-file-max-bytes"}, description="Each group can produce 'N' (CLUSTERING_MAX_GROUP_SIZE/CLUSTERING_TARGET_FILE_SIZE) output file groups, default 1 GB")
    public Long targetFileMaxBytes = 0x40000000L;
    @Parameter(names={"--small-file-limit"}, description="Files smaller than the size specified here are candidates for clustering, default 600 MB")
    public Long smallFileLimit = 600L;
    @Parameter(names={"--skip-from-latest-partitions"}, description="Number of partitions to skip from latest when choosing partitions to create ClusteringPlan, default 0")
    public Integer skipFromLatestPartitions = 0;
    @Parameter(names={"--sort-columns"}, description="Columns to sort the data by when clustering.")
    public String sortColumns = "";
    @Parameter(names={"--sort-memory"}, description="Sort memory in MB, default 128MB.")
    public Integer sortMemory = 128;
    @Parameter(names={"--max-num-groups"}, description="Maximum number of groups to create as part of ClusteringPlan. Increasing groups will increase parallelism. default 30")
    public Integer maxNumGroups = 30;
    @Parameter(names={"--target-partitions"}, description="Number of partitions to list to create ClusteringPlan, default 2")
    public Integer targetPartitions = 2;
    @Parameter(names={"--cluster-begin-partition"}, description="Begin partition used to filter partition (inclusive)")
    public String clusterBeginPartition = "";
    @Parameter(names={"--cluster-end-partition"}, description="End partition used to filter partition (inclusive)")
    public String clusterEndPartition = "";
    @Parameter(names={"--partition-regex-pattern"}, description="Filter clustering partitions that matched regex pattern")
    public String partitionRegexPattern = "";
    @Parameter(names={"--partition-selected"}, description="Partitions to run clustering")
    public String partitionSelected = "";
    public static final String SEQ_FIFO = "FIFO";
    public static final String SEQ_LIFO = "LIFO";
    @Parameter(names={"--seq"}, description="Clustering plan execution sequence, two options are supported:\n1). FIFO: execute the oldest plan first, by default FIFO;\n2). LIFO: execute the latest plan first")
    public String clusteringSeq = "FIFO";
    @Parameter(names={"--service"}, description="Flink Clustering runs in service mode, disable by default")
    public Boolean serviceMode = false;
    @Parameter(names={"--min-clustering-interval-seconds"}, description="Min clustering interval of async clustering service, default 10 minutes")
    public Integer minClusteringIntervalSeconds = 600;
    @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed through command line using this parameter.")
    public List<String> configs = new ArrayList<String>();
    @Parameter(names={"--props"}, description="Path to properties file on localfs or dfs, with configurations for hoodie client, schema provider, key generator and data source. For hoodie client props, sane defaults are used, but recommend use to provide basic things like metrics endpoints, hive configs etc. For sources, referto individual classes, for supported properties.")
    public String propsFilePath = "";

    public static TypedProperties buildProperties(List<String> props) {
        TypedProperties properties = DFSPropertiesConfiguration.getGlobalProps();
        props.forEach(x -> {
            String[] kv = x.split("=");
            ValidationUtils.checkArgument(kv.length == 2);
            properties.setProperty(kv[0], kv[1]);
        });
        return properties;
    }

    public static TypedProperties getProps(FlinkClusteringConfig cfg) {
        return cfg.propsFilePath.isEmpty() ? FlinkClusteringConfig.buildProperties(cfg.configs) : StreamerUtil.readConfig(HadoopConfigurations.getHadoopConf(cfg), new Path(cfg.propsFilePath), cfg.configs).getProps();
    }

    public static Configuration toFlinkConfig(FlinkClusteringConfig config) {
        HashMap<Object, Object> propsMap = new HashMap<Object, Object>(FlinkClusteringConfig.getProps(config));
        Configuration conf = FlinkClusteringConfig.fromMap(propsMap);
        conf.setString(FlinkOptions.PATH, config.path);
        conf.setInteger(FlinkOptions.ARCHIVE_MAX_COMMITS, config.archiveMaxCommits.intValue());
        conf.setInteger(FlinkOptions.ARCHIVE_MIN_COMMITS, config.archiveMinCommits.intValue());
        conf.setInteger(FlinkOptions.CLEAN_RETAIN_COMMITS, config.cleanRetainCommits.intValue());
        conf.setInteger(FlinkOptions.CLUSTERING_DELTA_COMMITS, config.clusteringDeltaCommits.intValue());
        conf.setInteger(FlinkOptions.CLUSTERING_TASKS, config.clusteringTasks.intValue());
        conf.setString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLASS, config.planStrategyClass);
        conf.setString(FlinkOptions.CLUSTERING_PLAN_PARTITION_FILTER_MODE_NAME, config.planPartitionFilterMode);
        conf.setLong(FlinkOptions.CLUSTERING_PLAN_STRATEGY_TARGET_FILE_MAX_BYTES, config.targetFileMaxBytes.longValue());
        conf.setLong(FlinkOptions.CLUSTERING_PLAN_STRATEGY_SMALL_FILE_LIMIT, config.smallFileLimit.longValue());
        conf.setInteger(FlinkOptions.CLUSTERING_PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST, config.skipFromLatestPartitions.intValue());
        conf.setString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLUSTER_BEGIN_PARTITION, config.clusterBeginPartition);
        conf.setString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLUSTER_END_PARTITION, config.clusterEndPartition);
        conf.setString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_PARTITION_REGEX_PATTERN, config.partitionRegexPattern);
        conf.setString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_PARTITION_SELECTED, config.partitionSelected);
        conf.setString(FlinkOptions.CLUSTERING_SORT_COLUMNS, config.sortColumns);
        conf.setInteger(FlinkOptions.WRITE_SORT_MEMORY, config.sortMemory.intValue());
        conf.setInteger(FlinkOptions.CLUSTERING_MAX_NUM_GROUPS, config.maxNumGroups.intValue());
        conf.setInteger(FlinkOptions.CLUSTERING_TARGET_PARTITIONS, config.targetPartitions.intValue());
        conf.setBoolean(FlinkOptions.CLEAN_ASYNC_ENABLED, config.cleanAsyncEnable.booleanValue());
        conf.setBoolean(FlinkOptions.CLUSTERING_ASYNC_ENABLED, false);
        conf.setBoolean(FlinkOptions.CLUSTERING_SCHEDULE_ENABLED, config.schedule.booleanValue());
        HoodieTableConfig tableConfig = StreamerUtil.createMetaClient(conf).getTableConfig();
        conf.setBoolean(FlinkOptions.URL_ENCODE_PARTITIONING, Boolean.parseBoolean(tableConfig.getUrlEncodePartitioning()));
        conf.setBoolean(FlinkOptions.HIVE_STYLE_PARTITIONING, Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable()));
        return conf;
    }
}

