/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieCompactionHandler;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.CompactionExecutionHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LogCompactionExecutionHelper<T extends HoodieRecordPayload, I, K, O>
extends CompactionExecutionHelper<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(LogCompactionExecutionHelper.class);

    @Override
    protected void transitionRequestedToInflight(HoodieTable table, String logCompactionInstantTime) {
        HoodieActiveTimeline timeline = table.getActiveTimeline();
        HoodieInstant instant = HoodieTimeline.getLogCompactionRequestedInstant(logCompactionInstantTime);
        timeline.transitionLogCompactionRequestedToInflight(instant);
    }

    @Override
    protected String instantTimeToUseForScanning(String logCompactionInstantTime, String maxInstantTime) {
        return logCompactionInstantTime;
    }

    @Override
    protected boolean shouldPreserveCommitMetadata() {
        return true;
    }

    @Override
    protected Iterator<List<WriteStatus>> writeFileAndGetWriteStats(HoodieCompactionHandler compactionHandler, CompactionOperation operation, String instantTime, HoodieMergedLogRecordScanner scanner, Option<HoodieBaseFile> oldDataFileOpt) throws IOException {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        header.put(HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES, StringUtils.join(scanner.getValidBlockInstants(), ","));
        return compactionHandler.handleInsertsForLogCompaction(instantTime, operation.getPartitionPath(), operation.getFileId(), scanner.getRecords(), header);
    }

    @Override
    protected boolean enableOptimizedLogBlockScan(HoodieWriteConfig writeConfig) {
        return true;
    }
}

