/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.value.Value;

public abstract class GridH2ResultSetIterator<T>
extends GridCloseableIteratorAdapter<T> {
    private static final Field RESULT_FIELD;
    private static final long serialVersionUID = 0L;
    private final ResultInterface res;
    private final ResultSet data;
    protected final Object[] row;
    private final boolean closeStmt;
    private boolean hasRow;

    protected GridH2ResultSetIterator(ResultSet data, boolean closeStmt, boolean needCpy) throws IgniteCheckedException {
        this.data = data;
        this.closeStmt = closeStmt;
        try {
            this.res = needCpy ? (ResultInterface)RESULT_FIELD.get(data) : null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (data != null) {
            try {
                this.row = new Object[data.getMetaData().getColumnCount()];
            }
            catch (SQLException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        } else {
            this.row = null;
        }
    }

    private boolean fetchNext() {
        if (this.data == null) {
            return false;
        }
        try {
            if (!this.data.next()) {
                return false;
            }
            if (this.res != null) {
                Value[] values = this.res.currentRow();
                for (int c = 0; c < this.row.length; ++c) {
                    GridCacheContext<?, ?> cctx;
                    GridH2ValueCacheObject valCacheObj;
                    Value val = values[c];
                    this.row[c] = val instanceof GridH2ValueCacheObject ? valCacheObj.getObject((cctx = (valCacheObj = (GridH2ValueCacheObject)values[c]).getCacheContext()) != null && cctx.needValueCopy()) : val.getObject();
                }
            } else {
                for (int c = 0; c < this.row.length; ++c) {
                    this.row[c] = this.data.getObject(c + 1);
                }
            }
            return true;
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
    }

    public boolean onHasNext() {
        return this.hasRow || (this.hasRow = this.fetchNext());
    }

    public T onNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasRow = false;
        return this.createRow();
    }

    protected abstract T createRow();

    public void onRemove() {
        throw new UnsupportedOperationException();
    }

    public void onClose() throws IgniteCheckedException {
        if (this.data == null) {
            return;
        }
        if (this.closeStmt) {
            try {
                U.closeQuiet((AutoCloseable)this.data.getStatement());
            }
            catch (SQLException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        }
        U.closeQuiet((AutoCloseable)this.data);
    }

    public String toString() {
        return S.toString(GridH2ResultSetIterator.class, (Object)((Object)this));
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }
}

