/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.IOException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public class GridLuceneLockFactory
extends LockFactory {
    private final GridConcurrentHashSet<String> locks = new GridConcurrentHashSet();

    public Lock makeLock(String lockName) {
        return new LockImpl(lockName);
    }

    public void clearLock(String lockName) throws IOException {
        this.locks.remove((Object)lockName);
    }

    private class LockImpl
    extends Lock {
        private final String lockName;

        private LockImpl(String lockName) {
            this.lockName = lockName;
        }

        public boolean obtain() throws IOException {
            return GridLuceneLockFactory.this.locks.add((Object)this.lockName);
        }

        public void release() throws IOException {
            GridLuceneLockFactory.this.locks.remove((Object)this.lockName);
        }

        public boolean isLocked() throws IOException {
            return GridLuceneLockFactory.this.locks.contains((Object)this.lockName);
        }
    }
}

