/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.jetbrains.annotations.Nullable;

public abstract class GridMergeIndex
extends BaseIndex {
    private static final int MAX_FETCH_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_SQL_MERGE_TABLE_MAX_SIZE", (int)10000);
    private final AtomicInteger expRowsCnt = new AtomicInteger(0);
    private Map<UUID, Counter> remainingRows;
    private final AtomicBoolean lastSubmitted = new AtomicBoolean();
    private ArrayList<Row> fetched = new ArrayList();
    private int fetchedCnt;
    private final GridKernalContext ctx;

    public GridMergeIndex(GridKernalContext ctx, GridMergeTable tbl, String name, IndexType type, IndexColumn[] cols) {
        this.ctx = ctx;
        this.initBaseIndex((Table)tbl, 0, name, cols, type);
    }

    protected GridMergeIndex(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    public Set<UUID> sources() {
        return this.remainingRows.keySet();
    }

    protected final void checkSourceNodesAlive() {
        for (UUID nodeId : this.sources()) {
            if (this.ctx.discovery().alive(nodeId)) continue;
            this.fail(nodeId, null);
            return;
        }
    }

    public boolean hasSource(UUID nodeId) {
        return this.remainingRows.containsKey(nodeId);
    }

    public long getRowCount(Session ses) {
        return this.expRowsCnt.get();
    }

    public long getRowCountApproximation() {
        return this.getRowCount(null);
    }

    public void setSources(Collection<ClusterNode> nodes) {
        assert (this.remainingRows == null);
        this.remainingRows = U.newHashMap((int)nodes.size());
        for (ClusterNode node : nodes) {
            if (this.remainingRows.put(node.id(), new Counter()) == null) continue;
            throw new IllegalStateException("Duplicate node id: " + node.id());
        }
    }

    public void fail(final CacheException e) {
        for (UUID nodeId0 : this.remainingRows.keySet()) {
            this.addPage0(new GridResultPage(null, nodeId0, null){

                @Override
                public boolean isFail() {
                    return true;
                }

                @Override
                public void fetchNextPage() {
                    throw e;
                }
            });
        }
    }

    public void fail(UUID nodeId, final CacheException e) {
        this.addPage0(new GridResultPage(null, nodeId, null){

            @Override
            public boolean isFail() {
                return true;
            }

            @Override
            public void fetchNextPage() {
                if (e != null) {
                    throw e;
                }
                super.fetchNextPage();
            }
        });
    }

    public final void addPage(GridResultPage page) {
        int remainingRowsCount;
        int pageRowsCnt = page.rowsInPage();
        Counter cnt = this.remainingRows.get(page.source());
        int allRows = page.response().allRows();
        if (allRows != -1) {
            assert (cnt.state == State.UNINITIALIZED) : "Counter is already initialized.";
            remainingRowsCount = cnt.addAndGet(allRows - pageRowsCnt);
            this.expRowsCnt.addAndGet(allRows);
            if (pageRowsCnt > 0) {
                this.addPage0(page);
            }
            cnt.state = State.INITIALIZED;
        } else {
            remainingRowsCount = cnt.addAndGet(-pageRowsCnt);
            if (pageRowsCnt > 0) {
                this.addPage0(page);
            }
        }
        if (remainingRowsCount == 0) {
            if (cnt.state == State.UNINITIALIZED) {
                return;
            }
            cnt.state = State.FINISHED;
            for (Counter c : this.remainingRows.values()) {
                if (c.state == State.FINISHED) continue;
                return;
            }
            if (this.lastSubmitted.compareAndSet(false, true)) {
                this.addPage0(new GridResultPage(null, page.source(), null){

                    @Override
                    public boolean isLast() {
                        return true;
                    }
                });
            }
        }
    }

    protected abstract void addPage0(GridResultPage var1);

    protected void fetchNextPage(GridResultPage page) {
        if (this.remainingRows.get(page.source()).get() != 0) {
            page.fetchNextPage();
        }
    }

    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        if (this.fetched == null) {
            throw new IgniteException("Fetched result set was too large.");
        }
        if (this.fetchedAll()) {
            return this.findAllFetched(this.fetched, first, last);
        }
        return this.findInStream(first, last);
    }

    public boolean fetchedAll() {
        return this.fetchedCnt == this.expRowsCnt.get();
    }

    protected abstract Cursor findInStream(@Nullable SearchRow var1, @Nullable SearchRow var2);

    protected abstract Cursor findAllFetched(List<Row> var1, @Nullable SearchRow var2, @Nullable SearchRow var3);

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void close(Session ses) {
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        return this.getCostRangeIndex(masks, this.getRowCountApproximation(), filters, filter, sortOrder, true);
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException((String)"findFirstOrLast");
    }

    public boolean needRebuild() {
        return false;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    private static class Counter
    extends AtomicInteger {
        volatile State state = State.UNINITIALIZED;

        private Counter() {
        }
    }

    static enum State {
        UNINITIALIZED,
        INITIALIZED,
        FINISHED;

    }

    private class FetchedIterator
    implements Iterator<Row> {
        private int idx;

        private FetchedIterator() {
        }

        @Override
        public boolean hasNext() {
            return GridMergeIndex.this.fetched != null && this.idx < GridMergeIndex.this.fetched.size();
        }

        @Override
        public Row next() {
            return (Row)GridMergeIndex.this.fetched.get(this.idx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class FetchingCursor
    extends GridH2Cursor {
        private Iterator<Row> stream;

        public FetchingCursor(Iterator<Row> stream) {
            super(new FetchedIterator());
            assert (stream != null);
            this.stream = stream;
        }

        @Override
        public boolean next() {
            if (super.next()) {
                assert (this.cur != null);
                if (this.iter == this.stream && GridMergeIndex.this.fetched != null) {
                    if (GridMergeIndex.this.fetched.size() == MAX_FETCH_SIZE) {
                        GridMergeIndex.this.fetched = null;
                    } else {
                        GridMergeIndex.this.fetched.add(this.cur);
                    }
                }
                GridMergeIndex.this.fetchedCnt++;
                return true;
            }
            if (this.iter == this.stream) {
                return false;
            }
            this.iter = this.stream;
            return this.next();
        }
    }
}

