/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndexUnsorted;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.GridThreadLocalTable;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcStatement;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridReduceQueryExecutor {
    public static final byte QUERY_POOL = 2;
    private static final IgniteProductVersion DISTRIBUTED_JOIN_SINCE = IgniteProductVersion.fromString((String)"1.7.0");
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private IgniteLogger log;
    private final AtomicLong reqIdGen = new AtomicLong();
    private final ConcurrentMap<Long, QueryRun> runs = new ConcurrentHashMap8();
    private volatile List<GridThreadLocalTable> fakeTbls = Collections.emptyList();
    private final Lock fakeTblsLock = new ReentrantLock();
    private static final Constructor<JdbcResultSet> CONSTRUCTOR;
    private final GridSpinBusyLock busyLock;
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode locNode, Message msg) {
            GridReduceQueryExecutor.this.h2.mapQueryExecutor().onMessage(locNode.id(), msg);
        }
    };

    public GridReduceQueryExecutor(GridSpinBusyLock busyLock) {
        this.busyLock = busyLock;
    }

    public void start(final GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridReduceQueryExecutor.class);
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg) {
                if (!GridReduceQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof GridCacheQueryMarshallable) {
                        ((GridCacheQueryMarshallable)msg).unmarshall(ctx.config().getMarshaller(), ctx);
                    }
                    GridReduceQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridReduceQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                block0: for (QueryRun r : GridReduceQueryExecutor.this.runs.values()) {
                    for (GridMergeIndex idx : r.idxs) {
                        if (!idx.hasSource(nodeId)) continue;
                        GridReduceQueryExecutor.this.handleNodeLeft(r, nodeId);
                        continue block0;
                    }
                }
            }
        }, 12, new int[]{11});
    }

    private void handleNodeLeft(QueryRun r, UUID nodeId) {
        this.retry(r, this.h2.readyTopologyVersion(), nodeId);
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridQueryNextPageResponse) {
                this.onNextPage(node, (GridQueryNextPageResponse)msg);
            } else if (msg instanceof GridQueryFailResponse) {
                this.onFail(node, (GridQueryFailResponse)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed response: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onFail(ClusterNode node, GridQueryFailResponse msg) {
        QueryRun r = (QueryRun)this.runs.get(msg.queryRequestId());
        this.fail(r, node.id(), msg.error(), msg.failCode());
    }

    private void fail(QueryRun r, UUID nodeId, String msg, byte failCode) {
        if (r != null) {
            CacheException e = new CacheException("Failed to execute map query on the node: " + nodeId + ", " + msg);
            if (failCode == 1) {
                e.addSuppressed((Throwable)new QueryCancelledException());
            }
            r.state(e, nodeId);
        }
    }

    private void onNextPage(final ClusterNode node, GridQueryNextPageResponse msg) {
        GridResultPage page;
        final long qryReqId = msg.queryRequestId();
        final int qry = msg.query();
        final QueryRun r = (QueryRun)this.runs.get(qryReqId);
        if (r == null) {
            return;
        }
        final int pageSize = r.pageSize;
        GridMergeIndex idx = (GridMergeIndex)((Object)r.idxs.get(msg.query()));
        try {
            page = new GridResultPage(this.ctx, node.id(), msg){

                @Override
                public void fetchNextPage() {
                    Object errState = r.state.get();
                    if (errState != null) {
                        CacheException err0;
                        CacheException cacheException = err0 = errState instanceof CacheException ? (CacheException)errState : null;
                        if (err0 != null && err0.getCause() instanceof IgniteClientDisconnectedException) {
                            throw err0;
                        }
                        CacheException e = new CacheException("Failed to fetch data from node: " + node.id());
                        if (err0 != null) {
                            e.addSuppressed((Throwable)err0);
                        }
                        throw e;
                    }
                    try {
                        GridQueryNextPageRequest msg0 = new GridQueryNextPageRequest(qryReqId, qry, pageSize);
                        if (node.isLocal()) {
                            GridReduceQueryExecutor.this.h2.mapQueryExecutor().onMessage(GridReduceQueryExecutor.this.ctx.localNodeId(), msg0);
                        } else {
                            GridReduceQueryExecutor.this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg0, (byte)2);
                        }
                    }
                    catch (IgniteCheckedException e) {
                        throw new CacheException("Failed to fetch data from node: " + node.id(), (Throwable)e);
                    }
                }
            };
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Error in message.", (Throwable)e);
            this.fail(r, node.id(), "Error in message.", (byte)0);
            return;
        }
        idx.addPage(page);
        if (msg.retry() != null) {
            this.retry(r, msg.retry(), node.id());
        } else if (msg.allRows() != -1) {
            r.latch.countDown();
        }
    }

    private void retry(QueryRun r, AffinityTopologyVersion retryVer, UUID nodeId) {
        r.state(retryVer, nodeId);
    }

    private boolean isPreloadingActive(GridCacheContext<?, ?> cctx, List<Integer> extraSpaces) {
        if (this.hasMovingPartitions(cctx)) {
            return true;
        }
        if (extraSpaces != null) {
            for (int i = 0; i < extraSpaces.size(); ++i) {
                if (!this.hasMovingPartitions(this.cacheContext(extraSpaces.get(i)))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasMovingPartitions(GridCacheContext<?, ?> cctx) {
        GridDhtPartitionFullMap fullMap = cctx.topology().partitionMap(false);
        for (GridDhtPartitionMap2 map : fullMap.values()) {
            if (!map.hasMovingPartitions()) continue;
            return true;
        }
        return false;
    }

    private GridCacheContext<?, ?> cacheContext(Integer cacheId) {
        return this.ctx.cache().context().cacheContext(cacheId.intValue());
    }

    private Collection<ClusterNode> stableDataNodes(AffinityTopologyVersion topVer, GridCacheContext<?, ?> cctx, List<Integer> extraSpaces) {
        HashSet<ClusterNode> nodes = new HashSet<ClusterNode>(cctx.affinity().assignment(topVer).primaryPartitionNodes());
        if (F.isEmpty(nodes)) {
            throw new CacheException("Failed to find data nodes for cache: " + cctx.name());
        }
        if (!F.isEmpty(extraSpaces)) {
            for (int i = 0; i < extraSpaces.size(); ++i) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(extraSpaces.get(i));
                String extraSpace = extraCctx.name();
                if (extraCctx.isLocal()) continue;
                if (cctx.isReplicated() && !extraCctx.isReplicated()) {
                    throw new CacheException("Queries running on replicated cache should not contain JOINs with partitioned tables [rCache=" + cctx.name() + ", pCache=" + extraSpace + "]");
                }
                Set extraNodes = extraCctx.affinity().assignment(topVer).primaryPartitionNodes();
                if (F.isEmpty((Collection)extraNodes)) {
                    throw new CacheException("Failed to find data nodes for cache: " + extraSpace);
                }
                if (cctx.isReplicated() && extraCctx.isReplicated()) {
                    nodes.retainAll(extraNodes);
                    if (!nodes.isEmpty()) continue;
                    if (this.isPreloadingActive(cctx, extraSpaces)) {
                        return null;
                    }
                    throw new CacheException("Caches have distinct sets of data nodes [cache1=" + cctx.name() + ", cache2=" + extraSpace + "]");
                }
                if (!cctx.isReplicated() && extraCctx.isReplicated()) {
                    if (extraNodes.containsAll(nodes)) continue;
                    if (this.isPreloadingActive(cctx, extraSpaces)) {
                        return null;
                    }
                    throw new CacheException("Caches have distinct sets of data nodes [cache1=" + cctx.name() + ", cache2=" + extraSpace + "]");
                }
                if (!cctx.isReplicated() && !extraCctx.isReplicated()) {
                    if (extraNodes.size() == nodes.size() && nodes.containsAll(extraNodes)) continue;
                    if (this.isPreloadingActive(cctx, extraSpaces)) {
                        return null;
                    }
                    throw new CacheException("Caches have distinct sets of data nodes [cache1=" + cctx.name() + ", cache2=" + extraSpace + "]");
                }
                throw new IllegalStateException();
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<List<?>> query(GridCacheContext<?, ?> cctx, GridCacheTwoStepQuery qry, boolean keepPortable, boolean enforceJoinOrder, int timeoutMillis, GridQueryCancel cancel) {
        int attempt = 0;
        while (true) {
            block51: {
                if (attempt != 0) {
                    try {
                        Thread.sleep(attempt * 10);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new CacheException("Query was interrupted.", (Throwable)e);
                    }
                }
                final long qryReqId = this.reqIdGen.incrementAndGet();
                String space = cctx.name();
                QueryRun r = new QueryRun(this.h2.connectionForSpace(space), qry.mapQueries().size(), qry.pageSize());
                AffinityTopologyVersion topVer = this.h2.readyTopologyVersion();
                List<Integer> extraSpaces = qry.extraCaches();
                Map<ClusterNode, IntArray> partsMap = null;
                Collection<ClusterNode> nodes = this.isPreloadingActive(cctx, extraSpaces) ? (cctx.isReplicated() ? this.replicatedUnstableDataNodes(cctx, extraSpaces) : ((partsMap = this.partitionedUnstableDataNodes(cctx, extraSpaces)) == null ? null : partsMap.keySet())) : this.stableDataNodes(topVer, cctx, extraSpaces);
                if (nodes != null) {
                    assert (!nodes.isEmpty());
                    if (cctx.isReplicated() || qry.explain()) {
                        assert (qry.explain() || !nodes.contains(this.ctx.discovery().localNode())) : "We must be on a client node.";
                        nodes = Collections.singleton(F.rand(nodes));
                    }
                    final Collection<ClusterNode> finalNodes = nodes;
                    int tblIdx = 0;
                    boolean skipMergeTbl = !qry.explain() && qry.skipMergeTable();
                    for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
                        GridMergeIndex idx;
                        if (!skipMergeTbl) {
                            GridMergeTable tbl;
                            try {
                                tbl = this.createMergeTable(r.conn, mapQry, qry.explain());
                            }
                            catch (IgniteCheckedException e) {
                                throw new IgniteException((Throwable)e);
                            }
                            idx = tbl.getScanIndex(null);
                            this.fakeTable((Connection)r.conn, tblIdx++).innerTable((Table)tbl);
                        } else {
                            idx = GridMergeIndexUnsorted.createDummy(this.ctx);
                        }
                        idx.setSources(nodes);
                        r.idxs.add(idx);
                    }
                    r.latch = new CountDownLatch(r.idxs.size() * nodes.size());
                    this.runs.put(qryReqId, r);
                    try {
                        IgniteProductVersion minNodeVer;
                        cancel.checkCancelled();
                        if (this.ctx.clientDisconnected()) {
                            throw new CacheException("Query was cancelled, client node disconnected.", (Throwable)new IgniteClientDisconnectedException(this.ctx.cluster().clientReconnectFuture(), "Client node disconnected."));
                        }
                        List<GridCacheSqlQuery> mapQrys = qry.mapQueries();
                        if (qry.explain()) {
                            mapQrys = new ArrayList<GridCacheSqlQuery>(qry.mapQueries().size());
                            for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
                                mapQrys.add(new GridCacheSqlQuery("EXPLAIN " + mapQry.query(), mapQry.parameters()));
                            }
                        }
                        boolean oldStyle = (minNodeVer = cctx.shared().exchange().minimumNodeVersion(topVer)).compareToIgnoreTimestamp(DISTRIBUTED_JOIN_SINCE) < 0;
                        boolean distributedJoins = qry.distributedJoins();
                        cancel.set(new Runnable(){

                            @Override
                            public void run() {
                                GridReduceQueryExecutor.this.send(finalNodes, (Message)new GridQueryCancelRequest(qryReqId), (IgniteBiClosure<ClusterNode, Message, Message>)null, false);
                            }
                        });
                        boolean retry = false;
                        if (oldStyle && distributedJoins) {
                            throw new CacheException("Failed to enable distributed joins. Topology contains older data nodes.");
                        }
                        if (this.send(nodes, (Message)(oldStyle ? new GridQueryRequest(qryReqId, r.pageSize, space, mapQrys, topVer, this.extraSpaces(space, qry.spaces()), null, timeoutMillis) : new GridH2QueryRequest().requestId(qryReqId).topologyVersion(topVer).pageSize(r.pageSize).caches(qry.caches()).tables(distributedJoins ? qry.tables() : null).partitions(GridReduceQueryExecutor.convert(partsMap)).queries(mapQrys).flags(distributedJoins ? GridH2QueryRequest.FLAG_DISTRIBUTED_JOINS : 0).timeout(timeoutMillis)), oldStyle && partsMap != null ? new ExplicitPartitionsSpecializer(partsMap) : null, distributedJoins)) {
                            this.awaitAllReplies(r, nodes);
                            cancel.checkCancelled();
                            Object state = r.state.get();
                            if (state != null) {
                                if (state instanceof CacheException) {
                                    CacheException err = (CacheException)state;
                                    if (err.getCause() instanceof IgniteClientDisconnectedException) {
                                        throw err;
                                    }
                                    if (this.wasCancelled(err)) {
                                        throw new QueryCancelledException();
                                    }
                                    throw new CacheException("Failed to run map query remotely.", (Throwable)err);
                                }
                                if (state instanceof AffinityTopologyVersion) {
                                    retry = true;
                                    this.h2.awaitForReadyTopologyVersion((AffinityTopologyVersion)state);
                                }
                            }
                        } else {
                            retry = true;
                        }
                        Object resIter = null;
                        if (!retry) {
                            if (skipMergeTbl) {
                                ArrayList res = new ArrayList();
                                assert (r.idxs.size() == 1) : QueryRun.access$300(r);
                                GridMergeIndex idx = (GridMergeIndex)((Object)r.idxs.get(0));
                                Cursor cur = idx.findInStream(null, null);
                                while (cur.next()) {
                                    Row row = cur.get();
                                    int cols = row.getColumnCount();
                                    ArrayList<Object> resRow = new ArrayList<Object>(cols);
                                    for (int c = 0; c < cols; ++c) {
                                        resRow.add(row.getValue(c).getObject());
                                    }
                                    res.add(resRow);
                                }
                                resIter = res.iterator();
                            } else {
                                cancel.checkCancelled();
                                UUID locNodeId = this.ctx.localNodeId();
                                this.h2.setupConnection((Connection)r.conn, false, enforceJoinOrder);
                                GridH2QueryContext.set(new GridH2QueryContext(locNodeId, locNodeId, qryReqId, GridH2QueryType.REDUCE).pageSize(r.pageSize).distributedJoins(false));
                                try {
                                    if (qry.explain()) {
                                        Iterator<List<?>> idx = this.explainPlan(r.conn, space, qry);
                                        return idx;
                                    }
                                    GridCacheSqlQuery rdc = qry.reduceQuery();
                                    ResultSet res = this.h2.executeSqlQueryWithTimer(space, (Connection)r.conn, rdc.query(), F.asList((Object[])rdc.parameters()), false, timeoutMillis, cancel);
                                    resIter = new IgniteH2Indexing.FieldsIterator(res);
                                }
                                finally {
                                    GridH2QueryContext.clearThreadLocal();
                                }
                            }
                        }
                        if (retry) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new IgniteInterruptedCheckedException("Query was interrupted.");
                            }
                            break block51;
                        }
                        GridQueryCacheObjectsIterator gridQueryCacheObjectsIterator = new GridQueryCacheObjectsIterator(resIter, cctx, keepPortable);
                        return gridQueryCacheObjectsIterator;
                    }
                    catch (RuntimeException | IgniteCheckedException e) {
                        Throwable disconnectedErr;
                        U.closeQuiet((AutoCloseable)r.conn);
                        if (e instanceof CacheException) {
                            if (this.wasCancelled((CacheException)e)) {
                                throw new CacheException("Failed to run reduce query locally.", (Throwable)new QueryCancelledException());
                            }
                            throw (CacheException)e;
                        }
                        Throwable cause = e;
                        if (e instanceof IgniteCheckedException && (disconnectedErr = ((IgniteCheckedException)e).getCause(IgniteClientDisconnectedException.class)) != null) {
                            cause = disconnectedErr;
                        }
                        throw new CacheException("Failed to run reduce query locally.", cause);
                    }
                    finally {
                        this.cancelRemoteQueriesIfNeeded(nodes, r, qryReqId, qry.distributedJoins());
                        if (!this.runs.remove(qryReqId, r)) {
                            U.warn((IgniteLogger)this.log, (Object)("Query run was already removed: " + qryReqId));
                        }
                        if (!skipMergeTbl) {
                            int mapQrys = qry.mapQueries().size();
                            for (int i = 0; i < mapQrys; ++i) {
                                this.fakeTable(null, i).innerTable(null);
                            }
                        }
                    }
                }
            }
            ++attempt;
        }
    }

    private static boolean allIndexesFetched(List<GridMergeIndex> idxs) {
        for (int i = 0; i < idxs.size(); ++i) {
            if (idxs.get(i).fetchedAll()) continue;
            return false;
        }
        return true;
    }

    private boolean wasCancelled(CacheException e) {
        return X.hasSuppressed((Throwable)e, QueryCancelledException.class);
    }

    private void cancelRemoteQueriesIfNeeded(Collection<ClusterNode> nodes, QueryRun r, long qryReqId, boolean distributedJoins) {
        if (distributedJoins) {
            this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, false);
        } else {
            for (GridMergeIndex idx : r.idxs) {
                if (idx.fetchedAll()) continue;
                this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, false);
                break;
            }
        }
    }

    private void awaitAllReplies(QueryRun r, Collection<ClusterNode> nodes) throws IgniteInterruptedCheckedException {
        while (!U.await((CountDownLatch)r.latch, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
            for (ClusterNode node : nodes) {
                if (this.ctx.discovery().alive(node)) continue;
                this.handleNodeLeft(r, node.id());
                assert (r.latch.getCount() == 0L);
                return;
            }
        }
    }

    private static String table(int idx) {
        return GridSqlQuerySplitter.table(idx).getSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridThreadLocalTable fakeTable(Connection c, int idx) {
        List<GridThreadLocalTable> tbls;
        block19: {
            tbls = this.fakeTbls;
            assert (tbls.size() >= idx);
            if (tbls.size() == idx) {
                this.fakeTblsLock.lock();
                try {
                    tbls = this.fakeTbls;
                    if (tbls.size() != idx) break block19;
                    try (Statement stmt = c.createStatement();){
                        stmt.executeUpdate("CREATE TABLE " + GridReduceQueryExecutor.table(idx) + "(fake BOOL) ENGINE \"" + GridThreadLocalTable.Engine.class.getName() + '\"');
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                    ArrayList<GridThreadLocalTable> newTbls = new ArrayList<GridThreadLocalTable>(tbls.size() + 1);
                    newTbls.addAll(tbls);
                    newTbls.add(GridThreadLocalTable.Engine.getCreated());
                    this.fakeTbls = tbls = newTbls;
                }
                finally {
                    this.fakeTblsLock.unlock();
                }
            }
        }
        return tbls.get(idx);
    }

    private Collection<ClusterNode> replicatedUnstableDataNodes(GridCacheContext<?, ?> cctx, List<Integer> extraSpaces) {
        assert (cctx.isReplicated()) : cctx.name() + " must be replicated";
        Set<ClusterNode> nodes = this.replicatedUnstableDataNodes(cctx);
        if (F.isEmpty(nodes)) {
            return null;
        }
        if (!F.isEmpty(extraSpaces)) {
            for (int i = 0; i < extraSpaces.size(); ++i) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(extraSpaces.get(i));
                if (extraCctx.isLocal()) continue;
                if (!extraCctx.isReplicated()) {
                    throw new CacheException("Queries running on replicated cache should not contain JOINs with tables in partitioned caches [rCache=" + cctx.name() + ", pCache=" + extraCctx.name() + "]");
                }
                Set<ClusterNode> extraOwners = this.replicatedUnstableDataNodes(extraCctx);
                if (F.isEmpty(extraOwners)) {
                    return null;
                }
                nodes.retainAll(extraOwners);
                if (!nodes.isEmpty()) continue;
                return null;
            }
        }
        return nodes;
    }

    private Collection<ClusterNode> dataNodes(String space, AffinityTopologyVersion topVer) {
        Set<ClusterNode> res = this.ctx.discovery().cacheAffinityNodes(space, topVer);
        return res != null ? res : Collections.emptySet();
    }

    private Set<ClusterNode> replicatedUnstableDataNodes(GridCacheContext<?, ?> cctx) {
        assert (cctx.isReplicated()) : cctx.name() + " must be replicated";
        String space = cctx.name();
        HashSet<ClusterNode> dataNodes = new HashSet<ClusterNode>(this.dataNodes(space, AffinityTopologyVersion.NONE));
        if (dataNodes.isEmpty()) {
            throw new CacheException("Failed to find data nodes for cache: " + space);
        }
        int parts = cctx.affinity().partitions();
        for (int p = 0; p < parts; ++p) {
            List owners = cctx.topology().owners(p);
            if (F.isEmpty((Collection)owners)) {
                return null;
            }
            dataNodes.retainAll(owners);
            if (!dataNodes.isEmpty()) continue;
            return null;
        }
        return dataNodes;
    }

    private Map<ClusterNode, IntArray> partitionedUnstableDataNodes(GridCacheContext<?, ?> cctx, List<Integer> extraSpaces) {
        int parts;
        assert (!cctx.isReplicated() && !cctx.isLocal()) : cctx.name() + " must be partitioned";
        int partsCnt = cctx.affinity().partitions();
        if (extraSpaces != null) {
            for (int i = 0; i < extraSpaces.size(); ++i) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(extraSpaces.get(i));
                if (extraCctx.isReplicated() || extraCctx.isLocal() || (parts = extraCctx.affinity().partitions()) == partsCnt) continue;
                throw new CacheException("Number of partitions must be the same for correct collocation [cache1=" + cctx.name() + ", parts1=" + partsCnt + ", cache2=" + extraCctx.name() + ", parts2=" + parts + "]");
            }
        }
        Set[] partLocs = new Set[partsCnt];
        parts = cctx.affinity().partitions();
        for (int p = 0; p < parts; ++p) {
            List owners = cctx.topology().owners(p);
            if (F.isEmpty((Collection)owners)) {
                if (!F.isEmpty(this.dataNodes(cctx.name(), AffinityTopologyVersion.NONE))) {
                    return null;
                }
                throw new CacheException("Failed to find data nodes [cache=" + cctx.name() + ", part=" + p + "]");
            }
            partLocs[p] = new HashSet(owners);
        }
        if (extraSpaces != null) {
            int i;
            for (i = 0; i < extraSpaces.size(); ++i) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(extraSpaces.get(i));
                if (extraCctx.isReplicated() || extraCctx.isLocal()) continue;
                int parts2 = extraCctx.affinity().partitions();
                for (int p = 0; p < parts2; ++p) {
                    List owners = extraCctx.topology().owners(p);
                    if (F.isEmpty((Collection)owners)) {
                        if (!F.isEmpty(this.dataNodes(extraCctx.name(), AffinityTopologyVersion.NONE))) {
                            return null;
                        }
                        throw new CacheException("Failed to find data nodes [cache=" + extraCctx.name() + ", part=" + p + "]");
                    }
                    if (partLocs[p] == null) {
                        partLocs[p] = new HashSet(owners);
                        continue;
                    }
                    partLocs[p].retainAll(owners);
                    if (!partLocs[p].isEmpty()) continue;
                    return null;
                }
            }
            for (i = 0; i < extraSpaces.size(); ++i) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(extraSpaces.get(i));
                if (!extraCctx.isReplicated()) continue;
                Set<ClusterNode> dataNodes = this.replicatedUnstableDataNodes(extraCctx);
                if (F.isEmpty(dataNodes)) {
                    return null;
                }
                for (Set partLoc : partLocs) {
                    partLoc.retainAll(dataNodes);
                    if (!partLoc.isEmpty()) continue;
                    return null;
                }
            }
        }
        HashMap<ClusterNode, IntArray> res = new HashMap<ClusterNode, IntArray>();
        for (int p = 0; p < partLocs.length; ++p) {
            Set pl = partLocs[p];
            assert (!F.isEmpty((Collection)pl)) : pl;
            ClusterNode n = pl.size() == 1 ? (ClusterNode)F.first((Iterable)pl) : (ClusterNode)F.rand((Collection)pl);
            IntArray parts3 = (IntArray)res.get(n);
            if (parts3 == null) {
                parts3 = new IntArray();
                res.put(n, parts3);
            }
            parts3.add(p);
        }
        return res;
    }

    private List<String> extraSpaces(String mainSpace, Collection<String> allSpaces) {
        if (F.isEmpty(allSpaces) || allSpaces.size() == 1 && allSpaces.contains(mainSpace)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(allSpaces.size());
        for (String space : allSpaces) {
            if (F.eq((Object)space, (Object)mainSpace)) continue;
            res.add(space);
        }
        return res;
    }

    private Iterator<List<?>> explainPlan(JdbcConnection c, String space, GridCacheTwoStepQuery qry) throws IgniteCheckedException {
        ResultSet rs;
        ArrayList<List> lists = new ArrayList<List>();
        int mapQrys = qry.mapQueries().size();
        for (int i = 0; i < mapQrys; ++i) {
            rs = this.h2.executeSqlQueryWithTimer(space, (Connection)c, "SELECT PLAN FROM " + GridReduceQueryExecutor.table(i), null, false, 0, null);
            lists.add(F.asList((Object)this.getPlan(rs)));
        }
        int tblIdx = 0;
        for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
            GridMergeTable tbl = this.createMergeTable(c, mapQry, false);
            this.fakeTable((Connection)c, tblIdx++).innerTable((Table)tbl);
        }
        GridCacheSqlQuery rdc = qry.reduceQuery();
        rs = this.h2.executeSqlQueryWithTimer(space, (Connection)c, "EXPLAIN " + rdc.query(), F.asList((Object[])rdc.parameters()), false, 0, null);
        lists.add(F.asList((Object)this.getPlan(rs)));
        return lists.iterator();
    }

    private String getPlan(ResultSet rs) throws IgniteCheckedException {
        try {
            if (!rs.next()) {
                throw new IllegalStateException();
            }
            return rs.getString(1);
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private boolean send(Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, boolean runLocParallel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending: [msg=" + msg + ", nodes=" + nodes + ", specialize=" + specialize + "]");
        }
        return this.h2.send(GridTopic.TOPIC_QUERY, GridTopic.TOPIC_QUERY.ordinal(), nodes, msg, specialize, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeHnd, (byte)2, runLocParallel);
    }

    private Message copy(Message msg, ClusterNode node, Map<ClusterNode, IntArray> partsMap) {
        assert (partsMap != null);
        GridQueryRequest res = new GridQueryRequest((GridQueryRequest)msg);
        IntArray parts = partsMap.get(node);
        assert (parts != null) : node;
        res.partitions(GridReduceQueryExecutor.toArray(parts));
        return res;
    }

    public static int[] toArray(IntArray ints) {
        int[] res = new int[ints.size()];
        ints.toArray(res);
        return res;
    }

    private static Map<UUID, int[]> convert(Map<ClusterNode, IntArray> m) {
        if (m == null) {
            return null;
        }
        HashMap res = U.newHashMap((int)m.size());
        for (Map.Entry<ClusterNode, IntArray> entry : m.entrySet()) {
            res.put(entry.getKey().id(), GridReduceQueryExecutor.toArray(entry.getValue()));
        }
        return res;
    }

    private GridMergeTable createMergeTable(JdbcConnection conn, GridCacheSqlQuery qry, boolean explain) throws IgniteCheckedException {
        try {
            Session ses = (Session)conn.getSession();
            CreateTableData data = new CreateTableData();
            data.tableName = "T___";
            data.schema = ses.getDatabase().getSchema(ses.getCurrentSchemaName());
            data.create = true;
            if (!explain) {
                LinkedHashMap colsMap = qry.columns();
                assert (colsMap != null);
                ArrayList<Column> cols = new ArrayList<Column>(colsMap.size());
                for (Map.Entry e : colsMap.entrySet()) {
                    String alias = (String)e.getKey();
                    GridSqlType t = (GridSqlType)e.getValue();
                    assert (!F.isEmpty((String)alias));
                    Column c = new Column(alias, t.type(), t.precision(), t.scale(), t.displaySize());
                    cols.add(c);
                }
                data.columns = cols;
            } else {
                data.columns = GridReduceQueryExecutor.planColumns();
            }
            return new GridMergeTable(data, this.ctx);
        }
        catch (Exception e) {
            U.closeQuiet((AutoCloseable)conn);
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private static ArrayList<Column> planColumns() {
        ArrayList<Column> res = new ArrayList<Column>(1);
        res.add(new Column("PLAN", 13));
        return res;
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        CacheException err = new CacheException("Query was cancelled, client node disconnected.", (Throwable)new IgniteClientDisconnectedException(reconnectFut, "Client node disconnected."));
        for (Map.Entry e : this.runs.entrySet()) {
            ((QueryRun)e.getValue()).disconnected(err);
        }
    }

    static {
        try {
            CONSTRUCTOR = JdbcResultSet.class.getDeclaredConstructor(JdbcConnection.class, JdbcStatement.class, ResultInterface.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private class ExplicitPartitionsSpecializer
    implements IgniteBiClosure<ClusterNode, Message, Message> {
        private final Map<ClusterNode, IntArray> partsMap;

        private ExplicitPartitionsSpecializer(Map<ClusterNode, IntArray> partsMap) {
            this.partsMap = partsMap;
        }

        public Message apply(ClusterNode n, Message msg) {
            return GridReduceQueryExecutor.this.copy(msg, n, this.partsMap);
        }
    }

    private static class QueryRun {
        private final List<GridMergeIndex> idxs;
        private CountDownLatch latch;
        private final JdbcConnection conn;
        private final int pageSize;
        private final AtomicReference<Object> state = new AtomicReference();

        private QueryRun(Connection conn, int idxsCnt, int pageSize) {
            this.conn = (JdbcConnection)conn;
            this.idxs = new ArrayList<GridMergeIndex>(idxsCnt);
            this.pageSize = pageSize > 0 ? pageSize : 1000;
        }

        void state(Object o, @Nullable UUID nodeId) {
            assert (o != null);
            assert (o instanceof CacheException || o instanceof AffinityTopologyVersion) : o.getClass();
            if (!this.state.compareAndSet(null, o)) {
                return;
            }
            while (this.latch.getCount() != 0L) {
                this.latch.countDown();
            }
            for (GridMergeIndex idx : this.idxs) {
                idx.fail(nodeId, o instanceof CacheException ? (CacheException)o : null);
            }
        }

        void disconnected(CacheException e) {
            if (!this.state.compareAndSet(null, e)) {
                return;
            }
            while (this.latch.getCount() != 0L) {
                this.latch.countDown();
            }
            for (GridMergeIndex idx : this.idxs) {
                idx.fail(e);
            }
        }
    }
}

