/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridH2QueryRequest
implements Message,
GridCacheQueryMarshallable {
    private static final long serialVersionUID = 0L;
    public static int FLAG_DISTRIBUTED_JOINS = 1;
    private long reqId;
    @GridToStringInclude
    @GridDirectCollection(value=Integer.class)
    private List<Integer> caches;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=int[].class)
    private Map<UUID, int[]> parts;
    private int pageSize;
    @GridToStringInclude
    @GridDirectCollection(value=Message.class)
    private List<GridCacheSqlQuery> qrys;
    private byte flags;
    @GridToStringInclude
    @GridDirectCollection(value=String.class)
    private Collection<String> tbls;
    private int timeout;

    public GridH2QueryRequest tables(Collection<String> tbls) {
        this.tbls = tbls;
        return this;
    }

    public Collection<String> tables() {
        return this.tbls;
    }

    public GridH2QueryRequest requestId(long reqId) {
        this.reqId = reqId;
        return this;
    }

    public long requestId() {
        return this.reqId;
    }

    public GridH2QueryRequest caches(List<Integer> caches) {
        this.caches = caches;
        return this;
    }

    public List<Integer> caches() {
        return this.caches;
    }

    public GridH2QueryRequest topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        return this;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Map<UUID, int[]> partitions() {
        return this.parts;
    }

    public GridH2QueryRequest partitions(Map<UUID, int[]> parts) {
        this.parts = parts;
        return this;
    }

    public GridH2QueryRequest pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public GridH2QueryRequest queries(List<GridCacheSqlQuery> qrys) {
        this.qrys = qrys;
        return this;
    }

    public List<GridCacheSqlQuery> queries() {
        return this.qrys;
    }

    public GridH2QueryRequest flags(int flags) {
        this.flags = (byte)flags;
        return this;
    }

    public boolean isFlagSet(int flags) {
        return (this.flags & flags) == flags;
    }

    public int timeout() {
        return this.timeout;
    }

    public GridH2QueryRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public void marshall(Marshaller m) {
        if (F.isEmpty(this.qrys)) {
            return;
        }
        for (GridCacheSqlQuery qry : this.qrys) {
            qry.marshall(m);
        }
    }

    public void unmarshall(Marshaller m, GridKernalContext ctx) {
        if (F.isEmpty(this.qrys)) {
            return;
        }
        for (GridCacheSqlQuery qry : this.qrys) {
            qry.unmarshall(m, ctx);
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("caches", this.caches, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeMap("parts", this.parts, MessageCollectionItemType.UUID, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeCollection("qrys", this.qrys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("tbls", this.tbls, MessageCollectionItemType.STRING)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("topVer", (Message)this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.caches = (List)reader.readCollection("caches", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.parts = reader.readMap("parts", MessageCollectionItemType.UUID, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.qrys = (List)reader.readCollection("qrys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.tbls = reader.readCollection("tbls", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.timeout = reader.readInt("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2QueryRequest.class);
    }

    public byte directType() {
        return -33;
    }

    public byte fieldsCount() {
        return 9;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridH2QueryRequest.class, (Object)this);
    }
}

