/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigResource;

@InterfaceStability.Evolving
public abstract class AdminClient
implements AutoCloseable {
    public static AdminClient create(Properties props) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(props), null);
    }

    public static AdminClient create(Map<String, Object> conf) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(conf), null);
    }

    @Override
    public void close() {
        this.close(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public abstract void close(long var1, TimeUnit var3);

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        return this.createTopics(newTopics, new CreateTopicsOptions());
    }

    public abstract CreateTopicsResult createTopics(Collection<NewTopic> var1, CreateTopicsOptions var2);

    public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        return this.deleteTopics(topics, new DeleteTopicsOptions());
    }

    public abstract DeleteTopicsResult deleteTopics(Collection<String> var1, DeleteTopicsOptions var2);

    public ListTopicsResult listTopics() {
        return this.listTopics(new ListTopicsOptions());
    }

    public abstract ListTopicsResult listTopics(ListTopicsOptions var1);

    public DescribeTopicsResult describeTopics(Collection<String> topicNames) {
        return this.describeTopics(topicNames, new DescribeTopicsOptions());
    }

    public abstract DescribeTopicsResult describeTopics(Collection<String> var1, DescribeTopicsOptions var2);

    public DescribeClusterResult describeCluster() {
        return this.describeCluster(new DescribeClusterOptions());
    }

    public abstract DescribeClusterResult describeCluster(DescribeClusterOptions var1);

    public DescribeAclsResult describeAcls(AclBindingFilter filter) {
        return this.describeAcls(filter, new DescribeAclsOptions());
    }

    public abstract DescribeAclsResult describeAcls(AclBindingFilter var1, DescribeAclsOptions var2);

    public CreateAclsResult createAcls(Collection<AclBinding> acls) {
        return this.createAcls(acls, new CreateAclsOptions());
    }

    public abstract CreateAclsResult createAcls(Collection<AclBinding> var1, CreateAclsOptions var2);

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters) {
        return this.deleteAcls(filters, new DeleteAclsOptions());
    }

    public abstract DeleteAclsResult deleteAcls(Collection<AclBindingFilter> var1, DeleteAclsOptions var2);

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources) {
        return this.describeConfigs(resources, new DescribeConfigsOptions());
    }

    public abstract DescribeConfigsResult describeConfigs(Collection<ConfigResource> var1, DescribeConfigsOptions var2);

    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs) {
        return this.alterConfigs(configs, new AlterConfigsOptions());
    }

    public abstract AlterConfigsResult alterConfigs(Map<ConfigResource, Config> var1, AlterConfigsOptions var2);

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment) {
        return this.alterReplicaLogDirs(replicaAssignment, new AlterReplicaLogDirsOptions());
    }

    public abstract AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> var1, AlterReplicaLogDirsOptions var2);

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers) {
        return this.describeLogDirs(brokers, new DescribeLogDirsOptions());
    }

    public abstract DescribeLogDirsResult describeLogDirs(Collection<Integer> var1, DescribeLogDirsOptions var2);

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas) {
        return this.describeReplicaLogDirs(replicas, new DescribeReplicaLogDirsOptions());
    }

    public abstract DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> var1, DescribeReplicaLogDirsOptions var2);

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions) {
        return this.createPartitions(newPartitions, new CreatePartitionsOptions());
    }

    public abstract CreatePartitionsResult createPartitions(Map<String, NewPartitions> var1, CreatePartitionsOptions var2);
}

