/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetFetchResponse$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.TopicAndPartition;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class OffsetFetchResponse$
implements Logging,
Serializable {
    public static final OffsetFetchResponse$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new OffsetFetchResponse$();
    }

    private Logger logger$lzycompute() {
        OffsetFetchResponse$ offsetFetchResponse$ = this;
        synchronized (offsetFetchResponse$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public OffsetFetchResponse readFrom(ByteBuffer buffer) {
        return this.readFrom(buffer, OffsetFetchRequest$.MODULE$.CurrentVersion());
    }

    public OffsetFetchResponse readFrom(ByteBuffer buffer, int requestVersion) {
        Errors errors;
        int correlationId = buffer.getInt();
        int topicCount = buffer.getInt();
        IndexedSeq pairs = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topicCount).flatMap((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$1;

            public final IndexedSeq<Tuple2<TopicAndPartition, OffsetMetadataAndError>> apply(int x$1) {
                String topic = ApiUtils$.MODULE$.readShortString(this.buffer$1);
                int partitionCount = this.buffer$1.getInt();
                return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitionCount).map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final String topic$1;

                    public final Tuple2<TopicAndPartition, OffsetMetadataAndError> apply(int x$2) {
                        int partitionId = this.$outer.buffer$1.getInt();
                        long offset2 = this.$outer.buffer$1.getLong();
                        String metadata = ApiUtils$.MODULE$.readShortString(this.$outer.buffer$1);
                        Errors error = Errors.forCode((short)this.$outer.buffer$1.getShort());
                        return new Tuple2((Object)new TopicAndPartition(this.topic$1, partitionId), (Object)OffsetMetadataAndError$.MODULE$.apply(offset2, metadata, error));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$1 = topic$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.buffer$1 = buffer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int n = requestVersion;
        switch (n) {
            default: {
                errors = Errors.forCode((short)buffer.getShort());
                break;
            }
            case 0: 
            case 1: {
                errors = Errors.NONE;
            }
        }
        Errors error = errors;
        return new OffsetFetchResponse((Map<TopicAndPartition, OffsetMetadataAndError>)((Map)Predef$.MODULE$.Map().apply((Seq)pairs)), requestVersion, correlationId, error);
    }

    public OffsetFetchResponse apply(Map<TopicAndPartition, OffsetMetadataAndError> requestInfo, int requestVersion, int correlationId, Errors error) {
        return new OffsetFetchResponse(requestInfo, requestVersion, correlationId, error);
    }

    public Option<Tuple4<Map<TopicAndPartition, OffsetMetadataAndError>, Object, Object, Errors>> unapply(OffsetFetchResponse x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.requestInfo(), (Object)BoxesRunTime.boxToInteger((int)x$0.requestVersion()), (Object)BoxesRunTime.boxToInteger((int)x$0.correlationId()), (Object)x$0.error()));
    }

    public int $lessinit$greater$default$2() {
        return OffsetFetchRequest$.MODULE$.CurrentVersion();
    }

    public int $lessinit$greater$default$3() {
        return 0;
    }

    public Errors $lessinit$greater$default$4() {
        return Errors.NONE;
    }

    public int apply$default$2() {
        return OffsetFetchRequest$.MODULE$.CurrentVersion();
    }

    public int apply$default$3() {
        return 0;
    }

    public Errors apply$default$4() {
        return Errors.NONE;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OffsetFetchResponse$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

