/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.ElectionResult;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkPartitionStateMachine$;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011qCW6QCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016D\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0007G>tg-[4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011AB:feZ,'/\u0003\u0002\u0014!\tY1*\u00194lC\u000e{gNZ5h\u0011!)\u0002A!A!\u0002\u00131\u0012!E:uCR,7\t[1oO\u0016dunZ4feB\u0011\u0011bF\u0005\u00031\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!Q\u0002A!A!\u0002\u0013Y\u0012!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011\u0011\u0002H\u0005\u0003;\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\"\u0011A\u0001>l\u0013\t)#EA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005a2m\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA\u0005*\u0013\tQ#A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\u0019qs\u0006M\u00193gA\u0011\u0011\u0002\u0001\u0005\u0006\u001b-\u0002\rA\u0004\u0005\u0006+-\u0002\rA\u0006\u0005\u00065-\u0002\ra\u0007\u0005\u0006?-\u0002\r\u0001\t\u0005\u0006O-\u0002\r\u0001\u000b\u0005\bk\u0001\u0011\r\u0011\"\u00037\u00031\u0019wN\u001c;s_2dWM]%e+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$aA%oi\"1a\b\u0001Q\u0001\n]\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003\"\u0002!\u0001\t\u0003\n\u0015A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$BA\u00115neB!1I\u0012%T\u001b\u0005!%BA#:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u000f\u0012\u00131!T1q!\tI\u0015+D\u0001K\u0015\tYE*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b5S!AT(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0016aA8sO&\u0011!K\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011!Fl\u00182\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-\u0007\u0003\u0019a$o\\8u}%\t!(\u0003\u0002\\s\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\u0019)\u0015\u000e\u001e5fe*\u00111,\u000f\t\u0003)\u0002L!!\u00190\u0003\u0013QC'o\\<bE2,\u0007CA2g\u001b\u0005!'BA3\u0005\u0003\r\t\u0007/[\u0005\u0003O\u0012\u0014A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJDQ![ A\u0002)\f!\u0002]1si&$\u0018n\u001c8t!\r\u00195\u000eS\u0005\u0003Y\u0012\u00131aU3r\u0011\u0015qw\b1\u0001p\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0005%\u0001\u0018BA9\u0003\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016DQa] A\u0002Q\f!\u0005]1si&$\u0018n\u001c8MK\u0006$WM]#mK\u000e$\u0018n\u001c8TiJ\fG/Z4z\u001fB$\bc\u0001\u001dvo&\u0011a/\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%A\u0018BA=\u0003\u0005}\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-\u001f\u0005\u0006w\u0002!I\u0001`\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\tyW\u0010C\u0003\u007fu\u0002\u0007\u0001*A\u0005qCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0011\u0001\u00063p\u0011\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000fF\u0004C\u0003\u000b\t9!!\u0003\t\u000b%|\b\u0019\u00016\t\u000b9|\b\u0019A8\t\u000bM|\b\u0019\u0001;\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010\u0005\u0019\u0013N\\5uS\u0006d\u0017N_3MK\u0006$WM]!oI&\u001b(OR8s!\u0006\u0014H/\u001b;j_:\u001cHc\u00016\u0002\u0012!1\u0011.a\u0003A\u0002)Dq!!\u0006\u0001\t\u0013\t9\"\u0001\rfY\u0016\u001cG\u000fT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$RAQA\r\u00037Aa![A\n\u0001\u0004Q\u0007bBA\u000f\u0003'\u0001\ra^\u0001 a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eL\bbBA\u0011\u0001\u0011%\u00111E\u0001\u001bI>,E.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003K\t)$a\u000e\u0011\ra\n9#a\u000bk\u0013\r\tI#\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\r3\u0005*!\f\u0011\u000bQc\u0016q\u00062\u0011\u0007Q\u000b\t$C\u0002\u00024y\u0013\u0011\"\u0012=dKB$\u0018n\u001c8\t\r%\fy\u00021\u0001k\u0011\u001d\ti\"a\bA\u0002]Dq!a\u000f\u0001\t\u0013\ti$A\u0011d_2dWm\u0019;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8Ti\u0006$X\r\u0006\u0004\u0002@\u0005=\u0013q\u000b\t\u0005\u0007.\f\t\u0005\u0005\u00059\u0003\u0007B\u0015qIA%\u0013\r\t)%\u000f\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007a*(\rE\u00029\u0003\u0017J1!!\u0014:\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0015\u0002:\u0001\u0007\u00111K\u0001\u000eY\u0016\fG-\u001a:B]\u0012L5O]:\u0011\t\r[\u0017Q\u000b\t\u0006q\u0005\u001d\u0002J\u0019\u0005\t\u00033\nI\u00041\u0001\u0002J\u0005a\u0011\r\u001c7poVs7\r\\3b]\"9\u0011Q\f\u0001\u0005\n\u0005}\u0013\u0001\u00067pO&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0002b\u0005\u001d\u0014\u0011\u000e\t\u0004q\u0005\r\u0014bAA3s\t!QK\\5u\u0011\u0019q\u00181\fa\u0001\u0011\"1a.a\u0017A\u0002=Dq!!\u001c\u0001\t\u0013\ty'\u0001\u000bm_\u001e4\u0015-\u001b7fIN#\u0018\r^3DQ\u0006tw-\u001a\u000b\u000b\u0003C\n\t(a\u001d\u0002x\u0005e\u0004B\u0002@\u0002l\u0001\u0007\u0001\nC\u0004\u0002v\u0005-\u0004\u0019A8\u0002\u0013\r,(O]*uCR,\u0007B\u00028\u0002l\u0001\u0007q\u000e\u0003\u0005\u0002|\u0005-\u0004\u0019AA?\u0003\u0011\u0019w\u000eZ3\u0011\t\u0005}\u0014Q\u0013\b\u0005\u0003\u0003\u000byI\u0004\u0003\u0002\u0004\u0006-e\u0002BAC\u0003\u0013s1AVAD\u0013\u0005\u0001\u0016B\u0001(P\u0013\r\ti)T\u0001\nu>|7.Z3qKJLA!!%\u0002\u0014\u0006y1*Z3qKJ,\u0005pY3qi&|gNC\u0002\u0002\u000e6KA!a&\u0002\u001a\n!1i\u001c3f\u0015\u0011\t\t*a%\t\u000f\u00055\u0004\u0001\"\u0003\u0002\u001eRQ\u0011\u0011MAP\u0003C\u000b\u0019+!*\t\ry\fY\n1\u0001I\u0011\u001d\t)(a'A\u0002=DaA\\AN\u0001\u0004y\u0007bBAT\u00037\u0003\raX\u0001\u0002i\u0002")
public class ZkPartitionStateMachine
extends PartitionStateMachine {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    public final ControllerContext kafka$controller$ZkPartitionStateMachine$$controllerContext;
    private final KafkaZkClient zkClient;
    public final ControllerBrokerRequestBatch kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch;
    private final int kafka$controller$ZkPartitionStateMachine$$controllerId;

    public int kafka$controller$ZkPartitionStateMachine$$controllerId() {
        return this.kafka$controller$ZkPartitionStateMachine$$controllerId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        scala.collection.immutable.Map map;
        if (!partitions.nonEmpty()) {
            map = scala.collection.Map$.MODULE$.empty();
            return map;
        }
        try {
            this.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.newBatch();
            scala.collection.immutable.Map result = this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
            this.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.sendRequestsToBrokers(this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
            map = result;
            return map;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            map = partitions.iterator().map((Function1)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Tuple2<TopicPartition, Left<Throwable, Nothing$>> apply(TopicPartition x$1) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$1), (Object)package$.MODULE$.Left().apply((Object)this.e$2));
                }
                {
                    this.e$2 = e$2;
                }
            }).toMap(Predef$.MODULE$.$conforms());
            return map;
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller moved to another broker when moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$1;

                public final ControllerMovedException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw controllerMovedException;
        }
    }

    public PartitionState kafka$controller$ZkPartitionStateMachine$$partitionState(TopicPartition partition) {
        return this.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionState(partition);
    }

    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Tuple2<Seq<TopicPartition>, Seq<TopicPartition>> tuple2;
        block6: {
            PartitionState partitionState;
            block11: {
                scala.collection.immutable.Map map;
                block8: {
                    Seq validPartitions;
                    StateChangeLogger stateChangeLog;
                    block10: {
                        block9: {
                            Map<TopicPartition, Either<Throwable, LeaderAndIsr>> map2;
                            block7: {
                                Tuple2 tuple22;
                                stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
                                partitions.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;

                                    public final void apply(TopicPartition partition) {
                                        this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionStateIfNotExists(partition, NonExistentPartition$.MODULE$);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                tuple2 = this.kafka$controller$ZkPartitionStateMachine$$controllerContext.checkValidPartitionStateChange(partitions, targetState);
                                if (tuple2 == null) break block6;
                                Seq validPartitions2 = (Seq)tuple2._1();
                                Seq invalidPartitions = (Seq)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)validPartitions2, (Object)invalidPartitions);
                                validPartitions = (Seq)tuple23._1();
                                Seq invalidPartitions2 = (Seq)tuple23._2();
                                invalidPartitions2.foreach((Function1)new Serializable(this, targetState){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                                    private final PartitionState targetState$2;

                                    public final void apply(TopicPartition partition) {
                                        this.$outer.kafka$controller$ZkPartitionStateMachine$$logInvalidTransition(partition, this.targetState$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                    }
                                });
                                partitionState = targetState;
                                if (!NewPartition$.MODULE$.equals(partitionState)) break block7;
                                validPartitions.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                                    public final PartitionState targetState$2;
                                    private final StateChangeLogger stateChangeLog$1;

                                    public final void apply(TopicPartition partition) {
                                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$doHandleStateChanges$3 $outer;
                                            private final TopicPartition partition$6;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$6, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$6), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionReplicaAssignment(this.partition$6).mkString(",")}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.partition$6 = partition$6;
                                            }
                                        });
                                        this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, NewPartition$.MODULE$);
                                    }

                                    public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                        this.stateChangeLog$1 = stateChangeLog$1;
                                    }
                                });
                                map = scala.collection.Map$.MODULE$.empty();
                                break block8;
                            }
                            if (!OnlinePartition$.MODULE$.equals(partitionState)) break block9;
                            Seq uninitializedPartitions = (Seq)validPartitions.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ZkPartitionStateMachine $outer;

                                public final boolean apply(TopicPartition partition) {
                                    PartitionState partitionState = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                                    NewPartition$ newPartition$ = NewPartition$.MODULE$;
                                    return !(partitionState != null ? !partitionState.equals(newPartition$) : newPartition$ != null);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Seq partitionsToElectLeader = (Seq)validPartitions.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ZkPartitionStateMachine $outer;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(TopicPartition partition) {
                                    PartitionState partitionState = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                                    if (partitionState == null) {
                                        if (offlinePartition$ == null) return true;
                                    } else if (partitionState.equals(offlinePartition$)) return true;
                                    PartitionState partitionState2 = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                                    OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                                    if (partitionState2 != null) {
                                        if (!partitionState2.equals(onlinePartition$)) return false;
                                        return true;
                                    }
                                    if (onlinePartition$ == null) return true;
                                    return false;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            if (uninitializedPartitions.nonEmpty()) {
                                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                                successfulInitializations.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                                    public final PartitionState targetState$2;
                                    private final StateChangeLogger stateChangeLog$1;

                                    public final void apply(TopicPartition partition) {
                                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$doHandleStateChanges$4 $outer;
                                            private final TopicPartition partition$7;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$7, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$7), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().apply((Object)this.partition$7)).leaderAndIsr()}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.partition$7 = partition$7;
                                            }
                                        });
                                        this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                                    }

                                    public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                        this.stateChangeLog$1 = stateChangeLog$1;
                                    }
                                });
                            }
                            if (partitionsToElectLeader.nonEmpty()) {
                                Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Nothing$ apply() {
                                        throw new IllegalArgumentException("Election strategy is a required field when the target state is OnlinePartition");
                                    }
                                }));
                                electionResults.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ZkPartitionStateMachine $outer;
                                    public final PartitionState targetState$2;
                                    private final StateChangeLogger stateChangeLog$1;

                                    public final void apply(Tuple2<TopicPartition, Either<Throwable, LeaderAndIsr>> x0$1) {
                                        Tuple2<TopicPartition, Either<Throwable, LeaderAndIsr>> tuple2;
                                        block4: {
                                            block3: {
                                                Either either;
                                                block2: {
                                                    tuple2 = x0$1;
                                                    if (tuple2 == null) break block2;
                                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                                    Either either2 = (Either)tuple2._2();
                                                    if (!(either2 instanceof Right)) break block2;
                                                    Right right = (Right)either2;
                                                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)right.b();
                                                    this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition, leaderAndIsr){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$doHandleStateChanges$5 $outer;
                                                        private final TopicPartition partition$1;
                                                        private final LeaderAndIsr leaderAndIsr$1;

                                                        public final String apply() {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$1), this.$outer.targetState$2, this.leaderAndIsr$1}));
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                            this.partition$1 = partition$1;
                                                            this.leaderAndIsr$1 = leaderAndIsr$1;
                                                        }
                                                    });
                                                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, OnlinePartition$.MODULE$);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (tuple2 == null || !((either = (Either)tuple2._2()) instanceof Left)) break block4;
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            }
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }

                                    public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                        this.stateChangeLog$1 = stateChangeLog$1;
                                    }
                                });
                                map2 = electionResults;
                            } else {
                                map2 = scala.collection.Map$.MODULE$.empty();
                            }
                            map = map2;
                            break block8;
                        }
                        if (!OfflinePartition$.MODULE$.equals(partitionState)) break block10;
                        validPartitions.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ZkPartitionStateMachine $outer;
                            public final PartitionState targetState$2;
                            private final StateChangeLogger stateChangeLog$1;

                            public final void apply(TopicPartition partition) {
                                this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$doHandleStateChanges$6 $outer;
                                    private final TopicPartition partition$8;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$8, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$8), this.$outer.targetState$2}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.partition$8 = partition$8;
                                    }
                                });
                                this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, OfflinePartition$.MODULE$);
                            }

                            public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.targetState$2 = targetState$2;
                                this.stateChangeLog$1 = stateChangeLog$1;
                            }
                        });
                        map = scala.collection.Map$.MODULE$.empty();
                        break block8;
                    }
                    if (!NonExistentPartition$.MODULE$.equals(partitionState)) break block11;
                    validPartitions.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkPartitionStateMachine $outer;
                        public final PartitionState targetState$2;
                        private final StateChangeLogger stateChangeLog$1;

                        public final void apply(TopicPartition partition) {
                            this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$doHandleStateChanges$7 $outer;
                                private final TopicPartition partition$9;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$9, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$partitionState(this.partition$9), this.$outer.targetState$2}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.partition$9 = partition$9;
                                }
                            });
                            this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.putPartitionState(partition, NonExistentPartition$.MODULE$);
                        }

                        public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.stateChangeLog$1 = stateChangeLog$1;
                        }
                    });
                    map = scala.collection.Map$.MODULE$.empty();
                }
                return map;
            }
            throw new MatchError((Object)partitionState);
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var2_2;
        Seq seq;
        Tuple2 tuple22;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final Tuple2<TopicPartition, Seq<Object>> apply(TopicPartition partition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$2) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$9 $outer;
                        private final TopicPartition partition$2;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$2, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$2 = partition$2;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Seq<Object>> x0$3) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Seq liveReplicas = (Seq)tuple2._2();
                    boolean bl = liveReplicas.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas2);
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$4) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error during state change of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " from New to Online, assigned replicas are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "], live brokers are [", "]. No assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(","), this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.liveBrokerIds()}))).append((Object)"replica is alive.").toString();
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;

            public final Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicPartition, Seq<Object>> x0$5) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq liveReplicas = (Seq)tuple2._2();
                    LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epochZkVersion());
        }
        catch (Exception exception) {
            partitionsWithLiveReplicas.foreach((Function1)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZkPartitionStateMachine $outer;
                private final Exception e$4;

                public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$6) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition), (PartitionState)NewPartition$.MODULE$, this.e$4);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.e$4 = e$4;
                }
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller moved to another broker when trying to create the topic partition state znode";
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$3;

                public final ControllerMovedException apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = e$3;
                }
            });
            throw controllerMovedException;
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1)new Serializable(this, successfulInitializations, leaderIsrAndControllerEpochs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;
            private final Buffer successfulInitializations$1;
            private final scala.collection.immutable.Map leaderIsrAndControllerEpochs$1;

            public final Object apply(CreateResponse createResponse2) {
                BoxedUnit boxedUnit;
                KeeperException.Code code = createResponse2.resultCode();
                TopicPartition partition = (TopicPartition)createResponse2.ctx().get();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)this.leaderIsrAndControllerEpochs$1.apply((Object)partition);
                KeeperException.Code code2 = code;
                KeeperException.Code code3 = KeeperException.Code.OK;
                if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionFullReplicaAssignment(partition), true);
                    boxedUnit = this.successfulInitializations$1.$plus$eq((Object)partition);
                } else {
                    this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulInitializations$1 = successfulInitializations$1;
                this.leaderIsrAndControllerEpochs$1 = leaderIsrAndControllerEpochs$1;
            }
        });
        return var2_2;
    }

    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Seq remaining = partitions;
        scala.collection.mutable.Map finishedElections = Map$.MODULE$.empty();
        while (remaining.nonEmpty()) {
            Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.doElectLeaderForPartitions(remaining, partitionLeaderElectionStrategy);
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Seq updatesToRetry;
                Tuple2 tuple22;
                Map finished = (Map)tuple2._1();
                Seq updatesToRetry2 = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)finished, (Object)updatesToRetry2);
                Map finished2 = (Map)tuple23._1();
                remaining = updatesToRetry = (Seq)tuple23._2();
                finished2.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ZkPartitionStateMachine $outer;

                    public final void apply(Tuple2<TopicPartition, Either<Exception, LeaderAndIsr>> x0$7) {
                        Tuple2<TopicPartition, Either<Exception, LeaderAndIsr>> tuple2;
                        block4: {
                            block3: {
                                Either either;
                                block2: {
                                    tuple2 = x0$7;
                                    if (tuple2 == null) break block2;
                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                    Either either2 = (Either)tuple2._2();
                                    if (!(either2 instanceof Left)) break block2;
                                    Left left = (Left)either2;
                                    Exception e = (Exception)left.a();
                                    this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, e);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (tuple2 == null || !((either = (Either)tuple2._2()) instanceof Right)) break block4;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                finishedElections.$plus$plus$eq((TraversableOnce)finished2);
                if (remaining.nonEmpty()) {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Retrying leader election with strategy {} for partitions {}", new Object[]{partitionLeaderElectionStrategy, remaining});
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError(tuple2);
        }
        return finishedElections.toMap(Predef$.MODULE$.$conforms());
    }

    private Tuple2<Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2;
        block12: {
            Tuple2 tuple2;
            scala.collection.mutable.Map failedElections;
            block9: {
                Buffer validLeaderAndIsrs;
                block11: {
                    block10: {
                        block8: {
                            Seq<GetDataResponse> getDataResponses;
                            try {
                                getDataResponses = this.zkClient.getTopicPartitionStatesRaw(partitions);
                            }
                            catch (Exception exception) {
                                return new Tuple2((Object)partitions.iterator().map((Function1)new Serializable(this, exception){
                                    public static final long serialVersionUID = 0L;
                                    private final Exception e$5;

                                    public final Tuple2<TopicPartition, Left<Exception, Nothing$>> apply(TopicPartition x$5) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$5), (Object)package$.MODULE$.Left().apply((Object)this.e$5));
                                    }
                                    {
                                        this.e$5 = e$5;
                                    }
                                }).toMap(Predef$.MODULE$.$conforms()), (Object)Seq$.MODULE$.empty());
                            }
                            failedElections = Map$.MODULE$.empty();
                            validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
                            getDataResponses.foreach((Function1)new Serializable(this, failedElections, validLeaderAndIsrs){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ZkPartitionStateMachine $outer;
                                private final scala.collection.mutable.Map failedElections$1;
                                private final Buffer validLeaderAndIsrs$1;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object apply(GetDataResponse getDataResponse) {
                                    Option option;
                                    TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
                                    PartitionState currState = this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
                                    KeeperException.Code code = getDataResponse.resultCode();
                                    KeeperException.Code code2 = KeeperException.Code.OK;
                                    if (!(code != null ? !code.equals(code2) : code2 != null)) {
                                        Buffer buffer;
                                        Option<LeaderIsrAndControllerEpoch> option2 = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                                        if (option2 instanceof Some) {
                                            Buffer buffer2;
                                            Some some = (Some)option2;
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            if (leaderIsrAndControllerEpoch.controllerEpoch() > this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch()) {
                                                String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborted leader election for partition ", " since the LeaderAndIsr path was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already written by another controller. This probably means that the current controller ", " went through "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a soft failure and another controller was elected with epoch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString();
                                                buffer2 = this.failedElections$1.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
                                            } else {
                                                buffer2 = this.validLeaderAndIsrs$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch.leaderAndIsr()));
                                            }
                                            buffer = buffer2;
                                        } else {
                                            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                                            StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                                            buffer = this.failedElections$1.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)exception));
                                        }
                                        option = buffer;
                                        return option;
                                    } else {
                                        KeeperException.Code code3 = getDataResponse.resultCode();
                                        KeeperException.Code code4 = KeeperException.Code.NONODE;
                                        if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                                            StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                                            option = this.failedElections$1.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)exception));
                                            return option;
                                        } else {
                                            option = this.failedElections$1.put((Object)partition, (Object)package$.MODULE$.Left().apply(getDataResponse.resultException().get()));
                                        }
                                    }
                                    return option;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.failedElections$1 = failedElections$1;
                                    this.validLeaderAndIsrs$1 = validLeaderAndIsrs$1;
                                }
                            });
                            if (validLeaderAndIsrs.isEmpty()) {
                                return new Tuple2((Object)failedElections.toMap(Predef$.MODULE$.$conforms()), (Object)Seq$.MODULE$.empty());
                            }
                            partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
                            if (!(partitionLeaderElectionStrategy2 instanceof OfflinePartitionLeaderElectionStrategy)) break block8;
                            OfflinePartitionLeaderElectionStrategy offlinePartitionLeaderElectionStrategy = (OfflinePartitionLeaderElectionStrategy)partitionLeaderElectionStrategy2;
                            boolean allowUnclean = offlinePartitionLeaderElectionStrategy.allowUnclean();
                            Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState = this.collectUncleanLeaderElectionState((Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs, allowUnclean);
                            tuple2 = Election$.MODULE$.leaderForOffline(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, partitionsWithUncleanLeaderElectionState).partition((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(ElectionResult x$6) {
                                    return x$6.leaderAndIsr().isEmpty();
                                }
                            });
                            break block9;
                        }
                        if (!ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block10;
                        tuple2 = Election$.MODULE$.leaderForReassign(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(ElectionResult x$7) {
                                return x$7.leaderAndIsr().isEmpty();
                            }
                        });
                        break block9;
                    }
                    if (!PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block11;
                    tuple2 = Election$.MODULE$.leaderForPreferredReplica(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ElectionResult x$8) {
                            return x$8.leaderAndIsr().isEmpty();
                        }
                    });
                    break block9;
                }
                if (!ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block12;
                tuple2 = Election$.MODULE$.leaderForControlledShutdown(this.kafka$controller$ZkPartitionStateMachine$$controllerContext, (Seq<Tuple2<TopicPartition, LeaderAndIsr>>)validLeaderAndIsrs).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ElectionResult x$9) {
                        return x$9.leaderAndIsr().isEmpty();
                    }
                });
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                Seq partitionsWithoutLeaders = (Seq)tuple22._1();
                Seq partitionsWithLeaders = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
                Seq partitionsWithoutLeaders2 = (Seq)tuple24._1();
                Seq partitionsWithLeaders2 = (Seq)tuple24._2();
                partitionsWithoutLeaders2.foreach((Function1)new Serializable(this, partitionLeaderElectionStrategy, failedElections){
                    public static final long serialVersionUID = 0L;
                    private final PartitionLeaderElectionStrategy partitionLeaderElectionStrategy$1;
                    private final scala.collection.mutable.Map failedElections$1;

                    public final Option<Either<Exception, LeaderAndIsr>> apply(ElectionResult electionResult) {
                        TopicPartition partition = electionResult.topicPartition();
                        String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to elect leader for partition ", " under strategy ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, this.partitionLeaderElectionStrategy$1}));
                        return this.failedElections$1.put((Object)partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
                    }
                    {
                        this.partitionLeaderElectionStrategy$1 = partitionLeaderElectionStrategy$1;
                        this.failedElections$1 = failedElections$1;
                    }
                });
                scala.collection.immutable.Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, Seq<Object>> apply(ElectionResult result) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.liveReplicas());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                scala.collection.immutable.Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicPartition, LeaderAndIsr> apply(ElectionResult result) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicPartition()), result.leaderAndIsr().get());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch(), this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epochZkVersion());
                if (updateLeaderAndIsrResult != null) {
                    Tuple2 tuple25;
                    Map<TopicPartition, Either<Exception, LeaderAndIsr>> finishedUpdates = updateLeaderAndIsrResult.finishedPartitions();
                    Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
                    Tuple2 tuple26 = tuple25 = new Tuple2(finishedUpdates, updatesToRetry);
                    Map finishedUpdates2 = (Map)tuple26._1();
                    Seq updatesToRetry2 = (Seq)tuple26._2();
                    finishedUpdates2.foreach((Function1)new Serializable(this, recipientsPerPartition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkPartitionStateMachine $outer;
                        public final scala.collection.immutable.Map recipientsPerPartition$1;

                        public final Object apply(Tuple2<TopicPartition, Either<Exception, LeaderAndIsr>> x0$8) {
                            Tuple2<TopicPartition, Either<Exception, LeaderAndIsr>> tuple2 = x0$8;
                            if (tuple2 != null) {
                                TopicPartition partition = (TopicPartition)tuple2._1();
                                Either result = (Either)tuple2._2();
                                Object object = result.right().foreach((Function1)new Serializable(this, partition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$doElectLeaderForPartitions$3 $outer;
                                    private final TopicPartition partition$4;

                                    public final void apply(LeaderAndIsr leaderAndIsr) {
                                        ReplicaAssignment replicaAssignment2 = this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionFullReplicaAssignment(this.partition$4);
                                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch());
                                        this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)this.partition$4, (Object)leaderIsrAndControllerEpoch);
                                        this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)this.$outer.recipientsPerPartition$1.apply((Object)this.partition$4)), this.partition$4, leaderIsrAndControllerEpoch, replicaAssignment2, false);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.partition$4 = partition$4;
                                    }
                                });
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.recipientsPerPartition$1 = recipientsPerPartition$1;
                        }
                    });
                    return new Tuple2((Object)finishedUpdates2.$plus$plus((GenTraversableOnce)failedElections), (Object)updatesToRetry2);
                }
                throw new MatchError((Object)updateLeaderAndIsrResult);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)partitionLeaderElectionStrategy2);
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> collectUncleanLeaderElectionState(Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs, boolean allowUnclean) {
        Tuple2 tuple2;
        block2: {
            Tuple2<Map<String, LogConfig>, Map<String, Exception>> tuple22;
            block5: {
                Seq seq;
                Seq partitionsWithLiveInSyncReplicas;
                block4: {
                    Tuple2 tuple23;
                    Seq partitionsWithNoLiveInSyncReplicas;
                    block3: {
                        Tuple2 tuple24;
                        tuple2 = leaderAndIsrs.partition((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ZkPartitionStateMachine $outer;

                            public final boolean apply(Tuple2<TopicPartition, LeaderAndIsr> x0$9) {
                                Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$9;
                                if (tuple2 != null) {
                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                    List liveInSyncReplicas = (List)leaderAndIsr.isr().filter((Function1)new Serializable(this, partition){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$22 $outer;
                                        private final TopicPartition partition$5;

                                        public final boolean apply(int x$12) {
                                            return this.apply$mcZI$sp(x$12);
                                        }

                                        public boolean apply$mcZI$sp(int x$12) {
                                            return this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline(x$12, this.partition$5, this.$outer.kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer().kafka$controller$ZkPartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.partition$5 = partition$5;
                                        }
                                    });
                                    boolean bl = liveInSyncReplicas.isEmpty();
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }

                            public /* synthetic */ ZkPartitionStateMachine kafka$controller$ZkPartitionStateMachine$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (tuple2 == null) break block2;
                        Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple2._1();
                        Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple2._2();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas2, (Object)partitionsWithLiveInSyncReplicas2);
                        partitionsWithNoLiveInSyncReplicas = (Seq)tuple25._1();
                        partitionsWithLiveInSyncReplicas = (Seq)tuple25._2();
                        if (!allowUnclean) break block3;
                        seq = (Seq)partitionsWithNoLiveInSyncReplicas.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Object> apply(Tuple2<TopicPartition, LeaderAndIsr> x0$10) {
                                Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$10;
                                if (tuple2 != null) {
                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                    Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                                    return tuple3;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        break block4;
                    }
                    tuple22 = this.zkClient.getLogConfigs((Set<String>)partitionsWithNoLiveInSyncReplicas.iterator().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<TopicPartition, LeaderAndIsr> x0$11) {
                            Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$11;
                            if (tuple2 != null) {
                                TopicPartition partition = (TopicPartition)tuple2._1();
                                String string = partition.topic();
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                    }).toSet(), this.config.originals());
                    if (tuple22 == null) break block5;
                    Map logConfigs = (Map)tuple22._1();
                    Map failed = (Map)tuple22._2();
                    Tuple2 tuple26 = tuple23 = new Tuple2((Object)logConfigs, (Object)failed);
                    Map logConfigs2 = (Map)tuple26._1();
                    Map failed2 = (Map)tuple26._2();
                    seq = (Seq)partitionsWithNoLiveInSyncReplicas.map((Function1)new Serializable(this, logConfigs2, failed2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ZkPartitionStateMachine $outer;
                        private final Map logConfigs$1;
                        private final Map failed$1;

                        public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Object> apply(Tuple2<TopicPartition, LeaderAndIsr> x0$12) {
                            Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$12;
                            if (tuple2 != null) {
                                Tuple3 tuple3;
                                TopicPartition partition = (TopicPartition)tuple2._1();
                                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                if (this.failed$1.contains((Object)partition.topic())) {
                                    this.$outer.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, this.$outer.kafka$controller$ZkPartitionStateMachine$$partitionState(partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)this.failed$1.apply((Object)partition.topic()));
                                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                                } else {
                                    tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)((Object)this.logConfigs$1.apply((Object)partition.topic()))).uncleanLeaderElectionEnable()));
                                }
                                Tuple3 tuple32 = tuple3;
                                return tuple32;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.logConfigs$1 = logConfigs$1;
                            this.failed$1 = failed$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                Seq electionForPartitionWithoutLiveReplicas = seq;
                return (Seq)electionForPartitionWithoutLiveReplicas.$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Object> apply(Tuple2<TopicPartition, LeaderAndIsr> x0$13) {
                        Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$13;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            return tuple3;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    public void kafka$controller$ZkPartitionStateMachine$$logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = this.kafka$controller$ZkPartitionStateMachine$$partitionState(partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should be in one of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " states before moving to ", " state. Instead it is in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState.validPreviousStates().mkString(","), targetState}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState}))).toString());
        this.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, currState, targetState, e);
    }

    public void kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    public void kafka$controller$ZkPartitionStateMachine$$logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch()).error((Function0<String>)new Serializable(this, partition, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkPartitionStateMachine $outer;
            private final TopicPartition partition$3;
            private final PartitionState currState$1;
            private final PartitionState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " failed to change state for partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ZkPartitionStateMachine$$controllerContext.epoch()), this.partition$3}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currState$1, this.targetState$3}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$3 = partition$3;
                this.currState$1 = currState$1;
                this.targetState$3 = targetState$3;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public ZkPartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.kafka$controller$ZkPartitionStateMachine$$controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.kafka$controller$ZkPartitionStateMachine$$controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.kafka$controller$ZkPartitionStateMachine$$controllerId = config.brokerId();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[PartitionStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$ZkPartitionStateMachine$$controllerId())})));
    }
}

