/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.field;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.ads.field.AdsField;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class DirectAdsField
implements AdsField {
    private static final Pattern RESOURCE_ADDRESS_PATTERN = Pattern.compile("^((0[xX](?<indexGroupHex>[0-9a-fA-F]+))|(?<indexGroup>\\d+))/((0[xX](?<indexOffsetHex>[0-9a-fA-F]+))|(?<indexOffset>\\d+)):(?<adsDataType>\\w+)(\\[(?<numberOfElements>\\d+)])?");
    private final long indexGroup;
    private final long indexOffset;
    private final String adsDataTypeName;
    private final int numberOfElements;

    public DirectAdsField(long indexGroup, long indexOffset, String adsDataTypeName, Integer numberOfElements) {
        this.indexGroup = indexGroup;
        this.indexOffset = indexOffset;
        this.adsDataTypeName = Objects.requireNonNull(adsDataTypeName);
        int n = this.numberOfElements = numberOfElements != null ? numberOfElements : 1;
        if (this.numberOfElements <= 0) {
            throw new IllegalArgumentException("numberOfElements must be greater then zero. Was " + this.numberOfElements);
        }
    }

    public static DirectAdsField of(long indexGroup, long indexOffset, String adsDataTypeName, Integer numberOfElements) {
        return new DirectAdsField(indexGroup, indexOffset, adsDataTypeName, numberOfElements);
    }

    public static DirectAdsField of(String address) {
        Matcher matcher = RESOURCE_ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(address, RESOURCE_ADDRESS_PATTERN, "{indexGroup}/{indexOffset}:{adsDataType}([numberOfElements])?");
        }
        String indexGroupStringHex = matcher.group("indexGroupHex");
        String indexGroupString = matcher.group("indexGroup");
        String indexOffsetStringHex = matcher.group("indexOffsetHex");
        String indexOffsetString = matcher.group("indexOffset");
        long indexGroup = indexGroupStringHex != null ? Long.parseLong(indexGroupStringHex, 16) : Long.parseLong(indexGroupString);
        long indexOffset = indexOffsetStringHex != null ? Long.parseLong(indexOffsetStringHex, 16) : Long.parseLong(indexOffsetString);
        String adsDataTypeString = matcher.group("adsDataType");
        String numberOfElementsString = matcher.group("numberOfElements");
        Integer numberOfElements = numberOfElementsString != null ? Integer.valueOf(numberOfElementsString) : null;
        return new DirectAdsField(indexGroup, indexOffset, adsDataTypeString, numberOfElements);
    }

    public static boolean matches(String address) {
        return RESOURCE_ADDRESS_PATTERN.matcher(address).matches();
    }

    public long getIndexGroup() {
        return this.indexGroup;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public String getPlcDataType() {
        return this.adsDataTypeName;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectAdsField)) {
            return false;
        }
        DirectAdsField that = (DirectAdsField)o;
        return this.indexGroup == that.indexGroup && this.indexOffset == that.indexOffset;
    }

    public int hashCode() {
        return Objects.hash(this.indexGroup, this.indexOffset);
    }

    public String toString() {
        return "DirectAdsField{indexGroup=" + this.indexGroup + ", indexOffset=" + this.indexOffset + '}';
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("indexGroup", 32, this.getIndexGroup(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("indexOffset", 32, this.getIndexOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("numberOfElements", 32, (long)this.getNumberOfElements(), new WithWriterArgs[0]);
        String plcDataType = this.getPlcDataType();
        writeBuffer.writeString("dataType", plcDataType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), plcDataType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

