/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.field;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.ads.field.AdsStringField;
import org.apache.plc4x.java.ads.field.DirectAdsField;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class DirectAdsStringField
extends DirectAdsField
implements AdsStringField {
    private static final Pattern RESOURCE_STRING_ADDRESS_PATTERN = Pattern.compile("^((0[xX](?<indexGroupHex>[0-9a-fA-F]+))|(?<indexGroup>\\d+))/((0[xX](?<indexOffsetHex>[0-9a-fA-F]+))|(?<indexOffset>\\d+)):(?<adsDataType>STRING|WSTRING)\\((?<stringLength>\\d{1,3})\\)(\\[(?<numberOfElements>\\d+)])?");
    private final int stringLength;

    public DirectAdsStringField(long indexGroup, long indexOffset, String adsDataTypeName, int stringLength, Integer numberOfElements) {
        super(indexGroup, indexOffset, adsDataTypeName, numberOfElements);
        this.stringLength = stringLength;
    }

    public static DirectAdsStringField of(long indexGroup, long indexOffset, String adsDataTypeName, int stringLength, Integer numberOfElements) {
        return new DirectAdsStringField(indexGroup, indexOffset, adsDataTypeName, stringLength, numberOfElements);
    }

    public static DirectAdsStringField of(String address) {
        Matcher matcher = RESOURCE_STRING_ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(address, RESOURCE_STRING_ADDRESS_PATTERN, "{indexGroup}/{indexOffset}:{adsDataType}([numberOfElements])?");
        }
        String indexGroupStringHex = matcher.group("indexGroupHex");
        String indexGroupString = matcher.group("indexGroup");
        String indexOffsetStringHex = matcher.group("indexOffsetHex");
        String indexOffsetString = matcher.group("indexOffset");
        long indexGroup = indexGroupStringHex != null ? Long.parseLong(indexGroupStringHex, 16) : Long.parseLong(indexGroupString);
        long indexOffset = indexOffsetStringHex != null ? Long.parseLong(indexOffsetStringHex, 16) : Long.parseLong(indexOffsetString);
        String adsDataTypeName = matcher.group("adsDataType");
        String stringLengthString = matcher.group("stringLength");
        int stringLength = stringLengthString != null ? Integer.parseInt(stringLengthString) : 0;
        String numberOfElementsString = matcher.group("numberOfElements");
        Integer numberOfElements = numberOfElementsString != null ? Integer.valueOf(numberOfElementsString) : null;
        return new DirectAdsStringField(indexGroup, indexOffset, adsDataTypeName, stringLength, numberOfElements);
    }

    public static boolean matches(String address) {
        return RESOURCE_STRING_ADDRESS_PATTERN.matcher(address).matches();
    }

    @Override
    public int getStringLength() {
        return this.stringLength;
    }

    @Override
    public String toString() {
        return "DirectAdsStringField{indexGroup=" + this.getIndexGroup() + ", indexOffset=" + this.getIndexOffset() + ", stringLength=" + this.stringLength + '}';
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("indexGroup", 32, this.getIndexGroup(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("indexOffset", 32, this.getIndexOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("numberOfElements", 32, (long)this.getNumberOfElements(), new WithWriterArgs[0]);
        String plcDataType = this.getPlcDataType();
        writeBuffer.writeString("dataType", plcDataType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), plcDataType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

