/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.field;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.ads.field.AdsField;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class SymbolicAdsField
implements AdsField {
    private static final Pattern SYMBOLIC_ADDRESS_PATTERN = Pattern.compile("^(?<symbolicAddress>.+)");
    private final String symbolicAddress;

    public SymbolicAdsField(String symbolicAddress) {
        this.symbolicAddress = Objects.requireNonNull(symbolicAddress);
    }

    public static SymbolicAdsField of(String address) {
        Matcher matcher = SYMBOLIC_ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidFieldException(address, SYMBOLIC_ADDRESS_PATTERN, "{address}");
        }
        String symbolicAddress = matcher.group("symbolicAddress");
        return new SymbolicAdsField(symbolicAddress);
    }

    public static boolean matches(String address) {
        return SYMBOLIC_ADDRESS_PATTERN.matcher(address).matches();
    }

    public String getSymbolicAddress() {
        return this.symbolicAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymbolicAdsField)) {
            return false;
        }
        SymbolicAdsField that = (SymbolicAdsField)o;
        return Objects.equals(this.symbolicAddress, that.symbolicAddress);
    }

    public int hashCode() {
        return Objects.hash(this.symbolicAddress);
    }

    public String toString() {
        return "SymbolicAdsField{symbolicAddress='" + this.symbolicAddress + '\'' + '}';
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String symbolicAddress = this.getSymbolicAddress();
        writeBuffer.writeString("symbolicAddress", symbolicAddress.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), symbolicAddress, new WithWriterArgs[0]);
        writeBuffer.writeUnsignedLong("numberOfElements", 32, (long)this.getNumberOfElements(), new WithWriterArgs[0]);
        String dataType = this.getPlcDataType();
        writeBuffer.writeString("dataType", dataType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), dataType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

