/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.protocol;

import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.plc4x.java.ads.configuration.AdsConfiguration;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscovery;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockAmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockHostName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockPassword;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockRouteName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockStatus;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockType;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockUserName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryConstants;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsPortNumbers;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsString;
import org.apache.plc4x.java.ads.discovery.readwrite.Operation;
import org.apache.plc4x.java.ads.discovery.readwrite.Status;
import org.apache.plc4x.java.ads.field.AdsField;
import org.apache.plc4x.java.ads.field.DirectAdsField;
import org.apache.plc4x.java.ads.field.SymbolicAdsField;
import org.apache.plc4x.java.ads.model.AdsSubscriptionHandle;
import org.apache.plc4x.java.ads.readwrite.AdsAddDeviceNotificationRequest;
import org.apache.plc4x.java.ads.readwrite.AdsAddDeviceNotificationResponse;
import org.apache.plc4x.java.ads.readwrite.AdsDataTypeArrayInfo;
import org.apache.plc4x.java.ads.readwrite.AdsDataTypeTableChildEntry;
import org.apache.plc4x.java.ads.readwrite.AdsDataTypeTableEntry;
import org.apache.plc4x.java.ads.readwrite.AdsDeleteDeviceNotificationRequest;
import org.apache.plc4x.java.ads.readwrite.AdsDeleteDeviceNotificationResponse;
import org.apache.plc4x.java.ads.readwrite.AdsDeviceNotificationRequest;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItemRead;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItemReadWrite;
import org.apache.plc4x.java.ads.readwrite.AdsMultiRequestItemWrite;
import org.apache.plc4x.java.ads.readwrite.AdsNotificationSample;
import org.apache.plc4x.java.ads.readwrite.AdsReadDeviceInfoRequest;
import org.apache.plc4x.java.ads.readwrite.AdsReadDeviceInfoResponse;
import org.apache.plc4x.java.ads.readwrite.AdsReadRequest;
import org.apache.plc4x.java.ads.readwrite.AdsReadResponse;
import org.apache.plc4x.java.ads.readwrite.AdsReadWriteRequest;
import org.apache.plc4x.java.ads.readwrite.AdsReadWriteResponse;
import org.apache.plc4x.java.ads.readwrite.AdsStampHeader;
import org.apache.plc4x.java.ads.readwrite.AdsSymbolTableEntry;
import org.apache.plc4x.java.ads.readwrite.AdsTableSizes;
import org.apache.plc4x.java.ads.readwrite.AdsWriteRequest;
import org.apache.plc4x.java.ads.readwrite.AdsWriteResponse;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.AmsTCPPacket;
import org.apache.plc4x.java.ads.readwrite.DataItem;
import org.apache.plc4x.java.ads.readwrite.DefaultAmsPorts;
import org.apache.plc4x.java.ads.readwrite.ReservedIndexGroups;
import org.apache.plc4x.java.ads.readwrite.ReturnCode;
import org.apache.plc4x.java.api.authentication.PlcUsernamePasswordAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcBrowseItem;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultBrowseItemArrayInfo;
import org.apache.plc4x.java.spi.messages.DefaultListPlcBrowseItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcBrowseResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcBrowser;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsProtocolLogic
extends Plc4xProtocolBase<AmsTCPPacket>
implements HasConfiguration<AdsConfiguration>,
PlcSubscriber,
PlcBrowser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsProtocolLogic.class);
    private AdsConfiguration configuration;
    private String adsVersion;
    private String deviceName;
    private final AtomicLong invokeIdGenerator = new AtomicLong(1L);
    private final RequestTransactionManager tm;
    private final Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();
    private final ConcurrentHashMap<SymbolicAdsField, CompletableFuture<Void>> pendingResolutionRequests = new ConcurrentHashMap();
    private int symbolVersion;
    private long onlineVersion;
    private final Map<String, AdsSymbolTableEntry> symbolTable = new HashMap<String, AdsSymbolTableEntry>();
    private final Map<String, AdsDataTypeTableEntry> dataTypeTable = new HashMap<String, AdsDataTypeTableEntry>();
    private final ReentrantLock invalidationLock = new ReentrantLock();

    public AdsProtocolLogic() {
        this.tm = new RequestTransactionManager(1);
    }

    public void setConfiguration(AdsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void close(ConversationContext<AmsTCPPacket> context) {
    }

    public void onConnect(ConversationContext<AmsTCPPacket> context) {
        CompletableFuture<Object> setupAmsRouteFuture;
        CompletableFuture future = new CompletableFuture();
        if (context.getAuthentication() != null) {
            if (!(context.getAuthentication() instanceof PlcUsernamePasswordAuthentication)) {
                future.completeExceptionally((Throwable)new PlcConnectionException("This type of connection only supports username-password authentication"));
                return;
            }
            PlcUsernamePasswordAuthentication usernamePasswordAuthentication = (PlcUsernamePasswordAuthentication)context.getAuthentication();
            setupAmsRouteFuture = this.setupAmsRoute(usernamePasswordAuthentication);
        } else {
            setupAmsRouteFuture = CompletableFuture.completedFuture(null);
        }
        setupAmsRouteFuture.whenComplete((unused, throwable) -> {
            if (!this.configuration.isLoadSymbolAndDataTypeTables()) {
                future.completeExceptionally((Throwable)new PlcConnectionException("Lazy loading is generally planned, but not implemented yet. If you are in need for this feature, please reach out to the community."));
            }
            AdsReadDeviceInfoRequest readDeviceInfoRequest = new AdsReadDeviceInfoRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId());
            RequestTransactionManager.RequestTransaction readDeviceInfoTx = this.tm.startRequest();
            readDeviceInfoTx.submit(() -> context.sendRequest((Object)new AmsTCPPacket(readDeviceInfoRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == readDeviceInfoRequest.getInvokeId()).unwrap(response -> (AdsReadDeviceInfoResponse)response.getUserdata()).handle(readDeviceInfoResponse -> {
                readDeviceInfoTx.endRequest();
                if (readDeviceInfoResponse.getResult() != ReturnCode.OK) {
                    future.completeExceptionally((Throwable)new PlcException("Result is " + (Object)((Object)readDeviceInfoResponse.getResult())));
                    return;
                }
                this.adsVersion = String.format("%d.%d.%d", readDeviceInfoResponse.getMajorVersion(), readDeviceInfoResponse.getMinorVersion(), readDeviceInfoResponse.getVersion());
                this.deviceName = new String(readDeviceInfoResponse.getDevice()).trim();
                AdsReadWriteRequest readOnlineVersionNumberRequest = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_VALBYNAME.getValue(), 0L, 4L, null, "TwinCAT_SystemInfoVarList._AppInfo.OnlineChangeCnt".getBytes(StandardCharsets.UTF_8));
                RequestTransactionManager.RequestTransaction readOnlineVersionNumberTx = this.tm.startRequest();
                readOnlineVersionNumberTx.submit(() -> context.sendRequest((Object)new AmsTCPPacket(readOnlineVersionNumberRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == readOnlineVersionNumberRequest.getInvokeId()).unwrap(response -> (AdsReadWriteResponse)response.getUserdata()).handle(readOnlineVersionNumberResponse -> {
                    readOnlineVersionNumberTx.endRequest();
                    if (readOnlineVersionNumberResponse.getResult() != ReturnCode.OK) {
                        future.completeExceptionally((Throwable)new PlcException("Result is " + (Object)((Object)readOnlineVersionNumberResponse.getResult())));
                        return;
                    }
                    try {
                        ReadBufferByteBased rb = new ReadBufferByteBased(readOnlineVersionNumberResponse.getData());
                        this.onlineVersion = rb.readUnsignedLong(32);
                        AdsReadRequest readSymbolVersionNumberRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), DefaultAmsPorts.RUNTIME_SYSTEM_01.getValue(), this.configuration.getSourceAmsNetId(), 800, 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_VERSION.getValue(), 0L, 1L);
                        RequestTransactionManager.RequestTransaction readSymbolVersionNumberTx = this.tm.startRequest();
                        readSymbolVersionNumberTx.submit(() -> context.sendRequest((Object)new AmsTCPPacket(readSymbolVersionNumberRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == readSymbolVersionNumberRequest.getInvokeId()).unwrap(response -> (AdsReadResponse)response.getUserdata()).handle(readSymbolVersionNumberResponse -> {
                            readSymbolVersionNumberTx.endRequest();
                            if (readSymbolVersionNumberResponse.getResult() != ReturnCode.OK) {
                                future.completeExceptionally((Throwable)new PlcException("Result is " + (Object)((Object)readSymbolVersionNumberResponse.getResult())));
                                return;
                            }
                            try {
                                ReadBufferByteBased rb2 = new ReadBufferByteBased(readSymbolVersionNumberResponse.getData());
                                this.symbolVersion = rb2.readUnsignedInt(8);
                                LOGGER.debug("Fetching sizes of symbol and datatype table sizes.");
                                CompletableFuture<Void> readSymbolTableFuture = this.readSymbolTableAndDatatypeTable(context);
                                readSymbolTableFuture.whenComplete((unused2, throwable2) -> {
                                    if (throwable2 != null) {
                                        LOGGER.error("Error fetching symbol and datatype table sizes");
                                    } else {
                                        context.fireConnected();
                                    }
                                });
                            }
                            catch (ParseException e) {
                                future.completeExceptionally((Throwable)new PlcConnectionException("Error reading the symbol version of data type and symbol data.", (Throwable)e));
                            }
                        }));
                    }
                    catch (ParseException e) {
                        future.completeExceptionally((Throwable)new PlcConnectionException("Error reading the online version of data type and symbol data.", (Throwable)e));
                    }
                }));
            }));
        });
    }

    protected CompletableFuture<Void> setupAmsRoute(PlcUsernamePasswordAuthentication authentication) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        new Thread(() -> {
            LOGGER.debug("Setting up remote AMS routes.");
            SocketAddress localSocketAddress = this.context.getChannel().localAddress();
            InetAddress localAddress = ((InetSocketAddress)localSocketAddress).getAddress();
            AmsNetId sourceAmsNetId = new AmsNetId(this.configuration.getSourceAmsNetId().getOctet1(), this.configuration.getSourceAmsNetId().getOctet2(), this.configuration.getSourceAmsNetId().getOctet3(), this.configuration.getSourceAmsNetId().getOctet4(), this.configuration.getSourceAmsNetId().getOctet5(), this.configuration.getSourceAmsNetId().getOctet6());
            String routeName = String.format("PLC4X-%d.%d.%d.%d.%d.%d", sourceAmsNetId.getOctet1(), sourceAmsNetId.getOctet2(), sourceAmsNetId.getOctet3(), sourceAmsNetId.getOctet4(), sourceAmsNetId.getOctet5(), sourceAmsNetId.getOctet6());
            AdsDiscovery addOrUpdateRouteRequest = new AdsDiscovery(this.getInvokeId(), Operation.ADD_OR_UPDATE_ROUTE_REQUEST, sourceAmsNetId, AdsPortNumbers.SYSTEM_SERVICE, Arrays.asList(new AdsDiscoveryBlockRouteName(new AmsString(routeName)), new AdsDiscoveryBlockAmsNetId(sourceAmsNetId), new AdsDiscoveryBlockUserName(new AmsString(authentication.getUsername())), new AdsDiscoveryBlockPassword(new AmsString(authentication.getPassword())), new AdsDiscoveryBlockHostName(new AmsString(localAddress.getHostAddress()))));
            try (DatagramSocket adsDiscoverySocket = new DatagramSocket(AdsDiscoveryConstants.ADSDISCOVERYUDPDEFAULTPORT);){
                WriteBufferByteBased writeBuffer = new WriteBufferByteBased(addOrUpdateRouteRequest.getLengthInBytes(), ByteOrder.LITTLE_ENDIAN);
                addOrUpdateRouteRequest.serialize((WriteBuffer)writeBuffer);
                SocketAddress remoteSocketAddress = this.context.getChannel().remoteAddress();
                InetAddress remoteAddress = ((InetSocketAddress)remoteSocketAddress).getAddress();
                DatagramPacket discoveryRequestPacket = new DatagramPacket(writeBuffer.getBytes(), writeBuffer.getBytes().length, remoteAddress, AdsDiscoveryConstants.ADSDISCOVERYUDPDEFAULTPORT);
                adsDiscoverySocket.send(discoveryRequestPacket);
                byte[] buf = new byte[100];
                DatagramPacket responsePacket = new DatagramPacket(buf, buf.length);
                adsDiscoverySocket.setSoTimeout(this.configuration.getTimeoutRequest());
                adsDiscoverySocket.receive(responsePacket);
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(responsePacket.getData(), ByteOrder.LITTLE_ENDIAN);
                AdsDiscovery addOrUpdateRouteResponse = AdsDiscovery.staticParse((ReadBuffer)readBuffer);
                if (addOrUpdateRouteResponse.getRequestId() == 1L) {
                    for (AdsDiscoveryBlock block : addOrUpdateRouteResponse.getBlocks()) {
                        AdsDiscoveryBlockStatus statusBlock;
                        if (block.getBlockType() != AdsDiscoveryBlockType.STATUS || (statusBlock = (AdsDiscoveryBlockStatus)block).getStatus() == Status.SUCCESS) continue;
                        future.completeExceptionally((Throwable)new PlcException("Error adding AMS route"));
                        return;
                    }
                }
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)new PlcException("Error adding AMS route", (Throwable)e));
            }
        }).start();
        return future;
    }

    protected CompletableFuture<Void> readSymbolTableAndDatatypeTable(ConversationContext<AmsTCPPacket> context) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AdsReadRequest readDataAndSymbolTableSizesRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYMBOL_AND_DATA_TYPE_SIZES.getValue(), 0L, 24L);
        RequestTransactionManager.RequestTransaction readDataAndSymbolTableSizesTx = this.tm.startRequest();
        readDataAndSymbolTableSizesTx.submit(() -> context.sendRequest((Object)new AmsTCPPacket(readDataAndSymbolTableSizesRequest)).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == readDataAndSymbolTableSizesRequest.getInvokeId()).unwrap(response -> (AdsReadResponse)response.getUserdata()).handle(readDataAndSymbolTableSizesResponse -> {
            readDataAndSymbolTableSizesTx.endRequest();
            if (readDataAndSymbolTableSizesResponse.getResult() != ReturnCode.OK) {
                future.completeExceptionally((Throwable)new PlcException("Reading data type and symbol table sizes failed: " + (Object)((Object)readDataAndSymbolTableSizesResponse.getResult())));
                return;
            }
            try {
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(readDataAndSymbolTableSizesResponse.getData());
                AdsTableSizes adsTableSizes = AdsTableSizes.staticParse((ReadBuffer)readBuffer);
                LOGGER.debug("PLC contains {} symbols and {} data-types", (Object)adsTableSizes.getSymbolCount(), (Object)adsTableSizes.getDataTypeCount());
                AdsReadRequest readDataTypeTableRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_DATA_TYPE_TABLE_UPLOAD.getValue(), 0L, adsTableSizes.getDataTypeLength());
                RequestTransactionManager.RequestTransaction readDataTypeTableTx = this.tm.startRequest();
                AmsTCPPacket amsReadTableTCPPacket = new AmsTCPPacket(readDataTypeTableRequest);
                readDataTypeTableTx.submit(() -> context.sendRequest((Object)amsReadTableTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == readDataTypeTableRequest.getInvokeId()).unwrap(response -> (AdsReadResponse)response.getUserdata()).handle(readDataTypeTableResponse -> {
                    readDataTypeTableTx.endRequest();
                    if (readDataTypeTableResponse.getResult() != ReturnCode.OK) {
                        future.completeExceptionally((Throwable)new PlcException("Reading data type table failed: " + (Object)((Object)readDataTypeTableResponse.getResult())));
                        return;
                    }
                    ReadBufferByteBased rb = new ReadBufferByteBased(readDataTypeTableResponse.getData());
                    int i = 0;
                    while ((long)i < adsTableSizes.getDataTypeCount()) {
                        try {
                            AdsDataTypeTableEntry adsDataTypeTableEntry = AdsDataTypeTableEntry.staticParse((ReadBuffer)rb);
                            this.dataTypeTable.put(adsDataTypeTableEntry.getDataTypeName(), adsDataTypeTableEntry);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                        ++i;
                    }
                    AdsReadRequest readSymbolTableRequest = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_UPLOAD.getValue(), 0L, adsTableSizes.getSymbolLength());
                    RequestTransactionManager.RequestTransaction readSymbolTableTx = this.tm.startRequest();
                    AmsTCPPacket amsReadSymbolTableTCPPacket = new AmsTCPPacket(readSymbolTableRequest);
                    readSymbolTableTx.submit(() -> context.sendRequest((Object)amsReadSymbolTableTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == readSymbolTableRequest.getInvokeId()).unwrap(response -> (AdsReadResponse)response.getUserdata()).handle(readSymbolTableResponse -> {
                        readSymbolTableTx.endRequest();
                        if (readSymbolTableResponse.getResult() != ReturnCode.OK) {
                            future.completeExceptionally((Throwable)new PlcException("Reading symbol table failed: " + (Object)((Object)readSymbolTableResponse.getResult())));
                            return;
                        }
                        ReadBufferByteBased rb2 = new ReadBufferByteBased(readSymbolTableResponse.getData());
                        int i = 0;
                        while ((long)i < adsTableSizes.getSymbolCount()) {
                            try {
                                AdsSymbolTableEntry adsSymbolTableEntry = AdsSymbolTableEntry.staticParse((ReadBuffer)rb2);
                                this.symbolTable.put(adsSymbolTableEntry.getName(), adsSymbolTableEntry);
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                            ++i;
                        }
                        LinkedHashMap<String, DefaultPlcSubscriptionField> subscriptionFields = new LinkedHashMap<String, DefaultPlcSubscriptionField>();
                        subscriptionFields.put("onlineVersion", new DefaultPlcSubscriptionField(PlcSubscriptionType.CHANGE_OF_STATE, (PlcField)new SymbolicAdsField("TwinCAT_SystemInfoVarList._AppInfo.OnlineChangeCnt"), Duration.ofMillis(1000L)));
                        subscriptionFields.put("symbolVersion", new DefaultPlcSubscriptionField(PlcSubscriptionType.CHANGE_OF_STATE, (PlcField)new DirectAdsField(61448L, 0L, "USINT", 1), Duration.ofMillis(1000L)));
                        LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>> consumer = new LinkedHashMap<String, List<Consumer<PlcSubscriptionEvent>>>();
                        consumer.put("onlineVersion", Collections.singletonList(plcSubscriptionEvent -> {
                            long oldVersion = this.onlineVersion;
                            long newVersion = plcSubscriptionEvent.getPlcValue("onlineVersion").getLong();
                            if (oldVersion != newVersion && this.invalidationLock.tryLock()) {
                                LOGGER.info("Detected change of the 'online-version', invalidating data type and symbol information.");
                                CompletableFuture<Void> reloadingFuture = this.readSymbolTableAndDatatypeTable(context);
                                reloadingFuture.whenComplete((unused, throwable) -> {
                                    if (throwable != null) {
                                        LOGGER.error("Error reloading data type and symbol data", throwable);
                                    }
                                    this.invalidationLock.unlock();
                                });
                            }
                        }));
                        consumer.put("symbolVersion", Collections.singletonList(plcSubscriptionEvent -> {
                            int oldVersion = this.symbolVersion;
                            int newVersion = plcSubscriptionEvent.getPlcValue("symbolVersion").getInteger();
                            if (oldVersion != newVersion && this.invalidationLock.tryLock()) {
                                LOGGER.info("Detected change of the 'symbol-version', invalidating data type and symbol information.");
                                CompletableFuture<Void> reloadingFuture = this.readSymbolTableAndDatatypeTable(context);
                                reloadingFuture.whenComplete((unused, throwable) -> {
                                    if (throwable != null) {
                                        LOGGER.error("Error reloading data type and symbol data", throwable);
                                    }
                                    this.invalidationLock.unlock();
                                });
                            }
                        }));
                        DefaultPlcSubscriptionRequest subscriptionRequest = new DefaultPlcSubscriptionRequest((PlcSubscriber)this, subscriptionFields, consumer);
                        CompletableFuture<PlcSubscriptionResponse> subscriptionResponseCompletableFuture = this.subscribe((PlcSubscriptionRequest)subscriptionRequest);
                        subscriptionResponseCompletableFuture.whenComplete((plcSubscriptionResponse, throwable) -> {
                            if (throwable == null) {
                                future.complete(null);
                            }
                        });
                    }));
                }));
            }
            catch (ParseException e) {
                future.completeExceptionally((Throwable)new PlcException("Error loading the table sizes", (Throwable)e));
            }
        }));
        return future;
    }

    public void onDisconnect(ConversationContext<AmsTCPPacket> context) {
        super.onDisconnect(context);
    }

    public CompletableFuture<PlcBrowseResponse> browse(PlcBrowseRequest browseRequest) {
        CompletableFuture<PlcBrowseResponse> future = new CompletableFuture<PlcBrowseResponse>();
        ArrayList<Object> values = new ArrayList<Object>(this.symbolTable.size());
        for (AdsSymbolTableEntry symbol : this.symbolTable.values()) {
            AdsDataTypeTableEntry dataType = this.dataTypeTable.get(symbol.getDataTypeName());
            if (dataType == null) {
                System.out.printf("couldn't find datatype: %s%n", symbol.getDataTypeName());
                continue;
            }
            String itemName = symbol.getComment() == null || symbol.getComment().isEmpty() ? symbol.getName() : symbol.getComment();
            PlcValueType plc4xPlcValueType = PlcValueType.valueOf((String)this.getPlcValueTypeForAdsDataType(dataType).toString());
            List<PlcBrowseItem> children = this.getBrowseItems(symbol.getName(), symbol.getGroup(), symbol.getOffset(), !symbol.getFlagReadOnly(), dataType);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("comment", new PlcSTRING(symbol.getComment()));
            options.put("group-id", new PlcUDINT(symbol.getGroup()));
            options.put("offset", new PlcUDINT(symbol.getOffset()));
            options.put("size-in-bytes", new PlcUDINT(symbol.getSize()));
            if (plc4xPlcValueType == PlcValueType.List) {
                ArrayList<DefaultBrowseItemArrayInfo> arrayInfo = new ArrayList<DefaultBrowseItemArrayInfo>();
                for (AdsDataTypeArrayInfo adsDataTypeArrayInfo : dataType.getArrayInfo()) {
                    arrayInfo.add(new DefaultBrowseItemArrayInfo(adsDataTypeArrayInfo.getLowerBound(), adsDataTypeArrayInfo.getUpperBound()));
                }
                values.add(new DefaultListPlcBrowseItem(symbol.getName(), itemName, plc4xPlcValueType, arrayInfo, true, !symbol.getFlagReadOnly(), true, children, options));
                continue;
            }
            values.add(new DefaultPlcBrowseItem(symbol.getName(), itemName, plc4xPlcValueType, true, !symbol.getFlagReadOnly(), true, children, options));
        }
        DefaultPlcBrowseResponse response = new DefaultPlcBrowseResponse(browseRequest, PlcResponseCode.OK, values);
        future.complete((PlcBrowseResponse)response);
        return future;
    }

    protected List<PlcBrowseItem> getBrowseItems(String basePath, long baseGroupId, long baseOffset, boolean parentWritable, AdsDataTypeTableEntry dataType) {
        if (dataType.getNumChildren() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PlcBrowseItem> values = new ArrayList<PlcBrowseItem>(dataType.getNumChildren());
        for (AdsDataTypeTableChildEntry child : dataType.getChildren()) {
            AdsDataTypeTableEntry childDataType = this.dataTypeTable.get(child.getDataTypeName());
            if (childDataType == null) {
                System.out.printf("couldn't find datatype: %s%n", child.getDataTypeName());
                continue;
            }
            String itemAddress = basePath + "." + child.getPropertyName();
            String itemName = child.getComment() == null || child.getComment().isEmpty() ? child.getPropertyName() : child.getComment();
            PlcValueType plc4xPlcValueType = PlcValueType.valueOf((String)this.getPlcValueTypeForAdsDataType(childDataType).toString());
            List<PlcBrowseItem> children = this.getBrowseItems(itemAddress, baseGroupId, baseOffset + child.getOffset(), parentWritable, childDataType);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("comment", new PlcSTRING(child.getComment()));
            options.put("group-id", new PlcUDINT(baseGroupId));
            options.put("offset", new PlcUDINT(baseOffset + child.getOffset()));
            options.put("size-in-bytes", new PlcUDINT(childDataType.getSize()));
            if (plc4xPlcValueType == PlcValueType.List) {
                ArrayList<DefaultBrowseItemArrayInfo> arrayInfo = new ArrayList<DefaultBrowseItemArrayInfo>();
                for (AdsDataTypeArrayInfo adsDataTypeArrayInfo : childDataType.getArrayInfo()) {
                    arrayInfo.add(new DefaultBrowseItemArrayInfo(adsDataTypeArrayInfo.getLowerBound(), adsDataTypeArrayInfo.getUpperBound()));
                }
                values.add((PlcBrowseItem)new DefaultListPlcBrowseItem(basePath + "." + child.getPropertyName(), itemName, plc4xPlcValueType, arrayInfo, true, parentWritable, true, children, options));
                continue;
            }
            values.add((PlcBrowseItem)new DefaultPlcBrowseItem(basePath + "." + child.getPropertyName(), itemName, plc4xPlcValueType, true, parentWritable, true, children, options));
        }
        return values;
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<Map<AdsField, DirectAdsField>> directAdsFieldsFuture = this.getDirectAddresses(readRequest.getFields());
        if (directAdsFieldsFuture.isDone()) {
            Map resolvedFields = directAdsFieldsFuture.getNow(null);
            if (resolvedFields != null) {
                return this.executeRead(readRequest, resolvedFields);
            }
            CompletableFuture<PlcReadResponse> errorFuture = new CompletableFuture<PlcReadResponse>();
            errorFuture.completeExceptionally((Throwable)new PlcException("Fields are null"));
            return errorFuture;
        }
        CompletableFuture<PlcReadResponse> delayedRead = new CompletableFuture<PlcReadResponse>();
        directAdsFieldsFuture.handle((directAdsFields, throwable) -> {
            if (directAdsFields != null) {
                CompletableFuture<PlcReadResponse> delayedResponse = this.executeRead(readRequest, (Map<AdsField, DirectAdsField>)directAdsFields);
                delayedResponse.handle((plcReadResponse, throwable1) -> {
                    if (plcReadResponse != null) {
                        delayedRead.complete((PlcReadResponse)plcReadResponse);
                    } else {
                        delayedRead.completeExceptionally((Throwable)throwable1);
                    }
                    return this;
                });
            } else {
                delayedRead.completeExceptionally((Throwable)throwable);
            }
            return this;
        });
        return delayedRead;
    }

    protected CompletableFuture<PlcReadResponse> executeRead(PlcReadRequest readRequest, Map<AdsField, DirectAdsField> resolvedFields) {
        if (resolvedFields.size() == 1) {
            return this.singleRead(readRequest, resolvedFields.values().stream().findFirst().get());
        }
        return this.multiRead(readRequest, resolvedFields);
    }

    protected CompletableFuture<PlcReadResponse> singleRead(PlcReadRequest readRequest, DirectAdsField directAdsField) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        String dataTypeName = directAdsField.getPlcDataType();
        AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
        long size = adsDataTypeTableEntry.getSize();
        AdsReadRequest amsPacket = new AdsReadRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), directAdsField.getIndexGroup(), directAdsField.getIndexOffset(), size * (long)directAdsField.getNumberOfElements());
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(amsResponsePacket -> (AdsReadResponse)amsResponsePacket.getUserdata()).handle(response -> {
            if (response.getResult() == ReturnCode.OK) {
                PlcReadResponse plcReadResponse = this.convertToPlc4xReadResponse(readRequest, (AmsPacket)response);
                future.complete(plcReadResponse);
            } else {
                future.completeExceptionally((Throwable)new PlcException("Result is " + (Object)((Object)response.getResult())));
            }
            transaction.endRequest();
        }));
        return future;
    }

    protected CompletableFuture<PlcReadResponse> multiRead(PlcReadRequest readRequest, Map<AdsField, DirectAdsField> resolvedFields) {
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        long expectedResponseDataSize = resolvedFields.values().stream().mapToLong(field -> {
            String dataTypeName = field.getPlcDataType();
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            long size = adsDataTypeTableEntry.getSize();
            return 4L + size * (long)field.getNumberOfElements();
        }).sum();
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_MULTIPLE_READ.getValue(), resolvedFields.size(), expectedResponseDataSize, readRequest.getFieldNames().stream().map(fieldName -> {
            AdsField field = (AdsField)readRequest.getField(fieldName);
            DirectAdsField directAdsField = (DirectAdsField)resolvedFields.get(field);
            String dataTypeName = directAdsField.getPlcDataType();
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            long size = adsDataTypeTableEntry.getSize();
            return new AdsMultiRequestItemRead(directAdsField.getIndexGroup(), directAdsField.getIndexOffset(), size * (long)directAdsField.getNumberOfElements());
        }).collect(Collectors.toList()), null);
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(amsResponsePacket -> (AdsReadWriteResponse)amsResponsePacket.getUserdata()).handle(response -> {
            if (response.getResult() == ReturnCode.OK) {
                PlcReadResponse plcReadResponse = this.convertToPlc4xReadResponse(readRequest, (AmsPacket)response);
                future.complete(plcReadResponse);
            } else if (response.getResult() == ReturnCode.ADSERR_DEVICE_INVALIDSIZE) {
                future.completeExceptionally((Throwable)new PlcException("The parameter size was not correct (Internal error)"));
            } else {
                future.completeExceptionally((Throwable)new PlcException("Unexpected result " + (Object)((Object)response.getResult())));
            }
            transaction.endRequest();
        }));
        return future;
    }

    protected PlcReadResponse convertToPlc4xReadResponse(PlcReadRequest readRequest, AmsPacket adsData) {
        ReadBufferByteBased readBuffer = null;
        HashMap<String, PlcResponseCode> responseCodes = new HashMap<String, PlcResponseCode>();
        if (adsData instanceof AdsReadResponse) {
            AdsReadResponse adsReadResponse = (AdsReadResponse)adsData;
            readBuffer = new ReadBufferByteBased(adsReadResponse.getData(), ByteOrder.LITTLE_ENDIAN);
            responseCodes.put(readRequest.getFieldNames().stream().findFirst().orElse(""), this.parsePlcResponseCode(adsReadResponse.getResult()));
        } else if (adsData instanceof AdsReadWriteResponse) {
            AdsReadWriteResponse adsReadWriteResponse = (AdsReadWriteResponse)adsData;
            readBuffer = new ReadBufferByteBased(adsReadWriteResponse.getData(), ByteOrder.LITTLE_ENDIAN);
            for (String fieldName : readRequest.getFieldNames()) {
                try {
                    ReturnCode result = ReturnCode.enumForValue(readBuffer.readUnsignedLong(32));
                    responseCodes.put(fieldName, this.parsePlcResponseCode(result));
                }
                catch (ParseException e) {
                    responseCodes.put(fieldName, PlcResponseCode.INTERNAL_ERROR);
                }
            }
        }
        if (readBuffer != null) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (String fieldName : readRequest.getFieldNames()) {
                DirectAdsField field;
                if (readRequest.getField(fieldName) instanceof DirectAdsField) {
                    field = (DirectAdsField)readRequest.getField(fieldName);
                } else {
                    SymbolicAdsField symbolicAdsField = (SymbolicAdsField)readRequest.getField(fieldName);
                    field = this.getDirectAdsFieldForSymbolicName(symbolicAdsField);
                }
                if (responseCodes.get(fieldName) != PlcResponseCode.OK) {
                    values.put(fieldName, new ResponseItem((PlcResponseCode)responseCodes.get(fieldName), null));
                    continue;
                }
                values.put(fieldName, this.parseResponseItem(field, (ReadBuffer)readBuffer));
            }
            return new DefaultPlcReadResponse(readRequest, values);
        }
        return null;
    }

    private PlcResponseCode parsePlcResponseCode(ReturnCode adsResult) {
        if (adsResult == ReturnCode.OK) {
            return PlcResponseCode.OK;
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private ResponseItem<PlcValue> parseResponseItem(DirectAdsField field, ReadBuffer readBuffer) {
        try {
            String dataTypeName = field.getPlcDataType();
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType = this.getPlcValueTypeForAdsDataType(adsDataTypeTableEntry);
            int strLen = 0;
            if (plcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.STRING || plcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.WSTRING) {
                strLen = Integer.parseInt(dataTypeName.substring(dataTypeName.indexOf("(") + 1, dataTypeName.indexOf(")")));
            }
            int stringLength = strLen;
            if (field.getNumberOfElements() == 1) {
                return new ResponseItem(PlcResponseCode.OK, (Object)this.parsePlcValue(plcValueType, adsDataTypeTableEntry, stringLength, readBuffer));
            }
            Object[] resultItems = (PlcValue[])IntStream.range(0, field.getNumberOfElements()).mapToObj(i -> {
                try {
                    return this.parsePlcValue(plcValueType, adsDataTypeTableEntry, stringLength, readBuffer);
                }
                catch (ParseException e) {
                    LOGGER.warn("Error parsing field item of type: '{}' (at position {}})", new Object[]{field.getPlcDataType(), i, e});
                    return null;
                }
            }).toArray(PlcValue[]::new);
            return new ResponseItem(PlcResponseCode.OK, (Object)IEC61131ValueHandler.of((Object[])resultItems));
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error parsing field item of type: '%s'", field.getPlcDataType()), (Throwable)e);
            return new ResponseItem(PlcResponseCode.INTERNAL_ERROR, null);
        }
    }

    private PlcValue parsePlcValue(org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType, AdsDataTypeTableEntry adsDataTypeTableEntry, int stringLength, ReadBuffer readBuffer) throws ParseException {
        switch (plcValueType) {
            case Struct: {
                HashMap<String, PlcValue> properties = new HashMap<String, PlcValue>();
                int startPos = readBuffer.getPos();
                int curPos = 0;
                for (AdsDataTypeTableChildEntry child : adsDataTypeTableEntry.getChildren()) {
                    if (child.getOffset() > (long)curPos) {
                        long skipBytes = child.getOffset() - (long)curPos;
                        for (long i = 0L; i < skipBytes; ++i) {
                            readBuffer.readByte();
                        }
                    }
                    String propertyName = child.getPropertyName();
                    AdsDataTypeTableEntry propertyDataTypeTableEntry = this.dataTypeTable.get(child.getDataTypeName());
                    org.apache.plc4x.java.ads.readwrite.PlcValueType propertyPlcValueType = this.getPlcValueTypeForAdsDataType(propertyDataTypeTableEntry);
                    int strLen = 0;
                    if (propertyPlcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.STRING || propertyPlcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.WSTRING) {
                        String dataTypeName = propertyDataTypeTableEntry.getDataTypeName();
                        strLen = Integer.parseInt(dataTypeName.substring(dataTypeName.indexOf("(") + 1, dataTypeName.indexOf(")")));
                    }
                    PlcValue propertyValue = this.parsePlcValue(propertyPlcValueType, propertyDataTypeTableEntry, strLen, readBuffer);
                    properties.put(propertyName, propertyValue);
                    curPos = readBuffer.getPos() - startPos;
                }
                return new PlcStruct(properties);
            }
            case List: {
                return this.parseArrayLevel(adsDataTypeTableEntry, adsDataTypeTableEntry.getArrayInfo(), readBuffer);
            }
        }
        return DataItem.staticParse(readBuffer, plcValueType, stringLength);
    }

    private PlcValue parseArrayLevel(AdsDataTypeTableEntry adsDataTypeTableEntry, List<AdsDataTypeArrayInfo> arrayLayers, ReadBuffer readBuffer) throws ParseException {
        if (arrayLayers.isEmpty()) {
            String dataTypeName = adsDataTypeTableEntry.getDataTypeName();
            dataTypeName = dataTypeName.substring(dataTypeName.lastIndexOf(" OF ") + 4);
            int stringLength = 0;
            if (dataTypeName.startsWith("STRING(")) {
                stringLength = Integer.parseInt(dataTypeName.substring(7, dataTypeName.length() - 1));
            } else if (dataTypeName.startsWith("WSTRING(")) {
                stringLength = Integer.parseInt(dataTypeName.substring(8, dataTypeName.length() - 1));
            }
            AdsDataTypeTableEntry elementDataTypeTableEntry = this.dataTypeTable.get(dataTypeName);
            org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType = this.getPlcValueTypeForAdsDataType(elementDataTypeTableEntry);
            return this.parsePlcValue(plcValueType, elementDataTypeTableEntry, stringLength, readBuffer);
        }
        ArrayList<PlcValue> elements = new ArrayList<PlcValue>();
        List<AdsDataTypeArrayInfo> arrayInfo = adsDataTypeTableEntry.getArrayInfo();
        AdsDataTypeArrayInfo firstLayer = arrayInfo.get(0);
        int i = 0;
        while ((long)i < firstLayer.getNumElements()) {
            List<AdsDataTypeArrayInfo> remainingLayers = arrayInfo.subList(1, arrayInfo.size());
            elements.add(this.parseArrayLevel(adsDataTypeTableEntry, remainingLayers, readBuffer));
            ++i;
        }
        return new PlcList(elements);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<Map<AdsField, DirectAdsField>> directAdsFieldsFuture = this.getDirectAddresses(writeRequest.getFields());
        if (directAdsFieldsFuture.isDone()) {
            Map resolvedFields = directAdsFieldsFuture.getNow(null);
            if (resolvedFields != null) {
                return this.executeWrite(writeRequest, resolvedFields);
            }
            CompletableFuture<PlcWriteResponse> errorFuture = new CompletableFuture<PlcWriteResponse>();
            errorFuture.completeExceptionally((Throwable)new PlcException("Fields are null"));
            return errorFuture;
        }
        CompletableFuture<PlcWriteResponse> delayedWrite = new CompletableFuture<PlcWriteResponse>();
        directAdsFieldsFuture.handle((directAdsFields, throwable) -> {
            if (directAdsFields != null) {
                CompletableFuture<PlcWriteResponse> delayedResponse = this.executeWrite(writeRequest, (Map<AdsField, DirectAdsField>)directAdsFields);
                delayedResponse.handle((plcReadResponse, throwable1) -> {
                    if (plcReadResponse != null) {
                        delayedWrite.complete((PlcWriteResponse)plcReadResponse);
                    } else {
                        delayedWrite.completeExceptionally((Throwable)throwable1);
                    }
                    return this;
                });
            } else {
                delayedWrite.completeExceptionally((Throwable)throwable);
            }
            return this;
        });
        return delayedWrite;
    }

    protected CompletableFuture<PlcWriteResponse> executeWrite(PlcWriteRequest writeRequest, Map<AdsField, DirectAdsField> resolvedFields) {
        if (resolvedFields.size() == 1) {
            return this.singleWrite(writeRequest, resolvedFields.values().stream().findFirst().get());
        }
        return this.multiWrite(writeRequest, resolvedFields);
    }

    protected CompletableFuture<PlcWriteResponse> singleWrite(PlcWriteRequest writeRequest, DirectAdsField directAdsField) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        String fieldName = (String)writeRequest.getFieldNames().iterator().next();
        PlcValue plcValue = writeRequest.getPlcValue(fieldName);
        try {
            byte[] serializedValue = this.serializePlcValue(plcValue, directAdsField.getPlcDataType());
            AdsWriteRequest amsPacket = new AdsWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), directAdsField.getIndexGroup(), directAdsField.getIndexOffset(), serializedValue);
            AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> this.context.sendRequest((Object)amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(amsResponsePacket -> (AdsWriteResponse)amsResponsePacket.getUserdata()).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    PlcWriteResponse plcWriteResponse = this.convertToPlc4xWriteResponse(writeRequest, (AmsPacket)response);
                    future.complete(plcWriteResponse);
                } else {
                    future.completeExceptionally((Throwable)new PlcException("Unexpected return code " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
            }));
        }
        catch (Exception e) {
            future.completeExceptionally((Throwable)new PlcException("Error", (Throwable)e));
        }
        return future;
    }

    protected CompletableFuture<PlcWriteResponse> multiWrite(PlcWriteRequest writeRequest, Map<AdsField, DirectAdsField> resolvedFields) {
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        int numFields = writeRequest.getFields().size();
        ArrayList<byte[]> serializedFields = new ArrayList<byte[]>(numFields);
        LinkedHashMap<DirectAdsField, AdsDataTypeTableEntry> directAdsFields = new LinkedHashMap<DirectAdsField, AdsDataTypeTableEntry>(numFields);
        for (String fieldName : writeRequest.getFieldNames()) {
            AdsField field = (AdsField)writeRequest.getField(fieldName);
            DirectAdsField directAdsField = resolvedFields.get(field);
            PlcValue plcValue = writeRequest.getPlcValue(fieldName);
            AdsDataTypeTableEntry dataType = this.dataTypeTable.get(directAdsField.getPlcDataType());
            try {
                byte[] serializedValue = this.serializePlcValue(plcValue, directAdsField.getPlcDataType());
                serializedFields.add(serializedValue);
                directAdsFields.put(directAdsField, dataType);
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)new PlcException("Error serializing data", (Throwable)e));
                return future;
            }
        }
        int serializedSize = serializedFields.stream().mapToInt(serializedField -> ((byte[])serializedField).length).sum();
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased(serializedSize);
        for (byte[] serializedField2 : serializedFields) {
            try {
                writeBuffer.writeByteArray("", serializedField2, new WithWriterArgs[0]);
            }
            catch (SerializationException e) {
                future.completeExceptionally((Throwable)new PlcException("Error serializing data", (Throwable)e));
                return future;
            }
        }
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_MULTIPLE_WRITE.getValue(), serializedSize, (long)numFields * 4L, directAdsFields.entrySet().stream().map(entry -> new AdsMultiRequestItemWrite(((DirectAdsField)entry.getKey()).getIndexGroup(), ((DirectAdsField)entry.getKey()).getIndexOffset(), ((AdsDataTypeTableEntry)entry.getValue()).getEntryLength())).collect(Collectors.toList()), writeBuffer.getBytes());
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(responseAmsPacket -> (AdsReadWriteResponse)responseAmsPacket.getUserdata()).handle(response -> {
            if (response.getResult() == ReturnCode.OK) {
                PlcWriteResponse plcWriteResponse = this.convertToPlc4xWriteResponse(writeRequest, (AmsPacket)response);
                future.complete(plcWriteResponse);
            } else {
                future.completeExceptionally((Throwable)new PlcException("Error"));
            }
            transaction.endRequest();
        }));
        return future;
    }

    protected byte[] serializePlcValue(PlcValue plcValue, String datatypeName) throws SerializationException {
        if (!this.dataTypeTable.containsKey(datatypeName)) {
            throw new SerializationException("Could not find data type: " + datatypeName);
        }
        AdsDataTypeTableEntry dataType = this.dataTypeTable.get(datatypeName);
        WriteBufferByteBased writeBuffer = new WriteBufferByteBased((int)dataType.getSize());
        List<AdsDataTypeArrayInfo> arrayInfo = dataType.getArrayInfo();
        this.serializeInternal(plcValue, dataType, arrayInfo, writeBuffer);
        return writeBuffer.getBytes();
    }

    protected void serializeInternal(PlcValue contextValue, AdsDataTypeTableEntry dataType, List<AdsDataTypeArrayInfo> arrayInfo, WriteBufferByteBased writeBuffer) throws SerializationException {
        if (arrayInfo.size() > 0) {
            if (!contextValue.isList()) {
                throw new SerializationException("Expected a PlcList, but got a " + contextValue.getPlcValueType().name());
            }
            AdsDataTypeArrayInfo curArrayLevel = arrayInfo.get(0);
            List list = contextValue.getList();
            if (curArrayLevel.getNumElements() != (long)list.size()) {
                throw new SerializationException(String.format("Expected a PlcList of size %d, but got one of size %d", curArrayLevel.getNumElements(), list.size()));
            }
            for (PlcValue plcValue : list) {
                this.serializeInternal(plcValue, dataType, arrayInfo.subList(1, arrayInfo.size()), writeBuffer);
            }
        } else if (dataType.getChildren().size() > 0) {
            if (!contextValue.isStruct()) {
                throw new SerializationException("Expected a PlcStruct, but got a " + contextValue.getPlcValueType().name());
            }
            PlcStruct plcStruct = (PlcStruct)contextValue;
            for (AdsDataTypeTableChildEntry child : dataType.getChildren()) {
                AdsDataTypeTableEntry childDataType = this.dataTypeTable.get(child.getDataTypeName());
                if (!plcStruct.hasKey(child.getPropertyName())) {
                    throw new SerializationException("PlcStruct is missing a child with the name " + child.getPropertyName());
                }
                PlcValue childValue = plcStruct.getValue(child.getPropertyName());
                this.serializeInternal(childValue, childDataType, childDataType.getArrayInfo(), writeBuffer);
            }
        } else {
            org.apache.plc4x.java.ads.readwrite.PlcValueType plcValueType = this.getPlcValueTypeForAdsDataType(dataType);
            if (plcValueType == null) {
                throw new SerializationException("Unsupported simple type: " + dataType.getDataTypeName());
            }
            int stringLength = 0;
            if (plcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.STRING || plcValueType == org.apache.plc4x.java.ads.readwrite.PlcValueType.WSTRING) {
                String stringTypeName = dataType.getDataTypeName();
                stringLength = Integer.parseInt(stringTypeName.substring(stringTypeName.indexOf("(") + 1, stringTypeName.indexOf(")")));
            }
            DataItem.staticSerialize((WriteBuffer)writeBuffer, contextValue, plcValueType, stringLength);
        }
    }

    protected PlcWriteResponse convertToPlc4xWriteResponse(PlcWriteRequest writeRequest, AmsPacket adsData) {
        HashMap<String, PlcResponseCode> responseCodes = new HashMap<String, PlcResponseCode>();
        if (adsData instanceof AdsWriteResponse) {
            AdsWriteResponse adsWriteResponse = (AdsWriteResponse)adsData;
            responseCodes.put(writeRequest.getFieldNames().stream().findFirst().orElse(""), this.parsePlcResponseCode(adsWriteResponse.getResult()));
        } else if (adsData instanceof AdsReadWriteResponse) {
            AdsReadWriteResponse adsReadWriteResponse = (AdsReadWriteResponse)adsData;
            ReadBufferByteBased readBuffer = new ReadBufferByteBased(adsReadWriteResponse.getData(), ByteOrder.LITTLE_ENDIAN);
            for (String fieldName : writeRequest.getFieldNames()) {
                try {
                    ReturnCode result = ReturnCode.enumForValue(readBuffer.readUnsignedLong(32));
                    responseCodes.put(fieldName, this.parsePlcResponseCode(result));
                }
                catch (ParseException e) {
                    responseCodes.put(fieldName, PlcResponseCode.INTERNAL_ERROR);
                }
            }
        }
        return new DefaultPlcWriteResponse(writeRequest, responseCodes);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        CompletableFuture<Map<AdsField, DirectAdsField>> directAdsFieldsFuture = this.getDirectAddresses(subscriptionRequest.getFields().stream().map(field -> ((DefaultPlcSubscriptionField)field).getPlcField()).collect(Collectors.toList()));
        if (directAdsFieldsFuture.isDone()) {
            Map resolvedFields = directAdsFieldsFuture.getNow(null);
            if (resolvedFields != null) {
                return this.executeSubscribe(subscriptionRequest, resolvedFields);
            }
            CompletableFuture<PlcSubscriptionResponse> errorFuture = new CompletableFuture<PlcSubscriptionResponse>();
            errorFuture.completeExceptionally((Throwable)new PlcException("Fields are null"));
            return errorFuture;
        }
        CompletableFuture<PlcSubscriptionResponse> delayedSubscribe = new CompletableFuture<PlcSubscriptionResponse>();
        directAdsFieldsFuture.handle((fieldMapping, throwable) -> {
            if (fieldMapping != null) {
                CompletableFuture<PlcSubscriptionResponse> delayedResponse = this.executeSubscribe(subscriptionRequest, (Map<AdsField, DirectAdsField>)fieldMapping);
                delayedResponse.handle((plcSubscribeResponse, throwable1) -> {
                    if (plcSubscribeResponse != null) {
                        delayedSubscribe.complete((PlcSubscriptionResponse)plcSubscribeResponse);
                    } else {
                        delayedSubscribe.completeExceptionally((Throwable)throwable1);
                    }
                    return this;
                });
            } else {
                delayedSubscribe.completeExceptionally((Throwable)throwable);
            }
            return this;
        });
        return delayedSubscribe;
    }

    private CompletableFuture<PlcSubscriptionResponse> executeSubscribe(PlcSubscriptionRequest subscribeRequest, Map<AdsField, DirectAdsField> resolvedFields) {
        CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
        List amsTCPPackets = subscribeRequest.getFields().stream().map(field -> (DefaultPlcSubscriptionField)field).map(field -> {
            AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(((DirectAdsField)resolvedFields.get((AdsField)field.getPlcField())).getPlcDataType());
            DirectAdsField directAdsField = this.getDirectAdsFieldForSymbolicName(field.getPlcField());
            return new AmsTCPPacket(new AdsAddDeviceNotificationRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), directAdsField.getIndexGroup(), directAdsField.getIndexOffset(), adsDataTypeTableEntry.getSize() * (long)field.getNumberOfElements(), field.getPlcSubscriptionType() == PlcSubscriptionType.CYCLIC ? 3L : 4L, 0L, field.getDuration().orElse(Duration.ZERO).toMillis()));
        }).collect(Collectors.toList());
        HashMap<String, ResponseItem<PlcSubscriptionHandle>> responses = new HashMap<String, ResponseItem<PlcSubscriptionHandle>>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(this.subscribeRecursively(subscribeRequest, subscribeRequest.getFieldNames().iterator(), resolvedFields, responses, future, amsTCPPackets.iterator(), transaction));
        return future;
    }

    private Runnable subscribeRecursively(PlcSubscriptionRequest subscriptionRequest, Iterator<String> fieldNames, Map<AdsField, DirectAdsField> resolvedFields, Map<String, ResponseItem<PlcSubscriptionHandle>> responses, CompletableFuture<PlcSubscriptionResponse> future, Iterator<AmsTCPPacket> amsTCPPackets, RequestTransactionManager.RequestTransaction transaction) {
        return () -> {
            AmsTCPPacket packet = (AmsTCPPacket)amsTCPPackets.next();
            boolean hasMorePackets = amsTCPPackets.hasNext();
            String fieldName = (String)fieldNames.next();
            this.context.sendRequest((Object)packet).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == packet.getUserdata().getInvokeId()).unwrap(responseAmsPacket -> (AdsAddDeviceNotificationResponse)responseAmsPacket.getUserdata()).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    DefaultPlcSubscriptionField subscriptionField = (DefaultPlcSubscriptionField)subscriptionRequest.getField(fieldName);
                    AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(((DirectAdsField)resolvedFields.get((AdsField)subscriptionField.getPlcField())).getPlcDataType());
                    responses.put(fieldName, new ResponseItem(this.parsePlcResponseCode(response.getResult()), (Object)new AdsSubscriptionHandle(this, fieldName, adsDataTypeTableEntry, response.getNotificationHandle())));
                    if (!hasMorePackets) {
                        DefaultPlcSubscriptionResponse plcSubscriptionResponse = new DefaultPlcSubscriptionResponse(subscriptionRequest, responses);
                        future.complete((PlcSubscriptionResponse)plcSubscriptionResponse);
                    }
                } else if (response.getResult() == ReturnCode.ADSERR_DEVICE_INVALIDSIZE) {
                    future.completeExceptionally((Throwable)new PlcException("The parameter size was not correct (Internal error)"));
                } else {
                    future.completeExceptionally((Throwable)new PlcException("Unexpected result " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
                if (hasMorePackets) {
                    RequestTransactionManager.RequestTransaction nextTransaction = this.tm.startRequest();
                    nextTransaction.submit(this.subscribeRecursively(subscriptionRequest, fieldNames, resolvedFields, responses, future, amsTCPPackets, nextTransaction));
                }
            });
        };
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        CompletableFuture<PlcUnsubscriptionResponse> future = new CompletableFuture<PlcUnsubscriptionResponse>();
        ArrayList notificationHandles = new ArrayList();
        unsubscriptionRequest.getSubscriptionHandles().stream().filter(handle -> handle instanceof AdsSubscriptionHandle).map(handle -> (AdsSubscriptionHandle)((Object)handle)).forEach(adsSubscriptionHandle -> {
            notificationHandles.add(adsSubscriptionHandle.getNotificationHandle());
            this.consumers.keySet().stream().filter(consumerRegistration -> consumerRegistration.getSubscriptionHandles().contains(adsSubscriptionHandle)).forEach(DefaultPlcConsumerRegistration::unregister);
        });
        List amsTCPPackets = notificationHandles.stream().map(data -> new AmsTCPPacket(new AdsDeleteDeviceNotificationRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), (long)data))).collect(Collectors.toList());
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(this.unsubscribeRecursively(unsubscriptionRequest, future, amsTCPPackets.iterator(), transaction));
        return future;
    }

    private Runnable unsubscribeRecursively(PlcUnsubscriptionRequest unsubscriptionRequest, CompletableFuture<PlcUnsubscriptionResponse> future, Iterator<AmsTCPPacket> amsTCPPackets, RequestTransactionManager.RequestTransaction transaction) {
        return () -> {
            AmsTCPPacket packet = (AmsTCPPacket)amsTCPPackets.next();
            boolean hasMorePackets = amsTCPPackets.hasNext();
            this.context.sendRequest((Object)packet).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == packet.getUserdata().getInvokeId()).unwrap(responseAmsPacket -> (AdsDeleteDeviceNotificationResponse)responseAmsPacket.getUserdata()).handle(response -> {
                if (response.getResult() == ReturnCode.OK) {
                    if (!hasMorePackets) {
                        DefaultPlcUnsubscriptionResponse plcUnsubscriptionResponse = new DefaultPlcUnsubscriptionResponse(unsubscriptionRequest);
                        future.complete((PlcUnsubscriptionResponse)plcUnsubscriptionResponse);
                    }
                } else if (response.getResult() == ReturnCode.ADSERR_DEVICE_NOTIFYHNDINVALID) {
                    future.completeExceptionally((Throwable)new PlcException("The notification handle is invalid (Internal error)"));
                } else {
                    future.completeExceptionally((Throwable)new PlcException("Unexpected result " + (Object)((Object)response.getResult())));
                }
                transaction.endRequest();
                if (hasMorePackets) {
                    RequestTransactionManager.RequestTransaction nextTransaction = this.tm.startRequest();
                    nextTransaction.submit(this.unsubscribeRecursively(unsubscriptionRequest, future, amsTCPPackets, nextTransaction));
                }
            });
        };
    }

    protected void decode(ConversationContext<AmsTCPPacket> context, AmsTCPPacket msg) throws Exception {
        if (msg.getUserdata() instanceof AdsDeviceNotificationRequest) {
            AdsDeviceNotificationRequest notificationData = (AdsDeviceNotificationRequest)msg.getUserdata();
            List<AdsStampHeader> stamps = notificationData.getAdsStampHeaders();
            for (AdsStampHeader stamp : stamps) {
                long unixEpochTimestamp = stamp.getTimestamp().divide(BigInteger.valueOf(10000L)).longValue() - 11644473600000L;
                List<AdsNotificationSample> samples = stamp.getAdsNotificationSamples();
                for (AdsNotificationSample sample : samples) {
                    long handle = sample.getNotificationHandle();
                    for (DefaultPlcConsumerRegistration registration : this.consumers.keySet()) {
                        for (PlcSubscriptionHandle subscriptionHandle : registration.getSubscriptionHandles()) {
                            AdsSubscriptionHandle adsHandle;
                            if (!(subscriptionHandle instanceof AdsSubscriptionHandle) || (adsHandle = (AdsSubscriptionHandle)subscriptionHandle).getNotificationHandle() != handle) continue;
                            this.consumers.get(registration).accept((PlcSubscriptionEvent)new DefaultPlcSubscriptionEvent(Instant.ofEpochMilli(unixEpochTimestamp), this.convertSampleToPlc4XResult(adsHandle, sample.getData())));
                        }
                    }
                }
            }
        }
    }

    private Map<String, ResponseItem<PlcValue>> convertSampleToPlc4XResult(AdsSubscriptionHandle subscriptionHandle, byte[] data) throws ParseException {
        HashMap<String, ResponseItem<PlcValue>> values = new HashMap<String, ResponseItem<PlcValue>>();
        ReadBufferByteBased readBuffer = new ReadBufferByteBased(data, ByteOrder.LITTLE_ENDIAN);
        values.put(subscriptionHandle.getPlcFieldName(), new ResponseItem(PlcResponseCode.OK, (Object)DataItem.staticParse((ReadBuffer)readBuffer, this.getPlcValueTypeForAdsDataType(subscriptionHandle.getAdsDataType()), data.length)));
        return values;
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration registration) {
        DefaultPlcConsumerRegistration consumerRegistration = (DefaultPlcConsumerRegistration)registration;
        this.consumers.remove(consumerRegistration);
    }

    protected CompletableFuture<Map<AdsField, DirectAdsField>> getDirectAddresses(List<PlcField> fields) {
        CompletableFuture<Map<AdsField, DirectAdsField>> future = new CompletableFuture<Map<AdsField, DirectAdsField>>();
        List referencedSymbolicFields = fields.stream().filter(SymbolicAdsField.class::isInstance).map(SymbolicAdsField.class::cast).collect(Collectors.toList());
        List symbolicFieldsNeedingResolution = referencedSymbolicFields.stream().filter(symbolicAdsField -> this.getDirectAdsFieldForSymbolicName((PlcField)symbolicAdsField) == null).collect(Collectors.toList());
        if (!symbolicFieldsNeedingResolution.isEmpty()) {
            List<SymbolicAdsField> requiredResolutionFields = symbolicFieldsNeedingResolution.stream().filter(symbolicAdsField -> !this.pendingResolutionRequests.containsKey(symbolicAdsField)).collect(Collectors.toList());
            if (!requiredResolutionFields.isEmpty()) {
                CompletableFuture<Void> resolutionFuture;
                if (requiredResolutionFields.size() == 1) {
                    SymbolicAdsField symbolicAdsField2 = (SymbolicAdsField)requiredResolutionFields.get(0);
                    resolutionFuture = this.resolveSingleSymbolicAddress(requiredResolutionFields.get(0));
                    this.pendingResolutionRequests.put(symbolicAdsField2, resolutionFuture);
                } else {
                    resolutionFuture = this.resolveMultipleSymbolicAddresses(requiredResolutionFields);
                    for (SymbolicAdsField symbolicAdsField3 : requiredResolutionFields) {
                        this.pendingResolutionRequests.put(symbolicAdsField3, resolutionFuture);
                    }
                }
            }
            CompletableFuture<Void> resolutionComplete = CompletableFuture.allOf((CompletableFuture[])symbolicFieldsNeedingResolution.stream().map(this.pendingResolutionRequests::get).toArray(CompletableFuture[]::new));
            resolutionComplete.handleAsync((unused, throwable) -> {
                if (throwable != null) {
                    return future.completeExceptionally(throwable.getCause());
                }
                HashMap<AdsField, DirectAdsField> directAdsFieldMapping = new HashMap<AdsField, DirectAdsField>(fields.size());
                for (PlcField field : fields) {
                    if (field instanceof SymbolicAdsField) {
                        directAdsFieldMapping.put((AdsField)field, this.getDirectAdsFieldForSymbolicName(field));
                        continue;
                    }
                    directAdsFieldMapping.put((AdsField)field, (DirectAdsField)field);
                }
                return future.complete(directAdsFieldMapping);
            });
        } else {
            HashMap<AdsField, DirectAdsField> directAdsFieldMapping = new HashMap<AdsField, DirectAdsField>(fields.size());
            for (PlcField field : fields) {
                if (field instanceof SymbolicAdsField) {
                    directAdsFieldMapping.put((AdsField)field, this.getDirectAdsFieldForSymbolicName(field));
                    continue;
                }
                directAdsFieldMapping.put((AdsField)field, (DirectAdsField)field);
            }
            future.complete(directAdsFieldMapping);
        }
        return future;
    }

    protected CompletableFuture<Void> resolveSingleSymbolicAddress(SymbolicAdsField symbolicAdsField) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_SYM_HNDBYNAME.getValue(), 0L, 4L, null, this.getNullByteTerminatedArray(symbolicAdsField.getSymbolicAddress()));
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(AmsTCPPacket::getUserdata).check(AdsReadWriteResponse.class::isInstance).unwrap(AdsReadWriteResponse.class::cast).handle(response -> {
            if (response.getResult() != ReturnCode.OK) {
                future.completeExceptionally((Throwable)new PlcException("Couldn't retrieve handle for symbolic field " + symbolicAdsField.getSymbolicAddress() + " got return code " + response.getResult().name()));
            } else {
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(response.getData(), ByteOrder.LITTLE_ENDIAN);
                try {
                    long handle = readBuffer.readUnsignedLong(32);
                    future.complete(null);
                }
                catch (ParseException e) {
                    future.completeExceptionally(e);
                }
            }
            transaction.endRequest();
        }));
        return future;
    }

    protected CompletableFuture<Void> resolveMultipleSymbolicAddresses(List<SymbolicAdsField> symbolicAdsFields) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        long expectedResponseDataSize = (long)symbolicAdsFields.size() * 12L;
        byte[] addressData = symbolicAdsFields.stream().map(SymbolicAdsField::getSymbolicAddress).collect(Collectors.joining("")).getBytes();
        AdsReadWriteRequest amsPacket = new AdsReadWriteRequest(this.configuration.getTargetAmsNetId(), this.configuration.getTargetAmsPort(), this.configuration.getSourceAmsNetId(), this.configuration.getSourceAmsPort(), 0L, this.getInvokeId(), ReservedIndexGroups.ADSIGRP_MULTIPLE_READ_WRITE.getValue(), symbolicAdsFields.size(), expectedResponseDataSize, symbolicAdsFields.stream().map(symbolicAdsField -> new AdsMultiRequestItemReadWrite(ReservedIndexGroups.ADSIGRP_SYM_HNDBYNAME.getValue(), 0L, 4L, symbolicAdsField.getSymbolicAddress().length())).collect(Collectors.toList()), null);
        AmsTCPPacket amsTCPPacket = new AmsTCPPacket(amsPacket);
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.context.sendRequest((Object)amsTCPPacket).expectResponse(AmsTCPPacket.class, Duration.ofMillis(this.configuration.getTimeoutRequest())).onTimeout(future::completeExceptionally).onError((p, e) -> future.completeExceptionally((Throwable)e)).check(responseAmsPacket -> responseAmsPacket.getUserdata().getInvokeId() == amsPacket.getInvokeId()).unwrap(AmsTCPPacket::getUserdata).check(AdsReadWriteResponse.class::isInstance).unwrap(AdsReadWriteResponse.class::cast).handle(response -> {
            ReadBufferByteBased readBuffer = new ReadBufferByteBased(response.getData(), ByteOrder.LITTLE_ENDIAN);
            HashMap returnCodes = new HashMap();
            symbolicAdsFields.forEach(arg_0 -> AdsProtocolLogic.lambda$resolveMultipleSymbolicAddresses$99((ReadBuffer)readBuffer, returnCodes, arg_0));
            symbolicAdsFields.forEach(arg_0 -> AdsProtocolLogic.lambda$resolveMultipleSymbolicAddresses$100(returnCodes, (ReadBuffer)readBuffer, arg_0));
            future.complete(null);
            transaction.endRequest();
        }));
        return future;
    }

    protected long getInvokeId() {
        long invokeId = this.invokeIdGenerator.getAndIncrement();
        if (this.invokeIdGenerator.get() == -1L) {
            this.invokeIdGenerator.set(1L);
        }
        return invokeId;
    }

    protected DirectAdsField getDirectAdsFieldForSymbolicName(PlcField field) {
        if (field instanceof DirectAdsField) {
            return (DirectAdsField)field;
        }
        SymbolicAdsField symbolicAdsField = (SymbolicAdsField)field;
        String symbolicAddress = symbolicAdsField.getSymbolicAddress();
        String[] addressParts = symbolicAddress.split("\\.");
        if (addressParts.length < 2) {
            if (!this.symbolTable.containsKey(symbolicAddress)) {
                return null;
            }
            AdsSymbolTableEntry adsSymbolTableEntry = this.symbolTable.get(symbolicAddress);
            if (adsSymbolTableEntry == null) {
                throw new PlcInvalidFieldException("Couldn't resolve symbolic address: " + symbolicAddress);
            }
            AdsDataTypeTableEntry dataTypeTableEntry = this.dataTypeTable.get(adsSymbolTableEntry.getDataTypeName());
            if (dataTypeTableEntry == null) {
                throw new PlcInvalidFieldException("Couldn't resolve datatype: '" + adsSymbolTableEntry.getDataTypeName() + "' for address: '" + ((SymbolicAdsField)field).getSymbolicAddress() + "'");
            }
            return new DirectAdsField(adsSymbolTableEntry.getGroup(), adsSymbolTableEntry.getOffset(), dataTypeTableEntry.getDataTypeName(), dataTypeTableEntry.getArrayDimensions());
        }
        String symbolName = addressParts[0] + "." + addressParts[1];
        AdsSymbolTableEntry adsSymbolTableEntry = this.symbolTable.get(symbolName);
        if (adsSymbolTableEntry == null) {
            throw new PlcInvalidFieldException("Couldn't resolve symbolic address: " + symbolName);
        }
        AdsDataTypeTableEntry adsDataTypeTableEntry = this.dataTypeTable.get(adsSymbolTableEntry.getDataTypeName());
        if (adsDataTypeTableEntry == null) {
            throw new PlcInvalidFieldException("Couldn't resolve datatype: '" + adsSymbolTableEntry.getDataTypeName() + "' for address: '" + ((SymbolicAdsField)field).getSymbolicAddress() + "'");
        }
        return this.resolveDirectAdsFieldForSymbolicNameFromDataType(Arrays.asList(addressParts).subList(2, addressParts.length), adsSymbolTableEntry.getGroup(), adsSymbolTableEntry.getOffset(), adsDataTypeTableEntry);
    }

    protected DirectAdsField resolveDirectAdsFieldForSymbolicNameFromDataType(List<String> remainingAddressParts, long currentGroup, long currentOffset, AdsDataTypeTableEntry adsDataTypeTableEntry) {
        if (remainingAddressParts.isEmpty()) {
            return new DirectAdsField(currentGroup, currentOffset, adsDataTypeTableEntry.getDataTypeName(), 1);
        }
        for (AdsDataTypeTableChildEntry child : adsDataTypeTableEntry.getChildren()) {
            if (!child.getPropertyName().equals(remainingAddressParts.get(0))) continue;
            AdsDataTypeTableEntry childAdsDataTypeTableEntry = this.dataTypeTable.get(child.getDataTypeName());
            return this.resolveDirectAdsFieldForSymbolicNameFromDataType(remainingAddressParts.subList(1, remainingAddressParts.size()), currentGroup, currentOffset + child.getOffset(), childAdsDataTypeTableEntry);
        }
        throw new PlcRuntimeException(String.format("Couldn't find child with name '%s' for type '%s'", remainingAddressParts.get(0), adsDataTypeTableEntry.getDataTypeName()));
    }

    protected org.apache.plc4x.java.ads.readwrite.PlcValueType getPlcValueTypeForAdsDataType(AdsDataTypeTableEntry dataTypeTableEntry) {
        String dataTypeName = dataTypeTableEntry.getDataTypeName();
        if (dataTypeName.startsWith("STRING(")) {
            dataTypeName = "STRING";
        } else if (dataTypeName.startsWith("WSTRING(")) {
            dataTypeName = "WSTRING";
        }
        try {
            return org.apache.plc4x.java.ads.readwrite.PlcValueType.valueOf(dataTypeName);
        }
        catch (IllegalArgumentException e) {
            if (dataTypeTableEntry.getArrayDimensions() > 0) {
                return org.apache.plc4x.java.ads.readwrite.PlcValueType.List;
            }
            if (dataTypeTableEntry.getChildren().isEmpty()) {
                try {
                    dataTypeName = dataTypeTableEntry.getSimpleTypeName();
                    if (dataTypeName.startsWith("STRING(")) {
                        dataTypeName = "STRING";
                    } else if (dataTypeName.startsWith("WSTRING(")) {
                        dataTypeName = "WSTRING";
                    }
                    return org.apache.plc4x.java.ads.readwrite.PlcValueType.valueOf(dataTypeName);
                }
                catch (IllegalArgumentException e2) {
                    return org.apache.plc4x.java.ads.readwrite.PlcValueType.NULL;
                }
            }
            return org.apache.plc4x.java.ads.readwrite.PlcValueType.Struct;
        }
    }

    protected byte[] getNullByteTerminatedArray(String value) {
        byte[] valueBytes = value.getBytes();
        byte[] nullTerminatedBytes = new byte[valueBytes.length + 1];
        System.arraycopy(valueBytes, 0, nullTerminatedBytes, 0, valueBytes.length);
        return nullTerminatedBytes;
    }

    private static /* synthetic */ void lambda$resolveMultipleSymbolicAddresses$100(Map returnCodes, ReadBuffer readBuffer, SymbolicAdsField symbolicAdsField) {
        try {
            if ((Long)returnCodes.get(symbolicAdsField) == 0L) {
                long l = readBuffer.readUnsignedLong(32);
            }
        }
        catch (ParseException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$resolveMultipleSymbolicAddresses$99(ReadBuffer readBuffer, Map returnCodes, SymbolicAdsField symbolicAdsField) {
        try {
            long returnCode = readBuffer.readUnsignedLong(32);
            long itemLength = readBuffer.readUnsignedLong(32);
            assert (itemLength == 4L);
            returnCodes.put(symbolicAdsField, returnCode);
        }
        catch (ParseException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }
}

