/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.ads.readwrite.PlcValueType;

public enum AdsDataType {
    BOOL(1, 1, PlcValueType.BOOL),
    BIT(2, 1, PlcValueType.BOOL),
    BIT8(3, 1, PlcValueType.BYTE),
    BYTE(4, 1, PlcValueType.BYTE),
    BITARR8(5, 1, PlcValueType.BYTE),
    WORD(6, 2, PlcValueType.WORD),
    BITARR16(7, 2, PlcValueType.WORD),
    DWORD(8, 4, PlcValueType.DWORD),
    BITARR32(9, 4, PlcValueType.DWORD),
    SINT(10, 1, PlcValueType.SINT),
    INT8(11, 1, PlcValueType.SINT),
    USINT(12, 1, PlcValueType.USINT),
    UINT8(13, 1, PlcValueType.USINT),
    INT(14, 2, PlcValueType.INT),
    INT16(15, 2, PlcValueType.INT),
    UINT(16, 2, PlcValueType.UINT),
    UINT16(17, 2, PlcValueType.UINT),
    DINT(18, 4, PlcValueType.DINT),
    INT32(19, 4, PlcValueType.DINT),
    UDINT(20, 4, PlcValueType.UDINT),
    UINT32(21, 4, PlcValueType.UDINT),
    LINT(22, 8, PlcValueType.LINT),
    INT64(23, 8, PlcValueType.LINT),
    ULINT(24, 8, PlcValueType.ULINT),
    UINT64(25, 8, PlcValueType.ULINT),
    REAL(26, 4, PlcValueType.REAL),
    FLOAT(27, 4, PlcValueType.REAL),
    LREAL(28, 8, PlcValueType.LREAL),
    DOUBLE(29, 8, PlcValueType.LREAL),
    CHAR(30, 1, PlcValueType.CHAR),
    WCHAR(31, 2, PlcValueType.WCHAR),
    STRING(32, 256, PlcValueType.STRING),
    WSTRING(33, 512, PlcValueType.WSTRING),
    TIME(34, 4, PlcValueType.TIME),
    LTIME(35, 8, PlcValueType.LTIME),
    DATE(36, 4, PlcValueType.DATE),
    TIME_OF_DAY(37, 4, PlcValueType.TIME_OF_DAY),
    TOD(38, 4, PlcValueType.TIME_OF_DAY),
    DATE_AND_TIME(39, 4, PlcValueType.DATE_AND_TIME),
    DT(40, 4, PlcValueType.DATE_AND_TIME);

    private static final Map<Byte, AdsDataType> map;
    private byte value;
    private int numBytes;
    private PlcValueType plcValueType;

    private AdsDataType(byte value, int numBytes, PlcValueType plcValueType) {
        this.value = value;
        this.numBytes = numBytes;
        this.plcValueType = plcValueType;
    }

    public byte getValue() {
        return this.value;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public static AdsDataType firstEnumForFieldNumBytes(int fieldValue) {
        for (AdsDataType _val : AdsDataType.values()) {
            if (_val.getNumBytes() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<AdsDataType> enumsForFieldNumBytes(int fieldValue) {
        ArrayList<AdsDataType> _values = new ArrayList<AdsDataType>();
        for (AdsDataType _val : AdsDataType.values()) {
            if (_val.getNumBytes() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public PlcValueType getPlcValueType() {
        return this.plcValueType;
    }

    public static AdsDataType firstEnumForFieldPlcValueType(PlcValueType fieldValue) {
        for (AdsDataType _val : AdsDataType.values()) {
            if (_val.getPlcValueType() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<AdsDataType> enumsForFieldPlcValueType(PlcValueType fieldValue) {
        ArrayList<AdsDataType> _values = new ArrayList<AdsDataType>();
        for (AdsDataType _val : AdsDataType.values()) {
            if (_val.getPlcValueType() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static AdsDataType enumForValue(byte value) {
        return map.get(value);
    }

    public static Boolean isDefined(byte value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Byte, AdsDataType>();
        for (AdsDataType value : AdsDataType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

