/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.CommandId;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AdsWriteRequest
extends AmsPacket
implements Message {
    protected final long indexGroup;
    protected final long indexOffset;
    protected final byte[] data;

    @Override
    public CommandId getCommandId() {
        return CommandId.ADS_WRITE;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public AdsWriteRequest(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId, long indexGroup, long indexOffset, byte[] data) {
        super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
        this.indexGroup = indexGroup;
        this.indexOffset = indexOffset;
        this.data = data;
    }

    public long getIndexGroup() {
        return this.indexGroup;
    }

    public long getIndexOffset() {
        return this.indexOffset;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("AdsWriteRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"indexGroup", (Object)this.indexGroup, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"indexOffset", (Object)this.indexOffset, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        long length = StaticHelper.COUNT((Object)this.getData());
        FieldWriterFactory.writeImplicitField((String)"length", (Object)length, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AdsWriteRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsWriteRequest _value = this;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static AdsWriteRequestBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsWriteRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        long indexGroup = (Long)FieldReaderFactory.readSimpleField((String)"indexGroup", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long indexOffset = (Long)FieldReaderFactory.readSimpleField((String)"indexOffset", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long length = (Long)FieldReaderFactory.readImplicitField((String)"length", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(length), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsWriteRequest", new WithReaderArgs[0]);
        return new AdsWriteRequestBuilder(indexGroup, indexOffset, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsWriteRequest)) {
            return false;
        }
        AdsWriteRequest that = (AdsWriteRequest)o;
        return this.getIndexGroup() == that.getIndexGroup() && this.getIndexOffset() == that.getIndexOffset() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getIndexGroup(), this.getIndexOffset(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsWriteRequestBuilder
    implements AmsPacket.AmsPacketBuilder {
        private final long indexGroup;
        private final long indexOffset;
        private final byte[] data;

        public AdsWriteRequestBuilder(long indexGroup, long indexOffset, byte[] data) {
            this.indexGroup = indexGroup;
            this.indexOffset = indexOffset;
            this.data = data;
        }

        @Override
        public AdsWriteRequest build(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId) {
            AdsWriteRequest adsWriteRequest = new AdsWriteRequest(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId, this.indexGroup, this.indexOffset, this.data);
            return adsWriteRequest;
        }
    }
}

