/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.generic.field;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.genericcan.readwrite.GenericCANDataType;

public class GenericCANField
implements PlcField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<nodeId>\\d+):(?<dataType>\\w+)(?:\\[(?<arraySize>\\d+)\\])?");
    private final int nodeId;
    private final GenericCANDataType dataType;
    private final int arraySize;

    public GenericCANField(int nodeId, GenericCANDataType dataType, int arraySize) {
        this.nodeId = nodeId;
        this.dataType = dataType;
        this.arraySize = arraySize;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getPlcDataType() {
        return this.dataType.name();
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public GenericCANDataType getDataType() {
        return this.dataType;
    }

    public static Optional<GenericCANField> matches(String fieldQuery) {
        Matcher matcher = ADDRESS_PATTERN.matcher(fieldQuery);
        return matcher.matches() ? Optional.ofNullable(GenericCANField.create(matcher)) : Optional.empty();
    }

    static GenericCANField create(Matcher fieldQuery) {
        GenericCANDataType dataType;
        int nodeId = Integer.parseInt(fieldQuery.group("nodeId"));
        String type = fieldQuery.group("dataType");
        try {
            dataType = GenericCANDataType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new PlcRuntimeException("Could not create field with data type " + type, (Throwable)e);
        }
        int arraySize = fieldQuery.group("arraySize") != null ? Integer.parseInt(fieldQuery.group("arraySize")) : 0;
        return new GenericCANField(nodeId, dataType, arraySize);
    }

    public String toString() {
        return "GenericCANField(" + this.nodeId + ":" + this.dataType.name() + (this.arraySize == 0 ? "" : "[" + this.arraySize + "]");
    }
}

