/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.field;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.canopen.field.CANOpenField;
import org.apache.plc4x.java.canopen.field.CANOpenSubscriptionField;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class CANOpenNMTField
extends CANOpenField
implements CANOpenSubscriptionField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("NMT|NMT:" + NODE_PATTERN);

    public CANOpenNMTField(int node) {
        super(node);
    }

    @Override
    public CANOpenService getService() {
        return CANOpenService.NMT;
    }

    @Override
    public boolean isWildcard() {
        return this.getNodeId() == 0;
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
    }

    public static CANOpenNMTField of(String addressString) {
        Matcher matcher = CANOpenNMTField.getMatcher(addressString);
        int nodeId = matcher.group("nodeId") == null ? 0 : Integer.parseInt(matcher.group("nodeId"));
        return new CANOpenNMTField(nodeId);
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String serviceName = this.getService().name();
        writeBuffer.writeString("service", serviceName.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), serviceName, new WithWriterArgs[0]);
        writeBuffer.writeInt("node", 64, this.getNodeId(), new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

