/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.protocol;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.can.adapter.Plc4xCANProtocolBase;
import org.apache.plc4x.java.canopen.api.conversation.canopen.CANConversation;
import org.apache.plc4x.java.canopen.api.conversation.canopen.SDODownloadConversation;
import org.apache.plc4x.java.canopen.api.conversation.canopen.SDOUploadConversation;
import org.apache.plc4x.java.canopen.configuration.CANOpenConfiguration;
import org.apache.plc4x.java.canopen.context.CANOpenDriverContext;
import org.apache.plc4x.java.canopen.conversation.CANTransportConversation;
import org.apache.plc4x.java.canopen.field.CANOpenField;
import org.apache.plc4x.java.canopen.field.CANOpenHeartbeatField;
import org.apache.plc4x.java.canopen.field.CANOpenNMTField;
import org.apache.plc4x.java.canopen.field.CANOpenPDOField;
import org.apache.plc4x.java.canopen.field.CANOpenSDOField;
import org.apache.plc4x.java.canopen.protocol.CANOpenSubscriptionHandle;
import org.apache.plc4x.java.canopen.readwrite.CANOpenFrame;
import org.apache.plc4x.java.canopen.readwrite.CANOpenHeartbeatPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenNetworkPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPDO;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPDOPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.readwrite.DataItem;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.canopen.readwrite.NMTState;
import org.apache.plc4x.java.canopen.readwrite.NMTStateRequest;
import org.apache.plc4x.java.canopen.transport.CANOpenAbortException;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionEvent;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionHandle;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcNull;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CANOpenProtocolLogic
extends Plc4xCANProtocolBase<CANOpenFrame>
implements HasConfiguration<CANOpenConfiguration>,
PlcSubscriber {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(10L);
    private Logger logger = LoggerFactory.getLogger(CANOpenProtocolLogic.class);
    private CANOpenConfiguration configuration;
    private RequestTransactionManager tm;
    private Timer heartbeat;
    private CANOpenDriverContext canContext;
    private CANConversation conversation;
    private Map<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> consumers = new ConcurrentHashMap<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>>();

    public void setConfiguration(CANOpenConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
        this.canContext = (CANOpenDriverContext)driverContext;
        this.tm = new RequestTransactionManager(1);
    }

    public void onConnect(final ConversationContext<CANOpenFrame> context) {
        try {
            if (this.configuration.isHeartbeat()) {
                context.sendToWire((Object)this.createFrame(new CANOpenHeartbeatPayload(NMTState.BOOTED_UP)));
                this.heartbeat = new Timer("can-heartbeat");
                this.heartbeat.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            context.sendToWire((Object)CANOpenProtocolLogic.this.createFrame(new CANOpenHeartbeatPayload(NMTState.OPERATIONAL)));
                        }
                        catch (ParseException e) {
                            throw new PlcRuntimeException((Throwable)e);
                        }
                    }
                }, 10000L, 10000L);
            }
            context.fireConnected();
        }
        catch (ParseException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    public void setContext(ConversationContext<CANOpenFrame> context) {
        super.setContext(context);
        this.conversation = new CANTransportConversation(this.configuration.getNodeId(), context, this.configuration.getRequestTimeout());
    }

    private CANOpenFrame createFrame(CANOpenHeartbeatPayload state) throws ParseException {
        return new CANOpenFrame((short)this.configuration.getNodeId(), CANOpenService.HEARTBEAT, state);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        CompletableFuture<PlcWriteResponse> response = new CompletableFuture<PlcWriteResponse>();
        if (writeRequest.getFieldNames().size() != 1) {
            response.completeExceptionally(new IllegalArgumentException("You can write only one field at the time"));
            return response;
        }
        PlcField field = (PlcField)writeRequest.getFields().get(0);
        if (!(field instanceof CANOpenField)) {
            response.completeExceptionally(new IllegalArgumentException("Only CANOpenField instances are supported"));
            return response;
        }
        if (field instanceof CANOpenSDOField) {
            this.writeInternally((DefaultPlcWriteRequest)writeRequest, (CANOpenSDOField)field, response);
            return response;
        }
        if (field instanceof CANOpenPDOField) {
            this.writeInternally((DefaultPlcWriteRequest)writeRequest, (CANOpenPDOField)field, response);
            return response;
        }
        response.completeExceptionally(new IllegalArgumentException("Only CANOpenSDOField instances are supported"));
        return response;
    }

    private void writeInternally(DefaultPlcWriteRequest writeRequest, CANOpenSDOField field, CompletableFuture<PlcWriteResponse> response) {
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        String fieldName = (String)writeRequest.getFieldNames().iterator().next();
        CompletableFuture callback = new CompletableFuture();
        callback.whenComplete((code, error) -> {
            if (error != null) {
                if (error instanceof CANOpenAbortException) {
                    response.complete((PlcWriteResponse)new DefaultPlcWriteResponse((PlcWriteRequest)writeRequest, Collections.singletonMap(fieldName, PlcResponseCode.REMOTE_ERROR)));
                } else {
                    response.complete((PlcWriteResponse)new DefaultPlcWriteResponse((PlcWriteRequest)writeRequest, Collections.singletonMap(fieldName, PlcResponseCode.INTERNAL_ERROR)));
                }
                transaction.endRequest();
                return;
            }
            response.complete((PlcWriteResponse)new DefaultPlcWriteResponse((PlcWriteRequest)writeRequest, Collections.singletonMap(fieldName, code)));
            transaction.endRequest();
        });
        PlcValue writeValue = (PlcValue)writeRequest.getPlcValues().get(0);
        SDODownloadConversation download = new SDODownloadConversation(this.conversation, field.getNodeId(), field.getAnswerNodeId(), new IndexAddress(field.getIndex(), field.getSubIndex()), writeValue, field.getCanOpenDataType());
        transaction.submit(() -> download.execute(callback));
    }

    private void writeInternally(DefaultPlcWriteRequest writeRequest, CANOpenPDOField field, CompletableFuture<PlcWriteResponse> response) {
        PlcValue writeValue = (PlcValue)writeRequest.getPlcValues().get(0);
        try {
            String fieldName = (String)writeRequest.getFieldNames().iterator().next();
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(writeValue, field.getCanOpenDataType(), writeValue.getLength()), ByteOrder.LITTLE_ENDIAN);
            DataItem.staticSerialize((WriteBuffer)writeBuffer, writeValue, field.getCanOpenDataType(), writeValue.getLength(), ByteOrder.LITTLE_ENDIAN);
            CANOpenPDOPayload payload = new CANOpenPDOPayload(new CANOpenPDO(writeBuffer.getData()));
            this.context.sendToWire((Object)new CANOpenFrame((short)field.getNodeId(), field.getService(), payload));
            response.complete((PlcWriteResponse)new DefaultPlcWriteResponse((PlcWriteRequest)writeRequest, Collections.singletonMap(fieldName, PlcResponseCode.OK)));
        }
        catch (Exception e) {
            response.completeExceptionally(e);
        }
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        CompletableFuture<PlcReadResponse> response = new CompletableFuture<PlcReadResponse>();
        if (readRequest.getFieldNames().size() != 1) {
            response.completeExceptionally(new IllegalArgumentException("SDO requires single field to be read"));
            return response;
        }
        PlcField field = (PlcField)readRequest.getFields().get(0);
        if (!(field instanceof CANOpenField)) {
            response.completeExceptionally(new IllegalArgumentException("Only CANOpenField instances are supported"));
            return response;
        }
        if (!(field instanceof CANOpenSDOField)) {
            response.completeExceptionally(new IllegalArgumentException("Only CANOpenSDOField instances are supported"));
            return response;
        }
        this.readInternally(readRequest, (CANOpenSDOField)field, response);
        return response;
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest request) {
        DefaultPlcSubscriptionRequest rq = (DefaultPlcSubscriptionRequest)request;
        LinkedHashMap<String, ResponseItem> answers = new LinkedHashMap<String, ResponseItem>();
        DefaultPlcSubscriptionResponse response = new DefaultPlcSubscriptionResponse((PlcSubscriptionRequest)rq, answers);
        for (String key : rq.getFieldNames()) {
            DefaultPlcSubscriptionField subscription = (DefaultPlcSubscriptionField)rq.getField(key);
            if (subscription.getPlcSubscriptionType() != PlcSubscriptionType.EVENT) {
                answers.put(key, new ResponseItem(PlcResponseCode.UNSUPPORTED, null));
                continue;
            }
            if (subscription.getPlcField() instanceof CANOpenPDOField) {
                answers.put(key, new ResponseItem(PlcResponseCode.OK, (Object)new CANOpenSubscriptionHandle(this, key, (CANOpenPDOField)subscription.getPlcField())));
                continue;
            }
            if (subscription.getPlcField() instanceof CANOpenNMTField) {
                answers.put(key, new ResponseItem(PlcResponseCode.OK, (Object)new CANOpenSubscriptionHandle(this, key, (CANOpenNMTField)subscription.getPlcField())));
                continue;
            }
            if (subscription.getPlcField() instanceof CANOpenHeartbeatField) {
                answers.put(key, new ResponseItem(PlcResponseCode.OK, (Object)new CANOpenSubscriptionHandle(this, key, (CANOpenHeartbeatField)subscription.getPlcField())));
                continue;
            }
            answers.put(key, new ResponseItem(PlcResponseCode.INVALID_ADDRESS, null));
        }
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest request) {
        List handles = request.getSubscriptionHandles();
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            entry.getKey().getSubscriptionHandles().removeAll(handles);
        }
        return CompletableFuture.completedFuture(new DefaultPlcUnsubscriptionResponse(request));
    }

    private void readInternally(PlcReadRequest readRequest, CANOpenSDOField field, CompletableFuture<PlcReadResponse> response) {
        String fieldName = (String)readRequest.getFieldNames().iterator().next();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        CompletableFuture callback = new CompletableFuture();
        callback.whenComplete((value, error) -> {
            if (error != null) {
                HashMap<String, ResponseItem> fields = new HashMap<String, ResponseItem>();
                if (error instanceof CANOpenAbortException) {
                    fields.put(fieldName, new ResponseItem(PlcResponseCode.REMOTE_ERROR, (Object)new PlcLINT(((CANOpenAbortException)((Object)((Object)error))).getAbortCode())));
                } else {
                    fields.put(fieldName, new ResponseItem(PlcResponseCode.REMOTE_ERROR, null));
                }
                response.complete((PlcReadResponse)new DefaultPlcReadResponse(readRequest, fields));
                transaction.endRequest();
                return;
            }
            HashMap<String, ResponseItem> fields = new HashMap<String, ResponseItem>();
            fields.put(fieldName, new ResponseItem(PlcResponseCode.OK, value));
            response.complete((PlcReadResponse)new DefaultPlcReadResponse(readRequest, fields));
            transaction.endRequest();
        });
        SDOUploadConversation upload = new SDOUploadConversation(this.conversation, field.getNodeId(), field.getAnswerNodeId(), new IndexAddress(field.getIndex(), field.getSubIndex()), field.getCanOpenDataType());
        transaction.submit(() -> upload.execute(callback));
    }

    public void decode(ConversationContext<CANOpenFrame> context, CANOpenFrame msg) throws Exception {
        short nodeId = msg.getNodeId();
        CANOpenService service = msg.getService();
        CANOpenPayload payload = msg.getPayload();
        if (service != null && nodeId != this.configuration.getNodeId()) {
            if (service.getPdo() && payload instanceof CANOpenPDOPayload) {
                this.publishEvent(service, nodeId, payload);
            } else if (service == CANOpenService.HEARTBEAT && payload instanceof CANOpenHeartbeatPayload) {
                this.publishEvent(service, nodeId, payload);
            } else {
                this.logger.debug("Decoded CANOpen {} from {}, message {}", new Object[]{service, (int)nodeId, payload});
            }
        }
    }

    private void publishEvent(CANOpenService service, int nodeId, CANOpenPayload payload) {
        CANOpenSubscriptionHandle dispatchedHandle = null;
        for (Map.Entry<DefaultPlcConsumerRegistration, Consumer<PlcSubscriptionEvent>> entry : this.consumers.entrySet()) {
            DefaultPlcConsumerRegistration registration = entry.getKey();
            Consumer<PlcSubscriptionEvent> consumer = entry.getValue();
            for (PlcSubscriptionHandle handler : registration.getSubscriptionHandles()) {
                PlcStruct struct;
                HashMap<String, PlcUSINT> fields;
                Enum state;
                DefaultPlcSubscriptionEvent event;
                CANOpenSubscriptionHandle handle = (CANOpenSubscriptionHandle)handler;
                if (payload instanceof CANOpenPDOPayload) {
                    if (!handle.matches(service, nodeId)) continue;
                    this.logger.trace("Dispatching notification {} for node {} to {}", new Object[]{service, nodeId, handle});
                    dispatchedHandle = handle;
                    CANOpenPDOField field = (CANOpenPDOField)handle.getField();
                    byte[] data = ((CANOpenPDOPayload)payload).getPdo().getData();
                    try {
                        PlcValue value = DataItem.staticParse((ReadBuffer)new ReadBufferByteBased(data, ByteOrder.LITTLE_ENDIAN), field.getCanOpenDataType(), data.length);
                        event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(handle.getName(), new ResponseItem(PlcResponseCode.OK, (Object)value)));
                        consumer.accept((PlcSubscriptionEvent)event);
                    }
                    catch (ParseException e) {
                        this.logger.warn("Could not parse data to desired type: {}", (Object)field.getCanOpenDataType(), (Object)e);
                        event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(handle.getName(), new ResponseItem(PlcResponseCode.INVALID_DATA, (Object)new PlcNull())));
                        consumer.accept((PlcSubscriptionEvent)event);
                    }
                    continue;
                }
                if (payload instanceof CANOpenHeartbeatPayload) {
                    if (!handle.matches(service, nodeId)) continue;
                    this.logger.trace("Dispatching notification {} for node {} to {}", new Object[]{service, nodeId, handle});
                    dispatchedHandle = handle;
                    state = ((CANOpenHeartbeatPayload)payload).getState();
                    fields = new HashMap<String, PlcUSINT>();
                    fields.put("state", new PlcUSINT(((NMTState)state).getValue()));
                    fields.put("node", new PlcUSINT(Integer.valueOf(nodeId)));
                    struct = new PlcStruct(fields);
                    event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(handle.getName(), new ResponseItem(PlcResponseCode.OK, (Object)struct)));
                    consumer.accept((PlcSubscriptionEvent)event);
                    continue;
                }
                if (!(payload instanceof CANOpenNetworkPayload) || !handle.matches(service, nodeId)) continue;
                this.logger.trace("Dispatching notification {} for node {} to {}", new Object[]{service, nodeId, handle});
                dispatchedHandle = handle;
                state = ((CANOpenNetworkPayload)payload).getRequest();
                fields = new HashMap();
                fields.put("state", new PlcUSINT(((NMTStateRequest)state).getValue()));
                fields.put("node", new PlcUSINT(Integer.valueOf(nodeId)));
                struct = new PlcStruct(fields);
                event = new DefaultPlcSubscriptionEvent(Instant.now(), Collections.singletonMap(handle.getName(), new ResponseItem(PlcResponseCode.OK, (Object)struct)));
                consumer.accept((PlcSubscriptionEvent)event);
            }
        }
        if (dispatchedHandle == null) {
            this.logger.trace("Could not find subscription matching {} and node {}", (Object)service, (Object)nodeId);
        }
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        DefaultPlcConsumerRegistration consumerRegistration = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, (PlcSubscriptionHandle[])handles.toArray(new DefaultPlcSubscriptionHandle[0]));
        this.consumers.put(consumerRegistration, consumer);
        return consumerRegistration;
    }

    public void unregister(PlcConsumerRegistration registration) {
        this.consumers.remove(registration);
    }

    public void close(ConversationContext<CANOpenFrame> context) {
    }

    public void onDisconnect(ConversationContext<CANOpenFrame> context) {
        if (this.heartbeat != null) {
            this.heartbeat.cancel();
            this.heartbeat = null;
        }
    }
}

