/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CANOpenDataType {
    BOOLEAN(0L, 1),
    UNSIGNED8(1L, 8),
    UNSIGNED16(2L, 16),
    UNSIGNED24(3L, 24),
    UNSIGNED32(4L, 32),
    UNSIGNED40(5L, 40),
    UNSIGNED48(6L, 48),
    UNSIGNED56(7L, 56),
    UNSIGNED64(8L, 64),
    INTEGER8(9L, 8),
    INTEGER16(10L, 16),
    INTEGER24(11L, 24),
    INTEGER32(12L, 32),
    INTEGER40(13L, 40),
    INTEGER48(14L, 48),
    INTEGER56(15L, 56),
    INTEGER64(16L, 64),
    REAL32(17L, 32),
    REAL64(18L, 64),
    RECORD(19L, 8),
    OCTET_STRING(20L, 8),
    VISIBLE_STRING(21L, 8),
    UNICODE_STRING(22L, 16),
    TIME_OF_DAY(23L, 48),
    TIME_DIFFERENCE(24L, 48);

    private static final Map<Long, CANOpenDataType> map;
    private long value;
    private short numBits;

    private CANOpenDataType(long value, short numBits) {
        this.value = value;
        this.numBits = numBits;
    }

    public long getValue() {
        return this.value;
    }

    public short getNumBits() {
        return this.numBits;
    }

    public static CANOpenDataType firstEnumForFieldNumBits(short fieldValue) {
        for (CANOpenDataType _val : CANOpenDataType.values()) {
            if (_val.getNumBits() != fieldValue) continue;
            return _val;
        }
        return null;
    }

    public static List<CANOpenDataType> enumsForFieldNumBits(short fieldValue) {
        ArrayList<CANOpenDataType> _values = new ArrayList<CANOpenDataType>();
        for (CANOpenDataType _val : CANOpenDataType.values()) {
            if (_val.getNumBits() != fieldValue) continue;
            _values.add(_val);
        }
        return _values;
    }

    public static CANOpenDataType enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }

    static {
        map = new HashMap<Long, CANOpenDataType>();
        for (CANOpenDataType value : CANOpenDataType.values()) {
            map.put(value.getValue(), value);
        }
    }
}

