/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.eip.readwrite.configuration.EIPConfiguration;
import org.apache.plc4x.java.eip.readwrite.field.EipField;
import org.apache.plc4x.java.eip.readwrite.field.EipFieldHandler;
import org.apache.plc4x.java.eip.readwrite.protocol.EipProtocolLogic;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;

public class EIPDriver
extends GeneratedDriverBase<EipPacket> {
    public static final int PORT = 44818;

    public String getProtocolCode() {
        return "eip";
    }

    public String getProtocolName() {
        return "EthernetIP";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return EIPConfiguration.class;
    }

    protected PlcFieldHandler getFieldHandler() {
        return new EipFieldHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new IEC61131ValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected ProtocolStackConfigurer<EipPacket> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(EipPacket.class, EipPacket::staticParse).withProtocol(EipProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).littleEndian().build();
    }

    public EipField prepareField(String query) {
        return EipField.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                int size = byteBuf.getUnsignedShort(byteBuf.readerIndex() + 1) + 24;
                return size;
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != 0) {
                byteBuf.readByte();
            }
        }
    }
}

