/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EipConnectionRequest
extends EipPacket
implements Message {
    public static final Integer PROTOCOLVERSION = 1;
    public static final Integer FLAGS = 0;

    @Override
    public Integer getCommand() {
        return 101;
    }

    public EipConnectionRequest(long sessionHandle, long status, List<Short> senderContext, long options) {
        super(sessionHandle, status, senderContext, options);
    }

    public int getProtocolVersion() {
        return PROTOCOLVERSION;
    }

    public int getFlags() {
        return FLAGS;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("EipConnectionRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"protocolVersion", (Object)PROTOCOLVERSION, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"flags", (Object)FLAGS, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EipConnectionRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EipConnectionRequest _value = this;
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static EipConnectionRequestBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("EipConnectionRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int protocolVersion = (Integer)FieldReaderFactory.readConstField((String)"protocolVersion", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)PROTOCOLVERSION, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int flags = (Integer)FieldReaderFactory.readConstField((String)"flags", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)FLAGS, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("EipConnectionRequest", new WithReaderArgs[0]);
        return new EipConnectionRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipConnectionRequest)) {
            return false;
        }
        EipConnectionRequest that = (EipConnectionRequest)o;
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EipConnectionRequestBuilder
    implements EipPacket.EipPacketBuilder {
        @Override
        public EipConnectionRequest build(long sessionHandle, long status, List<Short> senderContext, long options) {
            EipConnectionRequest eipConnectionRequest = new EipConnectionRequest(sessionHandle, status, senderContext, options);
            return eipConnectionRequest;
        }
    }
}

