/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.knxnetip.ets.model.GroupAddress;

public class KnxNetIpField
implements PlcField {
    private static final String WILDCARD = "*";
    private static final Pattern KNX_GROUP_ADDRESS_1_LEVEL = Pattern.compile("^(?<mainGroup>(\\d{1,5}|\\*))");
    private static final Pattern KNX_GROUP_ADDRESS_2_LEVEL = Pattern.compile("^(?<mainGroup>(\\d{1,2}|\\*))/(?<subGroup>(\\d{1,4}|\\*))");
    private static final Pattern KNX_GROUP_ADDRESS_3_LEVEL = Pattern.compile("^(?<mainGroup>(\\d{1,2}|\\*))/(?<middleGroup>(\\d|\\*))/(?<subGroup>(\\d{1,3}|\\*))");
    private final int levels;
    private final String mainGroup;
    private final String middleGroup;
    private final String subGroup;

    public static boolean matches(String fieldString) {
        return KNX_GROUP_ADDRESS_3_LEVEL.matcher(fieldString).matches() || KNX_GROUP_ADDRESS_2_LEVEL.matcher(fieldString).matches() || KNX_GROUP_ADDRESS_1_LEVEL.matcher(fieldString).matches();
    }

    public static KnxNetIpField of(String fieldString) {
        Matcher matcher = KNX_GROUP_ADDRESS_1_LEVEL.matcher(fieldString);
        if (matcher.matches()) {
            return new KnxNetIpField(1, matcher.group("mainGroup"), null, null);
        }
        matcher = KNX_GROUP_ADDRESS_2_LEVEL.matcher(fieldString);
        if (matcher.matches()) {
            return new KnxNetIpField(2, matcher.group("mainGroup"), null, matcher.group("subGroup"));
        }
        matcher = KNX_GROUP_ADDRESS_3_LEVEL.matcher(fieldString);
        if (matcher.matches()) {
            return new KnxNetIpField(3, matcher.group("mainGroup"), matcher.group("middleGroup"), matcher.group("subGroup"));
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }

    public KnxNetIpField(int levels, String mainGroup, String middleGroup, String subGroup) {
        this.levels = levels;
        this.mainGroup = mainGroup;
        this.middleGroup = middleGroup;
        this.subGroup = subGroup;
    }

    public int getLevels() {
        return this.levels;
    }

    public String getMainGroup() {
        return this.mainGroup;
    }

    public String getMiddleGroup() {
        return this.middleGroup;
    }

    public String getSubGroup() {
        return this.subGroup;
    }

    public String getPlcDataType() {
        return "";
    }

    public boolean matchesGroupAddress(GroupAddress groupAddress) {
        KnxNetIpField otherAddress = KnxNetIpField.of(groupAddress.getGroupAddress());
        if (otherAddress.getLevels() != this.getLevels()) {
            return false;
        }
        switch (this.getLevels()) {
            case 3: {
                if (!WILDCARD.equals(this.getMiddleGroup()) && !this.getMiddleGroup().equals(otherAddress.getMiddleGroup())) {
                    return false;
                }
            }
            case 2: {
                if (!WILDCARD.equals(this.getSubGroup()) && !this.getSubGroup().equals(otherAddress.getSubGroup())) {
                    return false;
                }
            }
            case 1: {
                return WILDCARD.equals(this.getMainGroup()) || this.getMainGroup().equals(otherAddress.getMainGroup());
            }
        }
        return false;
    }
}

