/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.knxnetip.readwrite.KnxPropertyDataType;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnxProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnxProperty.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, KnxPropertyDataType propertyType, Short dataLengthInBytes) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CONTROL))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CHAR))) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_CHAR))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_INT))) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_INT)) && EvaluationHelper.equals((Object)dataLengthInBytes, (Object)4)) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_INT))) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_KNX_FLOAT))) {
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DATE))) {
            byte reserved = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short dayOfMonth = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            byte reserved2 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved2 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved2 + " for reserved field.");
            }
            Byte month = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved3 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved3 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved3 + " for reserved field.");
            }
            Short year = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("dayOfMonth", new PlcINT(dayOfMonth));
            _map.put("month", new PlcSINT(month));
            _map.put("year", new PlcINT(year));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_TIME))) {
            Byte day = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            byte reserved = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short minutes = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            byte reserved4 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved4 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved4 + " for reserved field.");
            }
            Short seconds = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("day", new PlcSINT(day));
            _map.put("hour", new PlcINT(hour));
            _map.put("minutes", new PlcINT(minutes));
            _map.put("seconds", new PlcINT(seconds));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_LONG))) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_LONG))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_FLOAT))) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DOUBLE))) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CHAR_BLOCK))) {
            int itemCount = 10;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS))) {
            int itemCount = 2;
            LinkedList<PlcSINT> groupAddress = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                groupAddress.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            Boolean disable = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte pollingSoftNr = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("groupAddress", new PlcList(groupAddress));
            _map.put("disable", new PlcBOOL(disable));
            _map.put("pollingSoftNr", new PlcSINT(pollingSoftNr));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK))) {
            int itemCount = 5;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DATE_TIME))) {
            Short year = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte month = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved5 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved5 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved5 + " for reserved field.");
            }
            Short dayofmonth = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            Byte dayofweek = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Short hourofday = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            byte reserved6 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved6 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved6 + " for reserved field.");
            }
            Short minutes = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            byte reserved7 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved7 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved7 + " for reserved field.");
            }
            Short seconds = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean workingDay = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noWd = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noYear = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noDate = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noDayOfWeek = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noTime = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean standardSummerTime = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean qualityOfClock = readBuffer.readBit("", new WithReaderArgs[0]);
            short reserved8 = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved8 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved8 + " for reserved field.");
            }
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("year", new PlcINT(year));
            _map.put("month", new PlcSINT(month));
            _map.put("dayofmonth", new PlcINT(dayofmonth));
            _map.put("dayofweek", new PlcSINT(dayofweek));
            _map.put("hourofday", new PlcINT(hourofday));
            _map.put("minutes", new PlcINT(minutes));
            _map.put("seconds", new PlcINT(seconds));
            _map.put("fault", new PlcBOOL(fault));
            _map.put("workingDay", new PlcBOOL(workingDay));
            _map.put("noWd", new PlcBOOL(noWd));
            _map.put("noYear", new PlcBOOL(noYear));
            _map.put("noDate", new PlcBOOL(noDate));
            _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
            _map.put("noTime", new PlcBOOL(noTime));
            _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
            _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_01))) {
            int itemCount = 1;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_02))) {
            int itemCount = 2;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_03))) {
            int itemCount = 3;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_04))) {
            int itemCount = 4;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_05))) {
            int itemCount = 5;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_06))) {
            int itemCount = 6;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_07))) {
            int itemCount = 7;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_08))) {
            int itemCount = 8;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_09))) {
            int itemCount = 9;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_10))) {
            int itemCount = 10;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_11))) {
            int itemCount = 11;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_12))) {
            int itemCount = 12;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_13))) {
            int itemCount = 13;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_14))) {
            int itemCount = 14;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_15))) {
            int itemCount = 15;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_16))) {
            int itemCount = 16;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_17))) {
            int itemCount = 17;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_18))) {
            int itemCount = 18;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_19))) {
            int itemCount = 19;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_20))) {
            int itemCount = 20;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_VERSION))) {
            Short magicNumber = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            Short versionNumber = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            Short revisionNumber = readBuffer.readUnsignedShort("", 6, new WithReaderArgs[0]);
            HashMap<String, PlcINT> _map = new HashMap<String, PlcINT>();
            _map.put("magicNumber", new PlcINT(magicNumber));
            _map.put("versionNumber", new PlcINT(versionNumber));
            _map.put("revisionNumber", new PlcINT(revisionNumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_ALARM_INFO))) {
            Short logNumber = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short alarmPriority = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short applicationArea = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short errorClass = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean errorcodeSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarmtextSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean timestampSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ackSup = readBuffer.readBit("", new WithReaderArgs[0]);
            short reserved9 = readBuffer.readUnsignedShort("", 5, new WithReaderArgs[0]);
            if (reserved9 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved9 + " for reserved field.");
            }
            Boolean locked = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarmunack = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("logNumber", new PlcINT(logNumber));
            _map.put("alarmPriority", new PlcINT(alarmPriority));
            _map.put("applicationArea", new PlcINT(applicationArea));
            _map.put("errorClass", new PlcINT(errorClass));
            _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
            _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
            _map.put("timestampSup", new PlcBOOL(timestampSup));
            _map.put("ackSup", new PlcBOOL(ackSup));
            _map.put("locked", new PlcBOOL(locked));
            _map.put("alarmunack", new PlcBOOL(alarmunack));
            _map.put("inalarm", new PlcBOOL(inalarm));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BINARY_INFORMATION))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BITSET8))) {
            int itemCount = 8;
            LinkedList<PlcBOOL> value = new LinkedList<PlcBOOL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcBOOL(Boolean.valueOf(readBuffer.readBit("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BITSET16))) {
            int itemCount = 16;
            LinkedList<PlcBOOL> value = new LinkedList<PlcBOOL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcBOOL(Boolean.valueOf(readBuffer.readBit("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_ENUM8))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_SCALING))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (dataLengthInBytes > Integer.MAX_VALUE) {
            throw new ParseException("Array count of " + dataLengthInBytes + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
        }
        int itemCount = dataLengthInBytes.shortValue();
        LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
        for (int curItem = 0; curItem < itemCount; ++curItem) {
            value.add(new PlcSINT(Byte.valueOf(readBuffer.readByte("", new WithReaderArgs[0]))));
        }
        return new PlcList(value);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) throws SerializationException {
        KnxProperty.staticSerialize(writeBuffer, _value, propertyType, dataLengthInBytes, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CONTROL))) {
            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CHAR))) {
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_CHAR))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_INT))) {
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_INT)) && EvaluationHelper.equals((Object)dataLengthInBytes, (Object)4)) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_INT))) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_KNX_FLOAT))) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DATE))) {
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short dayOfMonth = ((PlcValue)_value.getStruct().get("dayOfMonth")).getShort();
            writeBuffer.writeUnsignedShort("", 5, ((Number)dayOfMonth).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte month = ((PlcValue)_value.getStruct().get("month")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)month).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short year = ((PlcValue)_value.getStruct().get("year")).getShort();
            writeBuffer.writeUnsignedShort("", 7, ((Number)year).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_TIME))) {
            byte day = ((PlcValue)_value.getStruct().get("day")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)day).byteValue(), new WithWriterArgs[0]);
            short hour = ((PlcValue)_value.getStruct().get("hour")).getShort();
            writeBuffer.writeUnsignedShort("", 5, ((Number)hour).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short minutes = ((PlcValue)_value.getStruct().get("minutes")).getShort();
            writeBuffer.writeUnsignedShort("", 6, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short seconds = ((PlcValue)_value.getStruct().get("seconds")).getShort();
            writeBuffer.writeUnsignedShort("", 6, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_LONG))) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_LONG))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_FLOAT))) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DOUBLE))) {
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CHAR_BLOCK))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : ((PlcValue)values.getStruct().get("groupAddress")).getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
            boolean disable = ((PlcValue)_value.getStruct().get("disable")).getBoolean();
            writeBuffer.writeBit("", disable, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte pollingSoftNr = ((PlcValue)_value.getStruct().get("pollingSoftNr")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)pollingSoftNr).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DATE_TIME))) {
            short year = ((PlcValue)_value.getStruct().get("year")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)year).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte month = ((PlcValue)_value.getStruct().get("month")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)month).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short dayofmonth = ((PlcValue)_value.getStruct().get("dayofmonth")).getShort();
            writeBuffer.writeUnsignedShort("", 5, ((Number)dayofmonth).shortValue(), new WithWriterArgs[0]);
            byte dayofweek = ((PlcValue)_value.getStruct().get("dayofweek")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)dayofweek).byteValue(), new WithWriterArgs[0]);
            short hourofday = ((PlcValue)_value.getStruct().get("hourofday")).getShort();
            writeBuffer.writeUnsignedShort("", 5, ((Number)hourofday).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short minutes = ((PlcValue)_value.getStruct().get("minutes")).getShort();
            writeBuffer.writeUnsignedShort("", 6, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            short seconds = ((PlcValue)_value.getStruct().get("seconds")).getShort();
            writeBuffer.writeUnsignedShort("", 6, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
            boolean workingDay = ((PlcValue)_value.getStruct().get("workingDay")).getBoolean();
            writeBuffer.writeBit("", workingDay, new WithWriterArgs[0]);
            boolean noWd = ((PlcValue)_value.getStruct().get("noWd")).getBoolean();
            writeBuffer.writeBit("", noWd, new WithWriterArgs[0]);
            boolean noYear = ((PlcValue)_value.getStruct().get("noYear")).getBoolean();
            writeBuffer.writeBit("", noYear, new WithWriterArgs[0]);
            boolean noDate = ((PlcValue)_value.getStruct().get("noDate")).getBoolean();
            writeBuffer.writeBit("", noDate, new WithWriterArgs[0]);
            boolean noDayOfWeek = ((PlcValue)_value.getStruct().get("noDayOfWeek")).getBoolean();
            writeBuffer.writeBit("", noDayOfWeek, new WithWriterArgs[0]);
            boolean noTime = ((PlcValue)_value.getStruct().get("noTime")).getBoolean();
            writeBuffer.writeBit("", noTime, new WithWriterArgs[0]);
            boolean standardSummerTime = ((PlcValue)_value.getStruct().get("standardSummerTime")).getBoolean();
            writeBuffer.writeBit("", standardSummerTime, new WithWriterArgs[0]);
            boolean qualityOfClock = ((PlcValue)_value.getStruct().get("qualityOfClock")).getBoolean();
            writeBuffer.writeBit("", qualityOfClock, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_01))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_02))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_03))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_04))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_05))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_06))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_07))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_08))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_09))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_10))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_11))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_12))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_13))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_14))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_15))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_16))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_17))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_18))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_19))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_20))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_VERSION))) {
            short magicNumber = ((PlcValue)_value.getStruct().get("magicNumber")).getShort();
            writeBuffer.writeUnsignedShort("", 5, ((Number)magicNumber).shortValue(), new WithWriterArgs[0]);
            short versionNumber = ((PlcValue)_value.getStruct().get("versionNumber")).getShort();
            writeBuffer.writeUnsignedShort("", 5, ((Number)versionNumber).shortValue(), new WithWriterArgs[0]);
            short revisionNumber = ((PlcValue)_value.getStruct().get("revisionNumber")).getShort();
            writeBuffer.writeUnsignedShort("", 6, ((Number)revisionNumber).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_ALARM_INFO))) {
            short logNumber = ((PlcValue)_value.getStruct().get("logNumber")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)logNumber).shortValue(), new WithWriterArgs[0]);
            short alarmPriority = ((PlcValue)_value.getStruct().get("alarmPriority")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)alarmPriority).shortValue(), new WithWriterArgs[0]);
            short applicationArea = ((PlcValue)_value.getStruct().get("applicationArea")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)applicationArea).shortValue(), new WithWriterArgs[0]);
            short errorClass = ((PlcValue)_value.getStruct().get("errorClass")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)errorClass).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean errorcodeSup = ((PlcValue)_value.getStruct().get("errorcodeSup")).getBoolean();
            writeBuffer.writeBit("", errorcodeSup, new WithWriterArgs[0]);
            boolean alarmtextSup = ((PlcValue)_value.getStruct().get("alarmtextSup")).getBoolean();
            writeBuffer.writeBit("", alarmtextSup, new WithWriterArgs[0]);
            boolean timestampSup = ((PlcValue)_value.getStruct().get("timestampSup")).getBoolean();
            writeBuffer.writeBit("", timestampSup, new WithWriterArgs[0]);
            boolean ackSup = ((PlcValue)_value.getStruct().get("ackSup")).getBoolean();
            writeBuffer.writeBit("", ackSup, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedShort("", 5, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean locked = ((PlcValue)_value.getStruct().get("locked")).getBoolean();
            writeBuffer.writeBit("", locked, new WithWriterArgs[0]);
            boolean alarmunack = ((PlcValue)_value.getStruct().get("alarmunack")).getBoolean();
            writeBuffer.writeBit("", alarmunack, new WithWriterArgs[0]);
            boolean inalarm = ((PlcValue)_value.getStruct().get("inalarm")).getBoolean();
            writeBuffer.writeBit("", inalarm, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BINARY_INFORMATION))) {
            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BITSET8))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Boolean value = val.getBoolean();
                writeBuffer.writeBit("", value.booleanValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BITSET16))) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Boolean value = val.getBoolean();
                writeBuffer.writeBit("", value.booleanValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_ENUM8))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_SCALING))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                byte[] value = val.getRaw();
                writeBuffer.writeByteArray("", value, new WithWriterArgs[0]);
            }
        }
    }

    public static int getLengthInBytes(PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) {
        return (int)Math.ceil((double)KnxProperty.getLengthInBits(_value, propertyType, dataLengthInBytes) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CONTROL))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CHAR))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_CHAR))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_INT))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_INT)) && EvaluationHelper.equals((Object)dataLengthInBytes, (Object)4)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_INT))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_KNX_FLOAT))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DATE))) {
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 4;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 7;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_TIME))) {
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 2;
            sizeInBits += 6;
            sizeInBits += 2;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_LONG))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_UNSIGNED_LONG))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_FLOAT))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DOUBLE))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_CHAR_BLOCK))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS))) {
            PlcList values = (PlcList)_value;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_DATE_TIME))) {
            sizeInBits += 8;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 2;
            sizeInBits += 6;
            sizeInBits += 2;
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 7;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_01))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_02))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_03))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_04))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_05))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_06))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_07))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_08))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_09))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_10))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_11))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_12))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_13))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_14))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_15))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_16))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_17))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_18))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_19))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_GENERIC_20))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_VERSION))) {
            sizeInBits += 5;
            sizeInBits += 5;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_ALARM_INFO))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BINARY_INFORMATION))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BITSET8))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 1;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_BITSET16))) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 1;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_ENUM8))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)propertyType), (Object)((Object)KnxPropertyDataType.PDT_SCALING))) {
            sizeInBits += 8;
        } else {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        }
        return sizeInBits;
    }
}

