/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ByteStringArray
implements Message {
    protected final int arrayLength;
    protected final List<Short> value;

    public ByteStringArray(int arrayLength, List<Short> value) {
        this.arrayLength = arrayLength;
        this.value = value;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public List<Short> getValue() {
        return this.value;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ByteStringArray", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"arrayLength", (Object)this.arrayLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"value", this.value, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ByteStringArray", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        ByteStringArray _value = this;
        lengthInBits += 32;
        if (this.value != null) {
            lengthInBits += 8 * this.value.size();
        }
        return lengthInBits;
    }

    public static ByteStringArray staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ByteStringArray.staticParse(readBuffer);
    }

    public static ByteStringArray staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ByteStringArray", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int arrayLength = (Integer)FieldReaderFactory.readSimpleField((String)"arrayLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List value = FieldReaderFactory.readCountArrayField((String)"value", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (long)arrayLength, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ByteStringArray", new WithReaderArgs[0]);
        ByteStringArray _byteStringArray = new ByteStringArray(arrayLength, value);
        return _byteStringArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteStringArray)) {
            return false;
        }
        ByteStringArray that = (ByteStringArray)o;
        return this.getArrayLength() == that.getArrayLength() && this.getValue() == that.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.getArrayLength(), this.getValue());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

