/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CallRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfMethodsToCall;
    protected final List<ExtensionObjectDefinition> methodsToCall;

    @Override
    public String getIdentifier() {
        return "712";
    }

    public CallRequest(ExtensionObjectDefinition requestHeader, int noOfMethodsToCall, List<ExtensionObjectDefinition> methodsToCall) {
        this.requestHeader = requestHeader;
        this.noOfMethodsToCall = noOfMethodsToCall;
        this.methodsToCall = methodsToCall;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfMethodsToCall() {
        return this.noOfMethodsToCall;
    }

    public List<ExtensionObjectDefinition> getMethodsToCall() {
        return this.methodsToCall;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CallRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfMethodsToCall", (Object)this.noOfMethodsToCall, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"methodsToCall", this.methodsToCall, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CallRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CallRequest _value = this;
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.methodsToCall != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.methodsToCall) {
                boolean last = ++i >= this.methodsToCall.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static CallRequestBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CallRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        ExtensionObjectDefinition requestHeader = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfMethodsToCall = (Integer)FieldReaderFactory.readSimpleField((String)"noOfMethodsToCall", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List methodsToCall = FieldReaderFactory.readCountArrayField((String)"methodsToCall", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "706"), readBuffer), (long)noOfMethodsToCall, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CallRequest", new WithReaderArgs[0]);
        return new CallRequestBuilder(requestHeader, noOfMethodsToCall, methodsToCall);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallRequest)) {
            return false;
        }
        CallRequest that = (CallRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfMethodsToCall() == that.getNoOfMethodsToCall() && this.getMethodsToCall() == that.getMethodsToCall() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfMethodsToCall(), this.getMethodsToCall());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CallRequestBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfMethodsToCall;
        private final List<ExtensionObjectDefinition> methodsToCall;

        public CallRequestBuilder(ExtensionObjectDefinition requestHeader, int noOfMethodsToCall, List<ExtensionObjectDefinition> methodsToCall) {
            this.requestHeader = requestHeader;
            this.noOfMethodsToCall = noOfMethodsToCall;
            this.methodsToCall = methodsToCall;
        }

        @Override
        public CallRequest build() {
            CallRequest callRequest = new CallRequest(this.requestHeader, this.noOfMethodsToCall, this.methodsToCall);
            return callRequest;
        }
    }
}

