/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CurrencyUnitType
extends ExtensionObjectDefinition
implements Message {
    protected final short numericCode;
    protected final byte exponent;
    protected final PascalString alphabeticCode;
    protected final LocalizedText currency;

    @Override
    public String getIdentifier() {
        return "23500";
    }

    public CurrencyUnitType(short numericCode, byte exponent, PascalString alphabeticCode, LocalizedText currency) {
        this.numericCode = numericCode;
        this.exponent = exponent;
        this.alphabeticCode = alphabeticCode;
        this.currency = currency;
    }

    public short getNumericCode() {
        return this.numericCode;
    }

    public byte getExponent() {
        return this.exponent;
    }

    public PascalString getAlphabeticCode() {
        return this.alphabeticCode;
    }

    public LocalizedText getCurrency() {
        return this.currency;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CurrencyUnitType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"numericCode", (Object)this.numericCode, (DataWriter)DataWriterFactory.writeSignedShort((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"exponent", (Object)this.exponent, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"alphabeticCode", (Object)this.alphabeticCode, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"currency", (Object)this.currency, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CurrencyUnitType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CurrencyUnitType _value = this;
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += this.alphabeticCode.getLengthInBits();
        return lengthInBits += this.currency.getLengthInBits();
    }

    public static CurrencyUnitTypeBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CurrencyUnitType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short numericCode = (Short)FieldReaderFactory.readSimpleField((String)"numericCode", (DataReader)DataReaderFactory.readSignedShort((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        byte exponent = (Byte)FieldReaderFactory.readSimpleField((String)"exponent", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString alphabeticCode = (PascalString)FieldReaderFactory.readSimpleField((String)"alphabeticCode", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText currency = (LocalizedText)FieldReaderFactory.readSimpleField((String)"currency", (DataReader)new DataReaderComplexDefault(() -> LocalizedText.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CurrencyUnitType", new WithReaderArgs[0]);
        return new CurrencyUnitTypeBuilder(numericCode, exponent, alphabeticCode, currency);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrencyUnitType)) {
            return false;
        }
        CurrencyUnitType that = (CurrencyUnitType)o;
        return this.getNumericCode() == that.getNumericCode() && this.getExponent() == that.getExponent() && this.getAlphabeticCode() == that.getAlphabeticCode() && this.getCurrency() == that.getCurrency() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumericCode(), this.getExponent(), this.getAlphabeticCode(), this.getCurrency());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CurrencyUnitTypeBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final short numericCode;
        private final byte exponent;
        private final PascalString alphabeticCode;
        private final LocalizedText currency;

        public CurrencyUnitTypeBuilder(short numericCode, byte exponent, PascalString alphabeticCode, LocalizedText currency) {
            this.numericCode = numericCode;
            this.exponent = exponent;
            this.alphabeticCode = alphabeticCode;
            this.currency = currency;
        }

        @Override
        public CurrencyUnitType build() {
            CurrencyUnitType currencyUnitType = new CurrencyUnitType(this.numericCode, this.exponent, this.alphabeticCode, this.currency);
            return currencyUnitType;
        }
    }
}

