/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ExtensionObject
implements Message {
    protected final ExpandedNodeId typeId;
    protected final ExtensionObjectEncodingMask encodingMask;
    protected final ExtensionObjectDefinition body;
    protected final Boolean includeEncodingMask;

    public ExtensionObject(ExpandedNodeId typeId, ExtensionObjectEncodingMask encodingMask, ExtensionObjectDefinition body, Boolean includeEncodingMask) {
        this.typeId = typeId;
        this.encodingMask = encodingMask;
        this.body = body;
        this.includeEncodingMask = includeEncodingMask;
    }

    public ExpandedNodeId getTypeId() {
        return this.typeId;
    }

    public ExtensionObjectEncodingMask getEncodingMask() {
        return this.encodingMask;
    }

    public ExtensionObjectDefinition getBody() {
        return this.body;
    }

    public String getIdentifier() {
        return String.valueOf(this.getTypeId().getIdentifier());
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ExtensionObject", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"typeId", (Object)this.typeId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"encodingMask", (Object)this.encodingMask, (DataWriter)new DataWriterComplexDefault(writeBuffer), (boolean)this.includeEncodingMask, (WithWriterArgs[])new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", (Object)identifier, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"body", (Object)this.body, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ExtensionObject", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        ExtensionObject _value = this;
        lengthInBits += this.typeId.getLengthInBits();
        if (this.encodingMask != null) {
            lengthInBits += this.encodingMask.getLengthInBits();
        }
        return lengthInBits += this.body.getLengthInBits();
    }

    public static ExtensionObject staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean includeEncodingMask;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            includeEncodingMask = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            includeEncodingMask = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return ExtensionObject.staticParse(readBuffer, includeEncodingMask);
    }

    public static ExtensionObject staticParse(ReadBuffer readBuffer, Boolean includeEncodingMask) throws ParseException {
        readBuffer.pullContext("ExtensionObject", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        ExpandedNodeId typeId = (ExpandedNodeId)FieldReaderFactory.readSimpleField((String)"typeId", (DataReader)new DataReaderComplexDefault(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObjectEncodingMask encodingMask = (ExtensionObjectEncodingMask)FieldReaderFactory.readOptionalField((String)"encodingMask", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectEncodingMask.staticParse(readBuffer), readBuffer), (boolean)includeEncodingMask, (WithReaderArgs[])new WithReaderArgs[0]);
        String identifier = (String)FieldReaderFactory.readVirtualField((String)"identifier", String.class, (Object)typeId.getIdentifier(), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObjectDefinition body = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"body", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, identifier), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ExtensionObject", new WithReaderArgs[0]);
        ExtensionObject _extensionObject = new ExtensionObject(typeId, encodingMask, body, includeEncodingMask);
        return _extensionObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionObject)) {
            return false;
        }
        ExtensionObject that = (ExtensionObject)o;
        return this.getTypeId() == that.getTypeId() && this.getEncodingMask() == that.getEncodingMask() && this.getBody() == that.getBody();
    }

    public int hashCode() {
        return Objects.hash(this.getTypeId(), this.getEncodingMask(), this.getBody());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

