/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAcknowledgeResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaCloseRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaHelloRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenResponse;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class MessagePDU
implements Message {
    public abstract String getMessageType();

    public abstract Boolean getResponse();

    protected abstract void serializeMessagePDUChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("MessagePDU", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"messageType", (Object)this.getMessageType(), (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)24), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeMessagePDUChild(writeBuffer);
        writeBuffer.popContext("MessagePDU", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        MessagePDU _value = this;
        return lengthInBits += 24;
    }

    public static MessagePDU staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return MessagePDU.staticParse(readBuffer, response);
    }

    public static MessagePDU staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("MessagePDU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        String messageType = (String)FieldReaderFactory.readDiscriminatorField((String)"messageType", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)24), (WithReaderArgs[])new WithReaderArgs[0]);
        MessagePDUBuilder builder = null;
        if (EvaluationHelper.equals((Object)messageType, (Object)"HEL") && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = OpcuaHelloRequest.staticParseBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)"ACK") && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = OpcuaAcknowledgeResponse.staticParseBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)"OPN") && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = OpcuaOpenRequest.staticParseBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)"OPN") && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = OpcuaOpenResponse.staticParseBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)"CLO") && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = OpcuaCloseRequest.staticParseBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)"MSG") && EvaluationHelper.equals((Object)response, (Object)false)) {
            builder = OpcuaMessageRequest.staticParseBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)"MSG") && EvaluationHelper.equals((Object)response, (Object)true)) {
            builder = OpcuaMessageResponse.staticParseBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [messageType=" + messageType + " response=" + response + "]");
        }
        readBuffer.closeContext("MessagePDU", new WithReaderArgs[0]);
        MessagePDU _messagePDU = builder.build();
        return _messagePDU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessagePDU)) {
            return false;
        }
        MessagePDU that = (MessagePDU)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface MessagePDUBuilder {
        public MessagePDU build();
    }
}

