/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaAPU
implements Message {
    protected final MessagePDU message;
    protected final Boolean response;

    public OpcuaAPU(MessagePDU message, Boolean response) {
        this.message = message;
        this.response = response;
    }

    public MessagePDU getMessage() {
        return this.message;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("OpcuaAPU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"message", (Object)this.message, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        writeBuffer.popContext("OpcuaAPU", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        OpcuaAPU _value = this;
        return lengthInBits += this.message.getLengthInBits();
    }

    public static OpcuaAPU staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return OpcuaAPU.staticParse(readBuffer, response);
    }

    public static OpcuaAPU staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaAPU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        MessagePDU message = (MessagePDU)FieldReaderFactory.readSimpleField((String)"message", (DataReader)new DataReaderComplexDefault(() -> MessagePDU.staticParse(readBuffer, (boolean)response), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        readBuffer.closeContext("OpcuaAPU", new WithReaderArgs[0]);
        OpcuaAPU _opcuaAPU = new OpcuaAPU(message, response);
        return _opcuaAPU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaAPU)) {
            return false;
        }
        OpcuaAPU that = (OpcuaAPU)o;
        return this.getMessage() == that.getMessage();
    }

    public int hashCode() {
        return Objects.hash(this.getMessage());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

