/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.COTPPacket;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class COTPPacketData
extends COTPPacket
implements Message {
    protected final boolean eot;
    protected final short tpduRef;
    protected final Integer cotpLen;

    @Override
    public Short getTpduCode() {
        return (short)240;
    }

    public COTPPacketData(List<COTPParameter> parameters, S7Message payload, boolean eot, short tpduRef, Integer cotpLen) {
        super(parameters, payload, cotpLen);
        this.eot = eot;
        this.tpduRef = tpduRef;
        this.cotpLen = cotpLen;
    }

    public boolean getEot() {
        return this.eot;
    }

    public short getTpduRef() {
        return this.tpduRef;
    }

    @Override
    protected void serializeCOTPPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("COTPPacketData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"eot", (Object)this.eot, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"tpduRef", (Object)this.tpduRef, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("COTPPacketData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        COTPPacketData _value = this;
        ++lengthInBits;
        return lengthInBits += 7;
    }

    public static COTPPacketDataBuilder staticParseBuilder(ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
        readBuffer.pullContext("COTPPacketData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        boolean eot = (Boolean)FieldReaderFactory.readSimpleField((String)"eot", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short tpduRef = (Short)FieldReaderFactory.readSimpleField((String)"tpduRef", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)7), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("COTPPacketData", new WithReaderArgs[0]);
        return new COTPPacketDataBuilder(eot, tpduRef, cotpLen);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPPacketData)) {
            return false;
        }
        COTPPacketData that = (COTPPacketData)o;
        return this.getEot() == that.getEot() && this.getTpduRef() == that.getTpduRef() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEot(), this.getTpduRef());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class COTPPacketDataBuilder
    implements COTPPacket.COTPPacketBuilder {
        private final boolean eot;
        private final short tpduRef;
        private final Integer cotpLen;

        public COTPPacketDataBuilder(boolean eot, short tpduRef, Integer cotpLen) {
            this.eot = eot;
            this.tpduRef = tpduRef;
            this.cotpLen = cotpLen;
        }

        @Override
        public COTPPacketData build(List<COTPParameter> parameters, S7Message payload, Integer cotpLen) {
            COTPPacketData cOTPPacketData = new COTPPacketData(parameters, payload, this.eot, this.tpduRef, cotpLen);
            return cOTPPacketData;
        }
    }
}

