/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.field;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.field.S7Field;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class S7StringField
extends S7Field {
    private final int stringLength;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    protected S7StringField(@JsonProperty(value="dataType") TransportSize dataType, @JsonProperty(value="memoryArea") MemoryArea memoryArea, @JsonProperty(value="blockNumber") int blockNumber, @JsonProperty(value="byteOffset") int byteOffset, @JsonProperty(value="bitOffset") byte bitOffset, @JsonProperty(value="numElements") int numElements, @JsonProperty(value="stringLength") int stringLength) {
        super(dataType, memoryArea, blockNumber, byteOffset, bitOffset, numElements);
        this.stringLength = stringLength;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String memoryArea = this.getMemoryArea().name();
        writeBuffer.writeString("memoryArea", memoryArea.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), memoryArea, new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("blockNumber", 16, this.getBlockNumber(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("byteOffset", 16, this.getByteOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("bitOffset", 8, (int)this.getBitOffset(), new WithWriterArgs[0]);
        writeBuffer.writeUnsignedInt("numElements", 16, this.getNumberOfElements(), new WithWriterArgs[0]);
        writeBuffer.writeInt("stringLength", 64, this.getStringLength(), new WithWriterArgs[0]);
        String dataType = this.getDataType().name();
        writeBuffer.writeString("dataType", dataType.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), dataType, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

