/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.optimizer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7AddressAny;
import org.apache.plc4x.java.s7.readwrite.S7MessageRequest;
import org.apache.plc4x.java.s7.readwrite.S7MessageResponseData;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7ParameterWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadReadVarResponse;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarRequest;
import org.apache.plc4x.java.s7.readwrite.S7PayloadWriteVarResponse;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.s7.readwrite.context.S7DriverContext;
import org.apache.plc4x.java.s7.readwrite.field.S7Field;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.utils.FieldValueItem;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;

public class S7Optimizer
extends BaseOptimizer {
    public static final int EMPTY_READ_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterReadVarRequest(Collections.emptyList()), null).getLengthInBytes();
    public static final int EMPTY_READ_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterReadVarResponse(0), new S7PayloadReadVarResponse(Collections.emptyList(), null), 0, 0).getLengthInBytes();
    public static final int EMPTY_WRITE_REQUEST_SIZE = new S7MessageRequest(0, new S7ParameterWriteVarRequest(Collections.emptyList()), new S7PayloadWriteVarRequest(Collections.emptyList(), null)).getLengthInBytes();
    public static final int EMPTY_WRITE_RESPONSE_SIZE = new S7MessageResponseData(0, new S7ParameterWriteVarResponse(0), new S7PayloadWriteVarResponse(Collections.emptyList(), null), 0, 0).getLengthInBytes();
    public static final int S7_ADDRESS_ANY_SIZE = 2 + new S7AddressAny(TransportSize.INT, 1, 1, MemoryArea.DATA_BLOCKS, 1, 0).getLengthInBytes();

    protected List<PlcRequest> processReadRequest(PlcReadRequest readRequest, DriverContext driverContext) {
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        LinkedList<PlcRequest> processedRequests = new LinkedList<PlcRequest>();
        int curRequestSize = EMPTY_READ_REQUEST_SIZE;
        int curResponseSize = EMPTY_READ_RESPONSE_SIZE;
        LinkedHashMap<String, S7Field> curFields = new LinkedHashMap<String, S7Field>();
        for (String fieldName : readRequest.getFieldNames()) {
            S7Field field = (S7Field)readRequest.getField(fieldName);
            int readRequestItemSize = S7_ADDRESS_ANY_SIZE;
            int readResponseItemSize = 4 + field.getNumberOfElements() * field.getDataType().getSizeInBytes();
            if (readResponseItemSize % 2 == 1) {
                ++readResponseItemSize;
            }
            if (curRequestSize + readRequestItemSize <= s7DriverContext.getPduSize() && curResponseSize + readResponseItemSize <= s7DriverContext.getPduSize()) {
                curRequestSize += readRequestItemSize;
                curResponseSize += readResponseItemSize;
            } else {
                processedRequests.add((PlcRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), curFields));
                curRequestSize = EMPTY_READ_REQUEST_SIZE + readRequestItemSize;
                curResponseSize = EMPTY_READ_RESPONSE_SIZE + readResponseItemSize;
                curFields = new LinkedHashMap();
                if (curRequestSize + readRequestItemSize > s7DriverContext.getPduSize() && curResponseSize + readResponseItemSize > s7DriverContext.getPduSize()) {
                    throw new PlcRuntimeException("Field size exceeds maximum payload for one item.");
                }
            }
            curFields.put(fieldName, field);
        }
        if (!curFields.isEmpty()) {
            processedRequests.add((PlcRequest)new DefaultPlcReadRequest(((DefaultPlcReadRequest)readRequest).getReader(), curFields));
        }
        return processedRequests;
    }

    protected List<PlcRequest> processWriteRequest(PlcWriteRequest writeRequest, DriverContext driverContext) {
        S7DriverContext s7DriverContext = (S7DriverContext)driverContext;
        LinkedList<PlcRequest> processedRequests = new LinkedList<PlcRequest>();
        int curRequestSize = EMPTY_WRITE_REQUEST_SIZE;
        int curResponseSize = EMPTY_WRITE_RESPONSE_SIZE;
        LinkedHashMap<String, FieldValueItem> curFields = new LinkedHashMap<String, FieldValueItem>();
        for (String fieldName : writeRequest.getFieldNames()) {
            S7Field field = (S7Field)writeRequest.getField(fieldName);
            PlcValue value = writeRequest.getPlcValue(fieldName);
            int writeRequestItemSize = S7_ADDRESS_ANY_SIZE + 4;
            writeRequestItemSize = field.getDataType() == TransportSize.BOOL ? (int)((double)writeRequestItemSize + Math.ceil((double)field.getNumberOfElements() / 8.0)) : (writeRequestItemSize += field.getNumberOfElements() * field.getDataType().getSizeInBytes());
            if (writeRequestItemSize % 2 == 1) {
                ++writeRequestItemSize;
            }
            int writeResponseItemSize = 4;
            if (curRequestSize + writeRequestItemSize <= s7DriverContext.getPduSize() && curResponseSize + writeResponseItemSize <= s7DriverContext.getPduSize()) {
                curRequestSize += writeRequestItemSize;
                curResponseSize += writeResponseItemSize;
            } else {
                processedRequests.add((PlcRequest)new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), curFields));
                curRequestSize = EMPTY_WRITE_REQUEST_SIZE + writeRequestItemSize;
                curResponseSize = EMPTY_WRITE_RESPONSE_SIZE + writeResponseItemSize;
                curFields = new LinkedHashMap();
                if (curRequestSize + writeRequestItemSize > s7DriverContext.getPduSize() && curResponseSize + writeResponseItemSize > s7DriverContext.getPduSize()) {
                    throw new PlcRuntimeException("Field size exceeds maximum payload for one item.");
                }
            }
            curFields.put(fieldName, new FieldValueItem((PlcField)field, value));
        }
        if (!curFields.isEmpty()) {
            processedRequests.add((PlcRequest)new DefaultPlcWriteRequest(((DefaultPlcWriteRequest)writeRequest).getWriter(), curFields));
        }
        return processedRequests;
    }
}

