/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.s7.events.S7AlarmEvent;
import org.apache.plc4x.java.s7.events.S7ModeEvent;
import org.apache.plc4x.java.s7.events.S7SysEvent;
import org.apache.plc4x.java.s7.events.S7UserEvent;
import org.apache.plc4x.java.s7.readwrite.EventType;
import org.apache.plc4x.java.s7.readwrite.S7ParameterModeTransition;
import org.apache.plc4x.java.s7.readwrite.S7PayloadDiagnosticMessage;
import org.apache.plc4x.java.s7.readwrite.utils.S7PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7ProtocolEventLogic
implements PlcSubscriber {
    private final Logger logger = LoggerFactory.getLogger(S7ProtocolEventLogic.class);
    private final BlockingQueue eventqueue;
    private final BlockingQueue dispachqueue = new ArrayBlockingQueue(1024);
    private Map<EventType, Map<PlcConsumerRegistration, Consumer>> mapIndex = new HashMap<EventType, Map<PlcConsumerRegistration, Consumer>>();
    private Map<EventType, PlcSubscriptionHandle> eventtypehandles = new HashMap<EventType, PlcSubscriptionHandle>();
    private final Runnable runnProcessor;
    private final Runnable runnDispacher;
    private Thread processor;
    private Thread dispacher;

    public S7ProtocolEventLogic(BlockingQueue eventqueue) {
        this.eventqueue = eventqueue;
        this.runnProcessor = new ObjectProcessor(eventqueue, this.dispachqueue);
        this.runnDispacher = new EventDispacher(this.dispachqueue);
        this.processor = new Thread(this.runnProcessor);
        this.dispacher = new Thread(this.runnDispacher);
    }

    public void start() {
        this.processor.start();
        this.dispacher.start();
    }

    public void stop() {
        ((ObjectProcessor)this.runnProcessor).doShutdown();
        ((EventDispacher)this.runnDispacher).doShutdown();
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        Map<Object, Object> mapConsumers = null;
        S7PlcSubscriptionHandle handle = (S7PlcSubscriptionHandle)((Object)handles.toArray()[0]);
        if (!this.mapIndex.containsKey((Object)handle.getEventType())) {
            mapConsumers = new HashMap();
            this.mapIndex.put(handle.getEventType(), mapConsumers);
        }
        mapConsumers = this.mapIndex.get((Object)handle.getEventType());
        DefaultPlcConsumerRegistration registro = new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new PlcSubscriptionHandle[handles.size()]));
        mapConsumers.put(registro, consumer);
        return registro;
    }

    public void unregister(PlcConsumerRegistration registration) {
        S7PlcSubscriptionHandle handle = (S7PlcSubscriptionHandle)((Object)registration.getSubscriptionHandles().get(0));
        Map<PlcConsumerRegistration, Consumer> mapConsumers = this.mapIndex.get((Object)handle.getEventType());
        mapConsumers.remove(registration);
    }

    private class ObjectProcessor
    implements Runnable {
        private final BlockingQueue eventqueue;
        private final BlockingQueue dispathqueue;
        private boolean shutdown = false;
        private int delay = 5000;

        public ObjectProcessor(BlockingQueue eventqueue, BlockingQueue dispathqueue) {
            this.eventqueue = eventqueue;
            this.dispathqueue = dispathqueue;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Object obj = this.eventqueue.poll(this.delay, TimeUnit.MILLISECONDS);
                    if (obj == null) continue;
                    if (obj instanceof S7ParameterModeTransition) {
                        S7ModeEvent modeEvent = new S7ModeEvent((S7ParameterModeTransition)obj);
                        this.dispathqueue.add(modeEvent);
                        continue;
                    }
                    if (obj instanceof S7PayloadDiagnosticMessage) {
                        S7PayloadDiagnosticMessage msg = (S7PayloadDiagnosticMessage)obj;
                        if (msg.getEventId() >= 40960 & msg.getEventId() <= 49151) {
                            S7UserEvent userevent = new S7UserEvent(msg);
                            this.dispathqueue.add(userevent);
                            continue;
                        }
                        S7SysEvent sysevent = new S7SysEvent(msg);
                        this.dispathqueue.add(sysevent);
                        continue;
                    }
                    S7AlarmEvent alarmevent = new S7AlarmEvent(obj);
                    this.dispathqueue.add(alarmevent);
                }
                catch (InterruptedException ex) {
                    java.util.logging.Logger.getLogger(S7ProtocolEventLogic.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            System.out.println("ObjectProcessor Bye!");
        }

        public void doShutdown() {
            this.shutdown = true;
        }
    }

    private class EventDispacher
    implements Runnable {
        private final BlockingQueue dispachqueue;
        private boolean shutdown = false;
        private int delay = 5000;

        public EventDispacher(BlockingQueue dispachqueue) {
            this.dispachqueue = dispachqueue;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Map mapConsumers;
                    Object obj = this.dispachqueue.poll(this.delay, TimeUnit.MILLISECONDS);
                    if (obj == null) continue;
                    if (obj instanceof S7ModeEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.MODE)) continue;
                        mapConsumers = (Map)S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.MODE);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (obj instanceof S7UserEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.USR)) continue;
                        mapConsumers = (Map)S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.USR);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (obj instanceof S7SysEvent) {
                        if (!S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.SYS)) continue;
                        mapConsumers = (Map)S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.SYS);
                        mapConsumers.forEach((x, y) -> y.accept(obj));
                        continue;
                    }
                    if (!(obj instanceof S7AlarmEvent) || !S7ProtocolEventLogic.this.mapIndex.containsKey((Object)EventType.ALM)) continue;
                    mapConsumers = (Map)S7ProtocolEventLogic.this.mapIndex.get((Object)EventType.ALM);
                    mapConsumers.forEach((x, y) -> y.accept(obj));
                }
                catch (Exception ex) {
                    java.util.logging.Logger.getLogger(S7ProtocolEventLogic.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            System.out.println("EventDispacher Bye!");
        }

        public void doShutdown() {
            this.shutdown = true;
        }
    }
}

