/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.utils;

import java.util.HashMap;
import java.util.Map;

public enum S7ParamErrorCode {
    ERROR_0x0000(0, "No error"),
    ERROR_0x0110(272, "Invalid block number"),
    ERROR_0x0111(273, "Invalid request length"),
    ERROR_0x0112(274, "Invalid parameter"),
    ERROR_0x0113(275, "Invalid block type"),
    ERROR_0x0114(276, "Block not found"),
    ERROR_0x0115(277, "Block already exists"),
    ERROR_0x0116(278, "Block is write-protected"),
    ERROR_0x0117(279, "The block/operating system update is too large"),
    ERROR_0x0118(280, "Invalid block number"),
    ERROR_0x0119(281, "Incorrect password entered"),
    ERROR_0x011A(282, "PG resource error"),
    ERROR_0x011B(283, "PLC resource error"),
    ERROR_0x011C(284, "Protocol error"),
    ERROR_0x011D(285, "Too many blocks (module-related restriction)"),
    ERROR_0x011E(286, "There is no longer a connection to the database, or S7DOS handle is invalid"),
    ERROR_0x011F(287, "Result buffer too small"),
    ERROR_0x0120(288, "End of block list"),
    ERROR_0x0140(320, "Insufficient memory available"),
    ERROR_0x0141(321, "Job cannot be processed because of a lack of resources"),
    ERROR_0x8001(-32767, "The requested service cannot be performed while the block is in the current status"),
    ERROR_0x8003(-32765, "S7 protocol error: Error occurred while transferring the block"),
    ERROR_0x8100(-32512, "Application, general error: Service unknown to remote module"),
    ERROR_0x8104(-32508, "This service is not implemented on the module or a frame error was reported"),
    ERROR_0x8204(-32252, "The type specification for the object is inconsistent"),
    ERROR_0x8205(-32251, "A copied block already exists and is not linked"),
    ERROR_0x8301(-31999, "Insufficient memory space or work memory on the module, or specified storage medium not accessible"),
    ERROR_0x8302(-31998, "Too few resources available or the processor resources are not available"),
    ERROR_0x8304(-31996, "No further parallel upload possible. There is a resource bottleneck"),
    ERROR_0x8305(-31995, "Function not available"),
    ERROR_0x8306(-31994, "Insufficient work memory (for copying, linking, loading AWP)"),
    ERROR_0x8307(-31993, "Not enough retentive work memory (for copying, linking, loading AWP)"),
    ERROR_0x8401(-31743, "S7 protocol error: Invalid service sequence (for example, loading or uploading a block)"),
    ERROR_0x8402(-31742, "Service cannot execute owing to status of the addressed object"),
    ERROR_0x8404(-31740, "S7 protocol: The function cannot be performed"),
    ERROR_0x8405(-31739, "Remote block is in DISABLE state (CFB). The function cannot be performed"),
    ERROR_0x8500(-31488, "S7 protocol error: Wrong frames"),
    ERROR_0x8503(-31485, "Alarm from the module: Service canceled prematurely"),
    ERROR_0x8701(-30975, "Error addressing the object on the communications partner (for example, area length error)"),
    ERROR_0x8702(-30974, "The requested service is not supported by the module"),
    ERROR_0x8703(-30973, "Access to object refused"),
    ERROR_0x8704(-30972, "Access error: Object damaged"),
    ERROR_0xD001(-12287, "Protocol error: Illegal job number"),
    ERROR_0xD002(-12286, "Parameter error: Illegal job variant"),
    ERROR_0xD003(-12285, "Parameter error: Debugging function not supported by module"),
    ERROR_0xD004(-12284, "Parameter error: Illegal job status"),
    ERROR_0xD005(-12283, "Parameter error: Illegal job termination"),
    ERROR_0xD006(-12282, "Parameter error: Illegal link disconnection ID"),
    ERROR_0xD007(-12281, "Parameter error: Illegal number of buffer elements"),
    ERROR_0xD008(-12280, "Parameter error: Illegal scan rate"),
    ERROR_0xD009(-12279, "Parameter error: Illegal number of executions"),
    ERROR_0xD00A(-12278, "Parameter error: Illegal trigger event"),
    ERROR_0xD00B(-12277, "Parameter error: Illegal trigger condition"),
    ERROR_0xD011(-12271, "Parameter error in path of the call environment: Block does not exist"),
    ERROR_0xD012(-12270, "Parameter error: Wrong address in block"),
    ERROR_0xD014(-12268, "Parameter error: Block being deleted/overwritten"),
    ERROR_0xD015(-12267, "Parameter error: Illegal tag address"),
    ERROR_0xD016(-12266, "Parameter error: Test jobs not possible, because of errors in user program"),
    ERROR_0xD017(-12265, "Parameter error: Illegal trigger number"),
    ERROR_0xD025(-12251, "Parameter error: Invalid path"),
    ERROR_0xD026(-12250, "Parameter error: Illegal access type"),
    ERROR_0xD027(-12249, "Parameter error: This number of data blocks is not permitted"),
    ERROR_0xD031(-12239, "Internal protocol error"),
    ERROR_0xD032(-12238, "Parameter error: Wrong result buffer length"),
    ERROR_0xD033(-12237, "Protocol error: Wrong job length"),
    ERROR_0xD03F(-12225, "Coding error: Error in parameter section (for example, reserve bytes not equal to 0)"),
    ERROR_0xD041(-12223, "Data error: Illegal status list ID"),
    ERROR_0xD042(-12222, "Data error: Illegal tag address"),
    ERROR_0xD043(-12221, "Data error: Referenced job not found, check job data"),
    ERROR_0xD044(-12220, "Data error: Illegal tag value, check job data"),
    ERROR_0xD045(-12219, "Data error: Exiting the ODIS control is not allowed in HOLD"),
    ERROR_0xD046(-12218, "Data error: Illegal measuring stage during run-time measurement"),
    ERROR_0xD047(-12217, "Data error: Illegal hierarchy in 'Read job list'"),
    ERROR_0xD048(-12216, "Data error: Illegal deletion ID in 'Delete job'"),
    ERROR_0xD049(-12215, "Invalid substitute ID in 'Replace job'"),
    ERROR_0xD04A(-12214, "Error executing 'program status'"),
    ERROR_0xD05F(-12193, "Coding error: Error in data section (for example, reserve bytes not equal to 0, ...)"),
    ERROR_0xD061(-12191, "Resource error: No memory space for job"),
    ERROR_0xD062(-12190, "Resource error: Job list full"),
    ERROR_0xD063(-12189, "Resource error: Trigger event occupied"),
    ERROR_0xD064(-12188, "Resource error: Not enough memory space for one result buffer element"),
    ERROR_0xD065(-12187, "Resource error: Not enough memory space for several  result buffer elements"),
    ERROR_0xD066(-12186, "Resource error: The timer available for run-time measurement is occupied by another job"),
    ERROR_0xD067(-12185, "Resource error: Too many 'modify tag' jobs active (in particular multi-processor operation)"),
    ERROR_0xD081(-12159, "Function not permitted in current mode"),
    ERROR_0xD082(-12158, "Mode error: Cannot exit HOLD mode"),
    ERROR_0xD0A1(-12127, "Function not permitted in current protection level"),
    ERROR_0xD0A2(-12126, "Function not possible at present, because a function is running that modifies memory"),
    ERROR_0xD0A3(-12125, "Too many 'modify tag' jobs active on the I/O (in particular multi-processor operation)"),
    ERROR_0xD0A4(-12124, "Forcing' has already been established"),
    ERROR_0xD0A5(-12123, "Referenced job not found"),
    ERROR_0xD0A6(-12122, "Job cannot be disabled/enabled"),
    ERROR_0xD0A7(-12121, "Job cannot be deleted, for example because it is currently being read"),
    ERROR_0xD0A8(-12120, "Job cannot be replaced, for example because it is currently being read or deleted"),
    ERROR_0xD0A9(-12119, "Job cannot be read, for example because it is currently being deleted"),
    ERROR_0xD0AA(-12118, "Time limit exceeded in processing operation"),
    ERROR_0xD0AB(-12117, "Invalid job parameters in process operation"),
    ERROR_0xD0AC(-12116, "Invalid job data in process operation"),
    ERROR_0xD0AD(-12115, "Operating mode already set"),
    ERROR_0xD0AE(-12114, "The job was set up over a different connection and can only be handled over this connection"),
    ERROR_0xD0C1(-12095, "At least one error has been detected while accessing the tag(s)"),
    ERROR_0xD0C2(-12094, "Change to STOP/HOLD mode"),
    ERROR_0xD0C3(-12093, "At least one error was detected while accessing the tag(s). Mode change to STOP/HOLD"),
    ERROR_0xD0C4(-12092, "Timeout during run-time measurement"),
    ERROR_0xD0C5(-12091, "Display of block stack inconsistent, because blocks were deleted/reloaded"),
    ERROR_0xD0C6(-12090, "Job was automatically deleted as the jobs it referenced have been deleted"),
    ERROR_0xD0C7(-12089, "The job was automatically deleted because STOP mode was exited"),
    ERROR_0xD0C8(-12088, "Block status' aborted because of inconsistencies between test job and running program"),
    ERROR_0xD0C9(-12087, "Exit the status area by resetting OB90"),
    ERROR_0xD0CA(-12086, "Exiting the status range by resetting OB90 and access error reading tags before exiting"),
    ERROR_0xD0CB(-12085, "The output disable for the peripheral outputs has been activated again"),
    ERROR_0xD0CC(-12084, "The amount of data for the debugging functions is restricted by the time limit"),
    ERROR_0xD201(-11775, "Syntax error in block name"),
    ERROR_0xD202(-11774, "Syntax error in function parameters"),
    ERROR_0xD205(-11771, "Linked block already exists in RAM: Conditional copying is not possible"),
    ERROR_0xD206(-11770, "Linked block already exists in EPROM: Conditional copying is not possible"),
    ERROR_0xD208(-11768, "Maximum number of copied (not linked) blocks on module exceeded"),
    ERROR_0xD209(-11767, "(At least) one of the given blocks not found on the module"),
    ERROR_0xD20A(-11766, "The maximum number of blocks that can be linked with one job was exceeded"),
    ERROR_0xD20B(-11765, "The maximum number of blocks that can be deleted with one job was exceeded"),
    ERROR_0xD20C(-11764, "OB cannot be copied because the associated priority class does not exist"),
    ERROR_0xD20D(-11763, "SDB cannot be interpreted (for example, unknown number)"),
    ERROR_0xD20E(-11762, "No (further) block available"),
    ERROR_0xD20F(-11761, "Module-specific maximum block size exceeded"),
    ERROR_0xD210(-11760, "Invalid block number"),
    ERROR_0xD212(-11758, "Incorrect header attribute (run-time relevant)"),
    ERROR_0xD213(-11757, "Too many SDBs. Note the restrictions on the module being used"),
    ERROR_0xD216(-11754, "Invalid user program - reset module"),
    ERROR_0xD217(-11753, "Protection level specified in module properties not permitted"),
    ERROR_0xD218(-11752, "Incorrect attribute (active/passive)"),
    ERROR_0xD219(-11751, "Incorrect block lengths (for example, incorrect length of first section or of the whole block)"),
    ERROR_0xD21A(-11750, "Incorrect local data length or write-protection code faulty"),
    ERROR_0xD21B(-11749, "Module cannot compress or compression was interrupted early"),
    ERROR_0xD21D(-11747, "The volume of dynamic project data transferred is illegal"),
    ERROR_0xD21E(-11746, "Unable to assign parameters to a module (such as FM, CP). The system data could not be linked"),
    ERROR_0xD220(-11744, "Invalid programming language. Note the restrictions on the module being used"),
    ERROR_0xD221(-11743, "The system data for connections or routing are not valid"),
    ERROR_0xD222(-11742, "The system data of the global data definition contain invalid parameters"),
    ERROR_0xD223(-11741, "Error in instance data block for communication function block or maximum number of instance DBs exceeded"),
    ERROR_0xD224(-11740, "The SCAN system data block contains invalid parameters"),
    ERROR_0xD225(-11739, "The DP system data block contains invalid parameters"),
    ERROR_0xD226(-11738, "A structural error occurred in a block"),
    ERROR_0xD230(-11728, "A structural error occurred in a block"),
    ERROR_0xD231(-11727, "At least one loaded OB cannot be copied because the associated priority class does not exist"),
    ERROR_0xD232(-11726, "At least one block number of a loaded block is illegal"),
    ERROR_0xD234(-11724, "Block exists twice in the specified memory medium or in the job"),
    ERROR_0xD235(-11723, "The block contains an incorrect checksum"),
    ERROR_0xD236(-11722, "The block does not contain a checksum"),
    ERROR_0xD237(-11721, "You are about to load the block twice, i.e. a block with the same time stamp already exists on the CPU"),
    ERROR_0xD238(-11720, "At least one of the blocks specified is not a DB"),
    ERROR_0xD239(-11719, "At least one of the DBs specified is not available as a linked variant in the load memory"),
    ERROR_0xD23A(-11718, "At least one of the specified DBs is considerably different from the copied and linked variant"),
    ERROR_0xD240(-11712, "Coordination rules violated"),
    ERROR_0xD241(-11711, "The function is not permitted in the current protection level"),
    ERROR_0xD242(-11710, "Protection violation while processing F blocks"),
    ERROR_0xD250(-11696, "Update and module ID or version do not match"),
    ERROR_0xD251(-11695, "Incorrect sequence of operating system components"),
    ERROR_0xD252(-11694, "Checksum error"),
    ERROR_0xD253(-11693, "No executable loader available; update only possible using a memory card"),
    ERROR_0xD254(-11692, "Storage error in operating system"),
    ERROR_0xD280(-11648, "Error compiling block in S7-300 CPU"),
    ERROR_0xD2A1(-11615, "Another block function or a trigger on a block is active"),
    ERROR_0xD2A2(-11614, "A trigger is active on a block. Complete the debugging function first"),
    ERROR_0xD2A3(-11613, "The block is not active (linked), the block is occupied or the block is currently marked for deletion"),
    ERROR_0xD2A4(-11612, "The block is already being processed by another block function"),
    ERROR_0xD2A6(-11610, "It is not possible to save and change the user program simultaneously"),
    ERROR_0xD2A7(-11609, "The block has the attribute 'unlinked' or is not processed"),
    ERROR_0xD2A8(-11608, "An active debugging function is preventing parameters from being assigned to the CPU"),
    ERROR_0xD2A9(-11607, "New parameters are being assigned to the CPU"),
    ERROR_0xD2AA(-11606, "New parameters are currently being assigned to the modules"),
    ERROR_0xD2AB(-11605, "The dynamic configuration limits are currently being changed"),
    ERROR_0xD2AC(-11604, "A running active or deactivate assignment (SFC 12) is temporarily preventing R-KiR process"),
    ERROR_0xD2B0(-11600, "An error occurred while configuring in RUN (CiR)"),
    ERROR_0xD2C0(-11584, "The maximum number of technological objects has been exceeded"),
    ERROR_0xD2C1(-11583, "The same technology data block already exists on the module"),
    ERROR_0xD2C2(-11582, "Downloading the user program or downloading the hardware configuration is not possible"),
    ERROR_0xD401(-11263, "Information function unavailable"),
    ERROR_0xD402(-11262, "Information function unavailable"),
    ERROR_0xD403(-11261, "Service has already been logged on/off (Diagnostics/PMC)"),
    ERROR_0xD404(-11260, "Maximum number of nodes reached. No more logons possible for diagnostics/PMC"),
    ERROR_0xD405(-11259, "Service not supported or syntax error in function parameters"),
    ERROR_0xD406(-11258, "Required information currently unavailable"),
    ERROR_0xD407(-11257, "Diagnostics error occurred"),
    ERROR_0xD408(-11256, "Update aborted"),
    ERROR_0xD409(-11255, "Error on DP bus"),
    ERROR_0xD601(-10751, "Syntax error in function parameter"),
    ERROR_0xD602(-10750, "Incorrect password entered"),
    ERROR_0xD603(-10749, "The connection has already been legitimized"),
    ERROR_0xD604(-10748, "The connection has already been enabled"),
    ERROR_0xD605(-10747, "Legitimization not possible because password does not exist"),
    ERROR_0xD801(-10239, "At least one tag address is invalid"),
    ERROR_0xD802(-10238, "Specified job does not exist"),
    ERROR_0xD803(-10237, "Illegal job status"),
    ERROR_0xD804(-10236, "Illegal cycle time (illegal time base or multiple)"),
    ERROR_0xD805(-10235, "No more cyclic read jobs can be set up"),
    ERROR_0xD806(-10234, "The referenced job is in a state in which the requested function cannot be performed"),
    ERROR_0xD807(-10233, "Function aborted due to overload, meaning executing the read cycle takes longer than the set scan cycle time"),
    ERROR_0xDC01(-9215, "Date and/or time invalid"),
    ERROR_0xE201(-7679, "CPU is already the master"),
    ERROR_0xE202(-7678, "Connect and update not possible due to different user program in flash module"),
    ERROR_0xE203(-7677, "Connect and update not possible due to different firmware"),
    ERROR_0xE204(-7676, "Connect and update not possible due to different memory configuration"),
    ERROR_0xE205(-7675, "Connect/update aborted due to synchronization error"),
    ERROR_0xE206(-7674, "Connect/update denied due to coordination violation"),
    ERROR_0xEF01(-4351, "S7 protocol error: Error at ID2; only 00H permitted in job"),
    ERROR_0xEF02(-4350, "S7 protocol error: Error at ID2; set of resources does not exist");

    private static final Map<Short, S7ParamErrorCode> map;
    private final String event;
    private final short code;

    private S7ParamErrorCode(short code, String event) {
        this.event = event;
        this.code = code;
    }

    public String getEvent() {
        return this.event;
    }

    public short getCode() {
        return this.code;
    }

    public static S7ParamErrorCode valueOfEvent(String event) {
        for (S7ParamErrorCode value : S7ParamErrorCode.values()) {
            if (!value.getEvent().equals(event)) continue;
            return value;
        }
        return null;
    }

    public static S7ParamErrorCode valueOf(short code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Short, S7ParamErrorCode>();
        for (S7ParamErrorCode subevent : S7ParamErrorCode.values()) {
            map.put(subevent.code, subevent);
        }
    }
}

