/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.field;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.EnumUtils;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.simulated.readwrite.SimulatedDataTypeSizes;
import org.apache.plc4x.java.simulated.types.SimulatedFieldType;

public class SimulatedField
implements PlcField {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(?<type>\\w+)/(?<name>[a-zA-Z0-9_\\\\.]+):(?<dataType>[a-zA-Z0-9]++)(\\[(?<numElements>\\d+)])?$");
    private final SimulatedFieldType type;
    private final String name;
    private final SimulatedDataTypeSizes dataType;
    private final int numElements;

    private SimulatedField(SimulatedFieldType type, String name, SimulatedDataTypeSizes dataType, int numElements) {
        this.type = type;
        this.name = name;
        this.dataType = dataType;
        this.numElements = numElements;
    }

    public static SimulatedField of(String fieldString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(fieldString);
        if (matcher.matches()) {
            String dataType;
            SimulatedFieldType type = SimulatedFieldType.valueOf(matcher.group("type"));
            String name = matcher.group("name");
            switch (matcher.group("dataType").toUpperCase()) {
                case "INTEGER": {
                    dataType = "DINT";
                    break;
                }
                case "BYTE": {
                    dataType = "BYTE";
                    break;
                }
                case "SHORT": {
                    dataType = "INT";
                    break;
                }
                case "LONG": {
                    dataType = "LINT";
                    break;
                }
                case "FLOAT": {
                    dataType = "REAL";
                    break;
                }
                case "DOUBLE": {
                    dataType = "LREAL";
                    break;
                }
                case "BOOLEAN": {
                    dataType = "BOOL";
                    break;
                }
                default: {
                    dataType = matcher.group("dataType").toUpperCase();
                }
            }
            if (!EnumUtils.isValidEnum(SimulatedDataTypeSizes.class, (String)dataType)) {
                throw new PlcInvalidFieldException("Invalid data type: " + dataType);
            }
            int numElements = 1;
            if (matcher.group("numElements") != null) {
                numElements = Integer.parseInt(matcher.group("numElements"));
            }
            return new SimulatedField(type, name, SimulatedDataTypeSizes.valueOf(dataType), numElements);
        }
        throw new PlcInvalidFieldException("Unable to parse address: " + fieldString);
    }

    static boolean matches(String fieldString) {
        return ADDRESS_PATTERN.matcher(fieldString).matches();
    }

    public SimulatedFieldType getType() {
        return this.type;
    }

    public String getPlcDataType() {
        return this.dataType.name();
    }

    public String getName() {
        return this.name;
    }

    public SimulatedDataTypeSizes getDataType() {
        return this.dataType;
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulatedField testField = (SimulatedField)o;
        return this.numElements == testField.numElements && this.type == testField.type && Objects.equals(this.name, testField.name) && Objects.equals((Object)this.dataType, (Object)testField.dataType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.dataType, this.numElements});
    }

    public String toString() {
        return "TestField{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", dataType='" + (Object)((Object)this.dataType) + '\'' + ", numElements=" + this.numElements + '}';
    }
}

