/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.simulated.readwrite;

import java.math.BigInteger;
import java.util.LinkedList;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, String dataType, Integer numberOfValues) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcBOOL> value = new LinkedList<PlcBOOL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcBOOL(Boolean.valueOf(readBuffer.readBit("", new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUINT> value = new LinkedList<PlcUINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUINT(Short.valueOf(readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WORD")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUDINT> value = new LinkedList<PlcUDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUDINT(Integer.valueOf(readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcULINT> value = new LinkedList<PlcULINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcULINT(Long.valueOf(readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLINT(readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"SINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"SINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSINT> value = new LinkedList<PlcSINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSINT(Byte.valueOf(readBuffer.readSignedByte("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"INT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"INT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcINT> value = new LinkedList<PlcINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcINT(Short.valueOf(readBuffer.readShort("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"DINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcDINT> value = new LinkedList<PlcDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcDINT(Integer.valueOf(readBuffer.readInt("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLINT(Long.valueOf(readBuffer.readLong("", 64, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"USINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"USINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUINT> value = new LinkedList<PlcUINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUINT(Short.valueOf(readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcUDINT> value = new LinkedList<PlcUDINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcUDINT(Integer.valueOf(readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcULINT> value = new LinkedList<PlcULINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcULINT(Long.valueOf(readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLINT> value = new LinkedList<PlcLINT>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLINT(readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"REAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"REAL")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcREAL> value = new LinkedList<PlcREAL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcREAL(Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcLREAL> value = new LinkedList<PlcLREAL>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcLREAL(Double.valueOf(readBuffer.readDouble("", 64, new WithReaderArgs[0]))));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            String value = readBuffer.readString("", 8, "UTF-8", new WithReaderArgs[0]);
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSTRING> value = new LinkedList<PlcSTRING>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSTRING(readBuffer.readString("", 8, "UTF-8", new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            String value = readBuffer.readString("", 16, "UTF-16", new WithReaderArgs[0]);
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR")) {
            if (numberOfValues > Integer.MAX_VALUE) {
                throw new ParseException("Array count of " + numberOfValues + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
            }
            int itemCount = numberOfValues;
            LinkedList<PlcSTRING> value = new LinkedList<PlcSTRING>();
            for (int curItem = 0; curItem < itemCount; ++curItem) {
                value.add(new PlcSTRING(readBuffer.readString("", 16, "UTF-16", new WithReaderArgs[0])));
            }
            return new PlcList(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"STRING")) {
            String value = readBuffer.readString("", 255, "UTF-8", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)"WSTRING")) {
            String value = readBuffer.readString("", 255, "UTF-16", new WithReaderArgs[0]);
            return new PlcSTRING(value);
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataType, Integer numberOfValues) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, numberOfValues, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataType, Integer numberOfValues, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Boolean value = val.getBoolean();
                writeBuffer.writeBit("", value.booleanValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Short value = val.getShort();
                writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WORD")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Integer value = val.getInteger();
                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Long value = val.getLong();
                writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                BigInteger value = val.getBigInteger();
                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"SINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"SINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Byte value = val.getByte();
                writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"INT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"INT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Short value = val.getShort();
                writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Integer value = val.getInteger();
                writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Long value = val.getLong();
                writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"USINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"USINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Short value = val.getShort();
                writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Integer value = val.getInteger();
                writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Long value = val.getLong();
                writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                BigInteger value = val.getBigInteger();
                writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"REAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"REAL")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Float value = Float.valueOf(val.getFloat());
                writeBuffer.writeFloat("", 32, value.floatValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                Double value = val.getDouble();
                writeBuffer.writeDouble("", 64, value.doubleValue(), new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            String value = _value.getString();
            writeBuffer.writeString("", 8, "UTF-8", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                String value = val.getString();
                writeBuffer.writeString("", 8, "UTF-8", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            String value = _value.getString();
            writeBuffer.writeString("", 16, "UTF-16", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR")) {
            PlcList values = (PlcList)_value;
            for (PlcValue val : values.getList()) {
                String value = val.getString();
                writeBuffer.writeString("", 16, "UTF-16", value, new WithWriterArgs[0]);
            }
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"STRING")) {
            String value = _value.getString();
            writeBuffer.writeString("", 255, "UTF-8", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WSTRING")) {
            String value = _value.getString();
            writeBuffer.writeString("", 255, "UTF-16", value, new WithWriterArgs[0]);
        }
    }

    public static int getLengthInBytes(PlcValue _value, String dataType, Integer numberOfValues) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType, numberOfValues) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, String dataType, Integer numberOfValues) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"BOOL")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 1;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"BYTE")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WORD")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DWORD")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LWORD")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"SINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"SINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"INT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"INT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"DINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"USINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"USINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"UDINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"ULINT")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"REAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"REAL")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"LREAL")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"CHAR")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR") && EvaluationHelper.equals((Object)numberOfValues, (Object)1)) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WCHAR")) {
            PlcList values = (PlcList)_value;
            sizeInBits += values.getList().size() * 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"STRING")) {
            sizeInBits += 255;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)"WSTRING")) {
            sizeInBits += 255;
        }
        return sizeInBits;
    }
}

