/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.rawsocket;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.transport.rawsocket.RawSocketChannelFactory;
import org.apache.plc4x.java.transport.rawsocket.RawSocketTransportConfiguration;

public class RawSocketTransport
implements Transport,
HasConfiguration<RawSocketTransportConfiguration> {
    private static final Pattern TRANSPORT_RAW_SOCKET_PATTERN = Pattern.compile("^((?<ip>[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})|(?<hostname>[a-zA-Z0-9.\\-]+))(:(?<port>[0-9]{1,5}))?");
    public static final String TRANSPORT_CODE = "raw";
    private RawSocketTransportConfiguration configuration;

    public String getTransportCode() {
        return TRANSPORT_CODE;
    }

    public String getTransportName() {
        return "Raw Ethernet Transport";
    }

    public void setConfiguration(RawSocketTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory createChannelFactory(String transportConfig) {
        int port;
        Matcher matcher = TRANSPORT_RAW_SOCKET_PATTERN.matcher(transportConfig);
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Invalid url for TCP transport");
        }
        String ip = matcher.group("ip");
        String hostname = matcher.group("hostname");
        String portString = matcher.group("port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        } else if (this.configuration != null && this.configuration.getDefaultPort() != -1) {
            port = this.configuration.getDefaultPort();
        } else {
            throw new PlcRuntimeException("No port defined");
        }
        InetSocketAddress address = new InetSocketAddress(ip == null ? hostname : ip, port);
        return new RawSocketChannelFactory(address);
    }
}

