/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.serial;

import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.plc4x.java.transport.serial.SerialSelectionKey;
import org.apache.plc4x.java.transport.serial.SerialSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SerialPollingSelector
extends AbstractSelector {
    private static final Logger logger = LoggerFactory.getLogger(SerialPollingSelector.class);
    private final List<SelectionKey> registeredChannels;
    private final Set<SelectorEvent> events = ConcurrentHashMap.newKeySet();
    private final DefaultEventExecutor executor = new DefaultEventExecutor();
    private DefaultPromise<Void> selectPromise;

    public SerialPollingSelector(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.registeredChannels = new ArrayList<SelectionKey>();
    }

    @Override
    public Set<SelectionKey> keys() {
        return new HashSet<SelectionKey>(this.registeredChannels);
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.events.stream().map(SelectorEvent::getKey).collect(Collectors.toSet());
    }

    @Override
    public int selectNow() {
        logger.debug("selectNow()");
        return this.events.size();
    }

    @Override
    public int select(long timeout) {
        if (!this.events.isEmpty()) {
            return this.events.size();
        }
        this.selectPromise = new DefaultPromise((EventExecutor)this.executor);
        try {
            if (timeout == 0L) {
                this.selectPromise.await();
            } else {
                this.selectPromise.await(timeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Was interrupted", e);
        }
        int eventCount = this.events.size();
        logger.debug("returning from select with {} events", (Object)eventCount);
        return eventCount;
    }

    @Override
    public int select() {
        return this.select(0L);
    }

    @Override
    public Selector wakeup() {
        logger.debug("being asked to wake up from select");
        if (!this.selectPromise.isDone()) {
            this.selectPromise.setSuccess(null);
        }
        return this;
    }

    public void addEvent(SelectorEvent event) {
        logger.debug("Adding Event to Selector, canceling Promise...");
        this.events.add(event);
        ((SerialSelectionKey)event.key).addReadyOp(event.event);
        if (!this.selectPromise.isDone()) {
            this.selectPromise.setSuccess(null);
        } else {
            logger.debug("Promise is already cancelled, skipping that.");
        }
    }

    public void removeEvent(SerialSelectionKey serialSelectionKey) {
        this.events.removeIf(event -> ((SelectorEvent)event).key.equals(serialSelectionKey));
    }

    @Override
    protected void implCloseSelector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        logger.debug("Registering Channel for selector {} with operations {}", (Object)ch, (Object)ops);
        if (!(ch instanceof SerialSocketChannel)) {
            throw new IllegalArgumentException("Given channel has to be of type " + SerialSocketChannel.class);
        }
        SerialSelectionKey key = new SerialSelectionKey(ch, this, ops);
        key.attach(att);
        SerialPollingSelector serialPollingSelector = this;
        synchronized (serialPollingSelector) {
            int index = this.registeredChannels.size();
            this.registeredChannels.add(key);
            key.setIndex(index);
        }
        return key;
    }

    public static class SelectorEvent {
        private final SelectionKey key;
        private final int event;

        public SelectorEvent(SelectionKey key, int event) {
            this.key = key;
            this.event = event;
        }

        public SelectionKey getKey() {
            return this.key;
        }

        public int getEvent() {
            return this.event;
        }
    }
}

