/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.SocketAddress;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.NettyChannelFactory;
import org.apache.plc4x.java.transport.udp.UdpTransportConfiguration;
import org.apache.plc4x.java.transport.udp.protocol.DatagramUnpackingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpChannelFactory
extends NettyChannelFactory
implements HasConfiguration<UdpTransportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(UdpChannelFactory.class);
    private UdpTransportConfiguration configuration;

    public UdpChannelFactory(SocketAddress address) {
        super(address);
    }

    public void setConfiguration(UdpTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public Class<? extends Channel> getChannel() {
        return NioDatagramChannel.class;
    }

    public boolean isPassive() {
        return false;
    }

    public void configureBootstrap(Bootstrap bootstrap) {
        if (this.configuration != null) {
            logger.info("Configuring Bootstrap with {}", (Object)this.configuration);
        }
    }

    public void initializePipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new DatagramUnpackingHandler()});
    }
}

