/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.rawsockets.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.oio.OioByteStreamChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.plc4x.java.utils.pcap.netty.exception.PcapException;
import org.apache.plc4x.java.utils.rawsockets.netty.address.RawSocketPassiveAddress;
import org.apache.plc4x.java.utils.rawsockets.netty.config.RawSocketChannelConfig;
import org.apache.plc4x.java.utils.rawsockets.netty.utils.ArpUtils;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapIpV4Address;
import org.pcap4j.core.PcapIpV6Address;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSocketChannel
extends OioByteStreamChannel {
    private static final Logger logger = LoggerFactory.getLogger(RawSocketChannel.class);
    private final RawSocketChannelConfig config = new RawSocketChannelConfig((Channel)this);
    private MacAddress remoteMacAddress;
    private SocketAddress remoteAddress;
    private MacAddress localMacAddress;
    private SocketAddress localAddress;
    private PcapHandle receiveHandle;
    private Thread loopThread;

    public RawSocketChannel() {
        super(null);
    }

    public void setRemoteMacAddress(MacAddress remoteMacAddress) {
        MacAddress tempRemoteMacAddress;
        String filter;
        this.remoteMacAddress = remoteMacAddress;
        if (this.receiveHandle != null && this.receiveHandle.isOpen() && (filter = this.config.getMacBasedFilterString(this.localMacAddress, tempRemoteMacAddress = remoteMacAddress != null ? remoteMacAddress : MacAddress.getByAddress((byte[])new byte[]{0, 0, 0, 0, 0, 0}))).length() > 0) {
            try {
                this.receiveHandle.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
            }
            catch (NotOpenException | PcapNativeException e) {
                throw new RuntimeException("Error updating filter expression");
            }
        }
    }

    protected boolean isInputShutdown() {
        return false;
    }

    protected ChannelFuture shutdownInput() {
        throw new NotImplementedException("");
    }

    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        MacAddress tempRemoteMacAddress;
        String filter;
        if (!(remoteAddress instanceof RawSocketPassiveAddress) && !(remoteAddress instanceof InetSocketAddress)) {
            logger.error("Expecting remote address of type RawSocketPassiveAddress or InetSocketAddress");
            this.pipeline().fireExceptionCaught((Throwable)new PcapException("Expecting remote address of type RawSocketPassiveAddress or InetSocketAddress"));
            return;
        }
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        PcapNetworkInterface nif = null;
        if (remoteAddress instanceof RawSocketPassiveAddress) {
            RawSocketPassiveAddress rawSocketPassiveAddress = (RawSocketPassiveAddress)((Object)remoteAddress);
            String deviceName = this.getDeviceName(rawSocketPassiveAddress);
            if (deviceName == null) {
                logger.error("Network device not specified and couldn't detect it automatically");
                this.pipeline().fireExceptionCaught((Throwable)new PcapException("Network device not specified and couldn't detect it automatically"));
                return;
            }
            nif = Pcaps.getDevByName((String)deviceName);
        } else {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
            InetAddress address = inetSocketAddress.getAddress();
            block0: for (PcapNetworkInterface dev : Pcaps.findAllDevs()) {
                if (dev.isLoopBack()) continue;
                for (PcapAddress curAddress : dev.getAddresses()) {
                    SubnetUtils.SubnetInfo subnetInfo;
                    if (curAddress.getAddress() == null || curAddress.getNetmask() == null || address instanceof Inet4Address && !(curAddress instanceof PcapIpV4Address) || address instanceof Inet6Address && !(curAddress instanceof PcapIpV6Address) || !(subnetInfo = new SubnetUtils(curAddress.getAddress().getHostAddress(), curAddress.getNetmask().getHostAddress()).getInfo()).isInRange(address.getHostAddress())) continue;
                    nif = dev;
                    this.localAddress = new InetSocketAddress(curAddress.getAddress(), 0);
                    this.localMacAddress = dev.getLinkLayerAddresses().stream().filter(linkLayerAddress -> linkLayerAddress instanceof MacAddress).map(linkLayerAddress -> (MacAddress)linkLayerAddress).findFirst().orElse(null);
                    break block0;
                }
            }
        }
        if (nif == null) {
            logger.error(String.format("Couldn't find network device for %s", remoteAddress));
            this.pipeline().fireExceptionCaught((Throwable)new PcapException(String.format("Couldn't find network device for %s", remoteAddress)));
            return;
        }
        if (this.config.isResolveMacAddress() && this.remoteMacAddress == null && this.remoteAddress instanceof InetSocketAddress) {
            this.remoteMacAddress = ArpUtils.resolveMacAddress(nif, (InetSocketAddress)this.remoteAddress, (InetSocketAddress)this.localAddress, this.localMacAddress).orElse(null);
        }
        this.receiveHandle = nif.openLive(65535, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Listening on device %s", nif.getName()));
        }
        if ((filter = this.config.getMacBasedFilterString(this.localMacAddress, tempRemoteMacAddress = this.remoteMacAddress != null ? this.remoteMacAddress : MacAddress.getByAddress((byte[])new byte[]{0, 0, 0, 0, 0, 0}))).length() > 0) {
            this.receiveHandle.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
        }
        ByteBuf buffer = Unpooled.buffer();
        this.loopThread = new Thread(() -> {
            try {
                this.receiveHandle.loop(-1, packet -> buffer.writeBytes(this.config.getPacketHandler().getData(packet)));
            }
            catch (NotOpenException | PcapNativeException e) {
                logger.error("Pcap4j loop thread died!", e);
                this.pipeline().fireExceptionCaught(e);
            }
            catch (InterruptedException e) {
                logger.warn("PCAP Loop Thread was interrupted (hopefully intentionally)", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
        this.loopThread.start();
        if (remoteAddress instanceof RawSocketPassiveAddress) {
            this.activate(new PcapInputStream(buffer), new DiscardingOutputStream());
        } else {
            PcapHandle sendHandle = nif.openLive(65535, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
            this.activate(new PcapInputStream(buffer), new PcapOutputStream(sendHandle));
        }
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    protected void doBind(SocketAddress localAddress) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void doDisconnect() {
        this.loopThread.interrupt();
        if (this.receiveHandle != null) {
            this.receiveHandle.close();
        }
    }

    protected int doReadBytes(ByteBuf buf) throws Exception {
        if (this.receiveHandle == null || !this.receiveHandle.isOpen()) {
            return -1;
        }
        try {
            return super.doReadBytes(buf);
        }
        catch (SocketTimeoutException ignored) {
            return 0;
        }
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return true;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new RawSocketUnsafe();
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public MacAddress getRemoteMacAddress() {
        return this.remoteMacAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public MacAddress getLocalMacAddress() {
        return this.localMacAddress;
    }

    private String getDeviceName(RawSocketPassiveAddress rawSocketAddress) {
        if (rawSocketAddress.getDeviceName() != null) {
            return rawSocketAddress.getDeviceName();
        }
        return null;
    }

    private static class PcapInputStream
    extends InputStream {
        final ByteBuf buf;

        private PcapInputStream(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public int available() {
            return this.buf.readableBytes();
        }

        @Override
        public int read() throws IOException {
            long timeout = System.nanoTime() + 10000L;
            while (System.nanoTime() < timeout) {
                if (this.buf.readableBytes() <= 0) continue;
                return this.buf.readByte() & 0xFF;
            }
            throw new SocketTimeoutException();
        }
    }

    private static class DiscardingOutputStream
    extends OutputStream {
        private DiscardingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            logger.debug("Discarding {}", (Object)b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            logger.debug("Discarding {}", (Object)b);
        }
    }

    private static class PcapOutputStream
    extends OutputStream {
        private final PcapHandle sendHandle;

        public PcapOutputStream(PcapHandle sendHandle) {
            this.sendHandle = sendHandle;
        }

        @Override
        public void write(int b) throws IOException {
            throw new RuntimeException("write(byte) should never be called in a RawSocketChannel");
        }

        @Override
        public void write(byte[] packetBytes, int offset, int len) throws IOException {
            if (offset < 0 || len < 0 || offset + len > packetBytes.length) {
                throw new IndexOutOfBoundsException();
            }
            try {
                EthernetPacket rawPacket = EthernetPacket.newPacket((byte[])packetBytes, (int)offset, (int)len);
                this.sendHandle.sendPacket((Packet)rawPacket);
            }
            catch (NotOpenException | PcapNativeException | IllegalRawDataException e) {
                throw new IOException("Error sending packet", e);
            }
        }
    }

    private class RawSocketUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private RawSocketUnsafe() {
            super((AbstractChannel)RawSocketChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            try {
                RawSocketChannel.this.doConnect(remoteAddress, localAddress);
                RawSocketChannel.this.pipeline().fireChannelActive();
                promise.setSuccess();
            }
            catch (Exception e) {
                promise.setFailure((Throwable)e);
            }
        }
    }
}

