/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config.processor;

import java.io.IOException;
import java.util.Properties;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.processor.ConfigDataType;
import org.apache.seata.config.processor.Processor;

public class ConfigProcessor {
    private static final String SEPARATOR = ".";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String DEFAULT_DATA_TYPE = "properties";

    public static Properties processConfig(String config, String dataType) throws IOException {
        return EnhancedServiceLoader.load(Processor.class, dataType).processor(config);
    }

    public static String resolverConfigDataType(String dataId) {
        return ConfigProcessor.resolverConfigDataType(FILE_CONFIG.getConfig(ConfigProcessor.getDataTypeKey()), dataId, DEFAULT_DATA_TYPE);
    }

    public static String resolverConfigDataType(String dataType, String dataId, String defaultDataType) {
        if (StringUtils.isNotBlank(dataType)) {
            return dataType;
        }
        if (!dataId.contains(SEPARATOR)) {
            return defaultDataType;
        }
        String[] splitString = dataId.split("\\.");
        try {
            ConfigDataType configDataType = ConfigDataType.getTypeBySuffix(splitString[splitString.length - 1]);
            return configDataType.name();
        }
        catch (IllegalArgumentException e) {
            return defaultDataType;
        }
    }

    private static String getDataTypeKey() {
        return String.join((CharSequence)SEPARATOR, "config", "dataType");
    }
}

