/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.sql.struct.cache;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.rm.datasource.sql.struct.cache.AbstractTableMetaCache;
import org.apache.seata.sqlparser.struct.ColumnMeta;
import org.apache.seata.sqlparser.struct.IndexMeta;
import org.apache.seata.sqlparser.struct.IndexType;
import org.apache.seata.sqlparser.struct.TableMeta;

@LoadLevel(name="oscar")
public class OscarTableMetaCache
extends AbstractTableMetaCache {
    @Override
    protected String getCacheKey(Connection connection, String tableName, String resourceId) {
        String defaultTableName;
        StringBuilder cacheKey = new StringBuilder(resourceId);
        cacheKey.append(".");
        String[] tableNameWithSchema = tableName.split("\\.");
        String string = defaultTableName = tableNameWithSchema.length > 1 ? tableNameWithSchema[1] : tableNameWithSchema[0];
        if (defaultTableName.contains("\"")) {
            cacheKey.append(defaultTableName.replace("\"", ""));
        } else {
            cacheKey.append(defaultTableName.toUpperCase());
        }
        return cacheKey.toString();
    }

    @Override
    protected TableMeta fetchSchema(Connection connection, String tableName) throws SQLException {
        try {
            return this.resultSetMetaToSchema(connection.getMetaData(), tableName);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e) {
            throw new SQLException(String.format("Failed to fetch schema of %s", tableName), e);
        }
    }

    private TableMeta resultSetMetaToSchema(DatabaseMetaData dbmd, String tableName) throws SQLException {
        TableMeta tm;
        block48: {
            tm = new TableMeta();
            tm.setTableName(tableName);
            String[] schemaTable = tableName.split("\\.");
            String schemaName = schemaTable.length > 1 ? schemaTable[0] : dbmd.getConnection().getSchema();
            tableName = schemaTable.length > 1 ? schemaTable[1] : tableName;
            schemaName = schemaName.contains("\"") ? schemaName.replace("\"", "") : schemaName.toUpperCase();
            tableName = tableName.contains("\"") ? tableName.replace("\"", "") : tableName.toUpperCase();
            tm.setCaseSensitive(StringUtils.hasLowerCase(tableName));
            try (ResultSet rsColumns = dbmd.getColumns("", schemaName, tableName, "%");
                 ResultSet rsIndex = dbmd.getIndexInfo(null, schemaName, tableName, false, true);
                 ResultSet rsPrimary = dbmd.getPrimaryKeys(null, schemaName, tableName);){
                while (rsColumns.next()) {
                    ColumnMeta col = new ColumnMeta();
                    col.setTableCat(rsColumns.getString("TABLE_CAT"));
                    col.setTableSchemaName(rsColumns.getString("TABLE_SCHEM"));
                    col.setTableName(rsColumns.getString("TABLE_NAME"));
                    col.setColumnName(rsColumns.getString("COLUMN_NAME"));
                    col.setDataType(rsColumns.getInt("DATA_TYPE"));
                    col.setDataTypeName(rsColumns.getString("TYPE_NAME"));
                    col.setColumnSize(rsColumns.getInt("COLUMN_SIZE"));
                    col.setDecimalDigits(rsColumns.getInt("DECIMAL_DIGITS"));
                    col.setNumPrecRadix(rsColumns.getInt("NUM_PREC_RADIX"));
                    col.setNullAble(rsColumns.getInt("NULLABLE"));
                    col.setRemarks(rsColumns.getString("REMARKS"));
                    col.setColumnDef(rsColumns.getString("COLUMN_DEF"));
                    col.setSqlDataType(rsColumns.getInt("SQL_DATA_TYPE"));
                    col.setSqlDatetimeSub(rsColumns.getInt("SQL_DATETIME_SUB"));
                    col.setCharOctetLength(rsColumns.getInt("CHAR_OCTET_LENGTH"));
                    col.setOrdinalPosition(rsColumns.getInt("ORDINAL_POSITION"));
                    col.setIsNullAble(rsColumns.getString("IS_NULLABLE"));
                    col.setCaseSensitive(StringUtils.hasLowerCase(col.getColumnName()));
                    if (tm.getAllColumns().containsKey(col.getColumnName())) {
                        throw new NotSupportYetException("Not support the table has the same column name with different case yet");
                    }
                    tm.getAllColumns().put(col.getColumnName(), col);
                }
                while (rsIndex.next()) {
                    IndexMeta index;
                    String indexName = rsIndex.getString("INDEX_NAME");
                    if (StringUtils.isNullOrEmpty(indexName)) continue;
                    String colName = rsIndex.getString("COLUMN_NAME");
                    ColumnMeta col = tm.getAllColumns().get(colName);
                    if (tm.getAllIndexes().containsKey(indexName)) {
                        index = tm.getAllIndexes().get(indexName);
                        index.getValues().add(col);
                        continue;
                    }
                    index = new IndexMeta();
                    index.setIndexName(indexName);
                    index.setNonUnique(rsIndex.getBoolean("NON_UNIQUE"));
                    index.setIndexQualifier(rsIndex.getString("INDEX_QUALIFIER"));
                    index.setIndexName(rsIndex.getString("INDEX_NAME"));
                    index.setType(rsIndex.getShort("TYPE"));
                    index.setOrdinalPosition(rsIndex.getShort("ORDINAL_POSITION"));
                    index.setAscOrDesc(rsIndex.getString("ASC_OR_DESC"));
                    index.setCardinality(rsIndex.getLong("CARDINALITY"));
                    index.getValues().add(col);
                    if (!index.isNonUnique()) {
                        index.setIndextype(IndexType.UNIQUE);
                    } else {
                        index.setIndextype(IndexType.NORMAL);
                    }
                    tm.getAllIndexes().put(indexName, index);
                }
                if (tm.getAllIndexes().isEmpty()) {
                    throw new ShouldNeverHappenException(String.format("Could not found any index in the table: %s", tableName));
                }
                ArrayList<String> pkcol = new ArrayList<String>();
                while (rsPrimary.next()) {
                    String pkConstraintName = rsPrimary.getString("PK_NAME");
                    if (tm.getAllIndexes().containsKey(pkConstraintName)) {
                        IndexMeta index = tm.getAllIndexes().get(pkConstraintName);
                        index.setIndextype(IndexType.PRIMARY);
                        continue;
                    }
                    pkcol.add(rsPrimary.getString("COLUMN_NAME"));
                }
                if (pkcol.isEmpty()) break block48;
                int matchCols = 0;
                for (Map.Entry<String, IndexMeta> entry : tm.getAllIndexes().entrySet()) {
                    IndexMeta index = entry.getValue();
                    if (index.getIndextype().value() != IndexType.UNIQUE.value()) continue;
                    for (ColumnMeta col : index.getValues()) {
                        if (!pkcol.contains(col.getColumnName())) continue;
                        ++matchCols;
                    }
                    if (matchCols == pkcol.size()) {
                        index.setIndextype(IndexType.PRIMARY);
                        break;
                    }
                    matchCols = 0;
                }
            }
        }
        return tm;
    }
}

